/* This file is part of the KDE project
   Copyright (C) 2001, 2002, 2003 The Karbon Developers

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef __VDOCUMENTDOCKER_H__
#define __VDOCUMENTDOCKER_H__

#include <tqlistview.h>
#include <tqptrdict.h>

class TQHButtonGroup;
class TQPoint;
class TQLabel;
class TQPixmap;
class TQCheckBox;

class VDocument;
class VLayer;
class KarbonView;

/*************************************************************************
 *  Document Tab                                                         *
 *************************************************************************/

class VDocumentPreview : public TQWidget
{
	TQ_OBJECT
  

	public:
		VDocumentPreview( KarbonView* view, TQWidget* parent = 0 );
		~VDocumentPreview();

		void reset();

	protected:
		void paintEvent( TQPaintEvent* e );
		virtual bool eventFilter( TQObject* object, TQEvent* event );

	private:
		VDocument	*m_document;
		KarbonView	*m_view;
		KoPoint		m_firstPoint;
		KoPoint		m_lastPoint;
		bool		m_dragging;
		TQPixmap		*m_docpixmap;
}; // VDocumentPreview

class VDocumentTab : public TQWidget
{
	TQ_OBJECT
  

	public:
		VDocumentTab( KarbonView* view, TQWidget* parent );
		~VDocumentTab();

	public slots:
		void updateDocumentInfo();
		void slotCommandAdded( VCommand* command );
		void slotZoomChanged( double );
		void slotViewportChanged();
		void slotCommandExecuted();

	private:
		VDocumentPreview*	m_documentPreview;
		TQLabel*				m_height;
		TQLabel*				m_width;
		TQLabel*				m_layers;
		TQLabel*				m_format;

		KarbonView*			m_view;
}; // VDocumentTab

/*************************************************************************
 *  Layers Tab                                                           *
 *************************************************************************/

class VLayerListViewItem : public TQCheckListItem
{
public:
	VLayerListViewItem( TQListView* parent, VLayer* layer, VDocument *doc, TQPtrDict<VLayerListViewItem> *map );
	virtual ~VLayerListViewItem();

	VLayer* layer() { return m_layer; }
	int pos();
	void update();
	virtual TQString key( int column, bool ascending ) const;
	virtual int compare( TQListViewItem *i, int col, bool ascending ) const;
	void setKey( uint key ) { m_key = key; }

protected:
	virtual void stateChange( bool on );

private:
	VLayer		*m_layer;
	VDocument	*m_document;
	uint		 m_key;
	TQPtrDict<VLayerListViewItem> *m_map;
}; // VLayerListViewItem

class VObjectListViewItem : public TQListViewItem
{
public:
	VObjectListViewItem( TQListViewItem* parent, VObject* object, VDocument *doc, uint key, TQPtrDict<VObjectListViewItem> *map );
	virtual ~VObjectListViewItem();

	VObject* object() { return m_object; }
	void update();
	virtual TQString key( int column, bool ascending ) const;
	virtual int compare( TQListViewItem *i, int col, bool ascending ) const;
	void setKey( uint key ) { m_key = key; }
private:
	VObject		*m_object;
	VDocument	*m_document;
	uint		 m_key;
	TQPtrDict<VObjectListViewItem> *m_map;
};

class VLayersTab : public TQWidget
{
TQ_OBJECT
  

public:
	VLayersTab( KarbonView* view, TQWidget* parent = 0 );
	~VLayersTab();

public slots:
	void updatePreviews();
	void updateLayers();

	void itemClicked( TQListViewItem* item, const TQPoint&, int col );
	void selectionChangedFromList();
	void selectionChangedFromTool();
	void renameItem( TQListViewItem* item, const TQPoint&, int col );
	void addLayer();
	void raiseItem();
	void lowerItem();
	void deleteItem();
	void slotCommandExecuted( VCommand* command );

private slots:
	void slotButtonClicked( int ID );
	void removeDeletedObjectsFromList();
	void updateChildItems( TQListViewItem *item );
	void toggleState( VObject *obj, int col );

protected:
	VLayerListViewItem* listItem( int pos );
	void updateObjects( VObject *object, TQListViewItem *item );
	void resetSelection();
	void selectActiveLayer();

private:
	TQListView						*m_layersListView;
	TQHButtonGroup					*m_buttonGroup;
	KarbonView						*m_view;
	VDocument						*m_document;
	TQPtrDict<VLayerListViewItem>	m_layers;
	TQPtrDict<VObjectListViewItem>	m_objects;
}; // VLayersTab

/*************************************************************************
 *  History Tab                                                          *
 *************************************************************************/

class VHistoryItem;
 
class VHistoryGroupItem : public TQListViewItem
{
	public:
		VHistoryGroupItem( VHistoryItem* item, TQListView* parent, TQListViewItem* after );
		~VHistoryGroupItem();

		void paintCell( TQPainter* p, const TQColorGroup& cg, int column, int width, int align );
		void paintFocus( TQPainter*, const TQColorGroup&, const TQRect& );

		virtual TQString key( int, bool ) const { return m_key; }
		virtual int rtti() const { return 1001; }

	private:
		TQString	m_key;
}; // VHistoryGroupItem
 
class VHistoryItem : public TQListViewItem
{
	public:
		VHistoryItem( VCommand* command, TQListView* parent, TQListViewItem* after );
		VHistoryItem( VCommand* command, VHistoryGroupItem* parent, TQListViewItem* after );
		~VHistoryItem();

		VCommand* command() { return m_command; }

		void paintCell( TQPainter* p, const TQColorGroup& cg, int column, int width, int align );
		void paintFocus( TQPainter*, const TQColorGroup&, const TQRect& );

		virtual TQString key( int, bool ) const { return m_key; }
		virtual int rtti() const { return 1002; }

	private:
		void init();

		TQString     m_key;
		VCommand*   m_command;
}; // VHistoryItem

class VHistoryTab : public TQWidget
{
	TQ_OBJECT
  

	public:
		VHistoryTab( KarbonPart* part, TQWidget* parent );
		~VHistoryTab();

		bool groupingEnabled();

	public slots:
		void historyCleared();
		void commandExecuted( VCommand* command );
		void slotCommandAdded( VCommand* command );
		void removeFirstCommand();
		void removeLastCommand();

		void commandClicked( int button, TQListViewItem* item, const TQPoint& point, int col );
		void groupingChanged( int );

	signals:
		void undoCommand( VCommand* command );
		void redoCommand( VCommand* command );
		void undoCommandsTo( VCommand* command );
		void redoCommandsTo( VCommand* command );

	private:
		TQListView*      m_history;
		TQListViewItem*  m_lastCommand;
		TQCheckBox*      m_groupCommands;
		long            m_lastCommandIndex;

		KarbonPart*     m_part;
}; // VHistoryTab

#endif

