/* This file is part of the KOffice project
   Copyright (C) 2002 Werner Trobin <trobin@kde.org>
   Copyright (C) 2002 David Faure <faure@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License version 2 as published by the Free Software Foundation.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef CONVERSION_H
#define CONVERSION_H

#include <tqstring.h>
#include <tqpair.h>

// Static methods for simple OO<->KWord conversions
// (enums etc.)
// import* means OO->KWord
// export* means KWord->OO
// Only put here the conversions that are specific to KWord.
// Those that can be used in KPresenter<->ooimpress should go to OoUtils.

namespace Conversion
{
    // Convert paragraph alignment value
    TQString importAlignment( const TQString& );
    TQString exportAlignment( const TQString& );

    // Convert frame wrapping (run-around)
    // KWord-1.3 knows runaround(int) and runaroundSide(TQString)
    TQPair<int,TQString> importWrapping( const TQString& );
    TQString exportWrapping( const TQPair<int,TQString>& runAroundAttribs );

    // Convert overflow behavior ("what to do if the text is bigger than the frame")
    int importOverflowBehavior( const TQString& oasisOverflowBehavior );
    TQString exportOverflowBehavior( const TQString& kwordAutoCreateNewFrame );

    // Convert numbering format (for a list) to a kword counter type
    int importCounterType( const TQString& numFormat );

    // Header-footer helpers
    TQString headerTypeToFramesetName( const TQString& tagName, bool hasEvenOdd );
    int headerTypeToFrameInfo( const TQString& tagName, bool hasEvenOdd );
}

#endif
