/*
 *  Copyright (c) 2004 Bart Coppens <kde@bartcoppens.be>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef KIS_TOOL_TEXT_H_
#define KIS_TOOL_TEXT_H_

#include "kis_tool_paint.h"

#include "kis_tool_factory.h"

class TQFont;
class TQLabel;
class TQWidget;
class TQPushButton;
class KSqueezedTextLabel;



class KisToolText : public KisToolPaint {
    typedef KisToolPaint super;
    TQ_OBJECT
  

public:
    KisToolText();
    virtual ~KisToolText();

    virtual void update(KisCanvasSubject *subject);
    virtual void setup(TDEActionCollection *collection);
    virtual enumToolType toolType() { return TOOL_FILL; }
    virtual TQ_UINT32 priority() { return 2; }
    virtual void buttonPress(KisButtonPressEvent*);
    virtual void buttonRelease(KisButtonReleaseEvent *e);

    virtual TQWidget* createOptionWidget(TQWidget* parent);
public slots:
    virtual void setFont();

private:
    KisCanvasSubject *m_subject;
    TQFont m_font;
    TQLabel *m_lbFont;
    KSqueezedTextLabel *m_lbFontName;
    TQPushButton *m_btnMoreFonts;
    bool m_wasPressed; // use for preventing bug:136151
    bool m_windowIsBeingShown;
};


class KisToolTextFactory : public KisToolFactory {
    typedef KisToolFactory super;
public:
    KisToolTextFactory() : super() {};
    virtual ~KisToolTextFactory(){};
    
    virtual KisTool * createTool(TDEActionCollection * ac) {
        KisTool * t =  new KisToolText(); 
        TQ_CHECK_PTR(t);
        t->setup(ac); 
        return t; 
    }
    virtual KisID id() { return KisID("text", i18n("Text Tool")); }
};


#endif // KIS_TOOL_TEXT_H_
