#include "kformula_factory.h"
#include "kformula_doc.h"
#include "kformula_aboutdata.h"

#include <tdeinstance.h>
#include <kiconloader.h>

#include <tdefiledialog.h>
#include <tdeglobal.h>
#include <tdestandarddirs.h>
#include <tdelocale.h>

#include <tqstringlist.h>

K_EXPORT_COMPONENT_FACTORY( libkformulapart, KFormulaFactory )

TDEInstance* KFormulaFactory::s_global = 0;
TDEAboutData* KFormulaFactory::s_aboutData = 0;

TDEAboutData* KFormulaFactory::aboutData()
{
    if( !s_aboutData )
        s_aboutData=newKFormulaAboutData();
    return s_aboutData;
}


KFormulaFactory::KFormulaFactory( TQObject* parent, const char* name )
    : KoFactory( parent, name )
{
    // Create our instance, so that it becomes TDEGlobal::instance if the
    // main app is KFormula.
    (void)global();
}

KFormulaFactory::~KFormulaFactory()
{
  delete s_aboutData;
  s_aboutData=0;
  delete s_global;
  s_global = 0L;
}

KParts::Part* KFormulaFactory::createPartObject( TQWidget *parentWidget, const char *widgetName, TQObject* parent, const char* name, const char* classname, const TQStringList & )
{
  bool bWantKoDocument = ( strcmp( classname, "KoDocument" ) == 0 );

  KFormulaDoc *doc = new KFormulaDoc( parentWidget, widgetName, parent, name, !bWantKoDocument );

  if ( !bWantKoDocument )
    doc->setReadWrite( false );

  return doc;
}

TDEInstance* KFormulaFactory::global()
{
    if ( !s_global )
    {
      s_global = new TDEInstance(aboutData());
      s_global->dirs()->addResourceType( "toolbar",
				         TDEStandardDirs::kde_default("data") + "koffice/toolbar/");
      // Tell the iconloader about share/apps/koffice/icons*/
      s_global->iconLoader()->addAppDir("koffice");
    }

    return s_global;
}

#include "kformula_factory.moc"
