/***************************************************************************
                          mymoneystatement.h
                          -------------------
    begin                : Mon Aug 30 2004
    copyright            : (C) 2000-2004 by Michael Edwardes
    email                : mte@users.sourceforge.net
                           Javier Campos Morales <javi_c@users.sourceforge.net>
                           Felix Rodriguez <frodriguez@users.sourceforge.net>
                           John C <thetacoturtle@users.sourceforge.net>
                           Thomas Baumgart <ipwizard@users.sourceforge.net>
                           Kevin Tambascio <ktambascio@users.sourceforge.net>
                           Ace Jones <acejones@users.sourceforge.net>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MYMONEYSTATEMENT_H
#define MYMONEYSTATEMENT_H

// ----------------------------------------------------------------------------
// TQt Includes

#include <tqstring.h>
#include <tqvaluelist.h>
#include <tqdatetime.h>

// ----------------------------------------------------------------------------
// Project Includes

#include <kmymoney/export.h>
#include <kmymoney/mymoneymoney.h>
#include <kmymoney/mymoneysplit.h>

class TQDomElement;
class TQDomDocument;

/**
Represents the electronic analog of the paper bank statement just like we used to get in the regular mail.  This class is designed to be easy to extend and easy to create with minimal dependencies.  So the header file should include as few project files as possible (preferrably NONE).

@author ace jones
*/
class MyMoneyStatement
{
public:
  MyMoneyStatement() : m_closingBalance(MyMoneyMoney::autoCalc), m_eType(etNone), m_skipCategoryMatching(false) {}

  enum EType { etNone = 0, etCheckings, etSavings, etInvestment, etCreditCard, etEnd };

  class Split {
  public:
    Split() : m_reconcile(MyMoneySplit::NotReconciled) {}
    TQString      m_strCategoryName;
    TQString      m_strMemo;
    TQString      m_accountId;
    MyMoneySplit::reconcileFlagE m_reconcile;
    MyMoneyMoney m_amount;

  };

  class Transaction {
  public:
    Transaction() : m_reconcile(MyMoneySplit::NotReconciled), m_eAction(eaNone) {}
    TQDate m_datePosted;
    TQString m_strPayee;
    TQString m_strMemo;
    TQString m_strNumber;
    TQString m_strBankID;
    MyMoneyMoney m_amount;
    MyMoneySplit::reconcileFlagE m_reconcile;

    // the following members are only used for investment accounts (m_eType==etInvestment)
    // eaNone means the action, shares, and security can be ignored.
    enum EAction { eaNone = 0, eaBuy, eaSell, eaReinvestDividend, eaCashDividend, eaShrsin, eaShrsout, eaStksplit, eaFees, eaInterest, eaEnd };
    EAction m_eAction;
    MyMoneyMoney m_shares;
    MyMoneyMoney m_fees;
    MyMoneyMoney m_price;
    TQString m_strInterestCategory;
    TQString m_strBrokerageAccount;
    TQString m_strSymbol;
    TQString m_strSecurity;
    TQValueList<Split> m_listSplits;
  };

  struct Price
  {
    TQDate m_date;
    TQString m_strSecurity;
    MyMoneyMoney m_amount;
  };

  struct Security
  {
    TQString m_strName;
    TQString m_strSymbol;
    TQString m_strId;
  };

  TQString m_strAccountName;
  TQString m_strAccountNumber;
  TQString m_strRoutingNumber;

  /**
   * The statement provider's information for the statement reader how to find the
   * account. The provider usually leaves some value with a key unique to the provider in the KVP of the
   * MyMoneyAccount object when setting up the connection or at a later point in time.
   * Using the KMyMoneyPlugin::KMMStatementInterface::account() method it can retrieve the
   * MyMoneyAccount object for this key. The account id of that account should be returned
   * here. If no id is available, leave it empty.
   */
  TQString m_accountId;

  TQString m_strCurrency;
  TQDate m_dateBegin;
  TQDate m_dateEnd;
  MyMoneyMoney m_closingBalance;
  EType m_eType;

  TQValueList<Transaction> m_listTransactions;
  TQValueList<Price> m_listPrices;
  TQValueList<Security> m_listSecurities;

  bool m_skipCategoryMatching;

  void write(TQDomElement&,TQDomDocument*) const;
  bool read(const TQDomElement&);

  KMYMONEY_EXPORT static bool isStatementFile(const TQString&);
  KMYMONEY_EXPORT static bool readXMLFile( MyMoneyStatement&, const TQString& );
  KMYMONEY_EXPORT static void writeXMLFile( const MyMoneyStatement&, const TQString& );
};

#endif
