/***************************************************************************
                          kequitypriceupdatedlg.h  -  description
                             -------------------
    begin                : Tuesday June 22nd, 2004
    copyright            : (C) 2000-2004 by Kevin Tambascio
    email                : mte@users.sourceforge.net
                           Javier Campos Morales <javi_c@users.sourceforge.net>
                           Felix Rodriguez <frodriguez@users.sourceforge.net>
                           John C <thetacoturtle@users.sourceforge.net>
                           Thomas Baumgart <ipwizard@users.sourceforge.net>
                           Kevin Tambascio <ktambascio@users.sourceforge.net>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KEQUITYPRICEUPDATEDIALOG_H
#define KEQUITYPRICEUPDATEDIALOG_H

// ----------------------------------------------------------------------------
// TQt Includes

#include <tqwidget.h>
#include <tqpair.h>
#include <tqdatastream.h>
class TQListViewItem;

// ----------------------------------------------------------------------------
// TDE Includes

#include <tdeprocess.h>

// ----------------------------------------------------------------------------
// Project Includes

#include "../converter/webpricequote.h"
#include "../mymoney/mymoneysecurity.h"
#include "../mymoney/mymoneyprice.h"
#include "../dialogs/kequitypriceupdatedlgdecl.h"

/**
  * @author Kevin Tambascio & Ace Jones
  */

class KEquityPriceUpdateDlg : public KEquityPriceUpdateDlgDecl
{
  TQ_OBJECT
  
public:
  KEquityPriceUpdateDlg(TQWidget *parent, const TQString& securityId = TQString());
  ~KEquityPriceUpdateDlg();
  void storePrices(void);
  MyMoneyPrice price(const TQString& id) const;

protected slots:
  void slotUpdateSelectedClicked(void);
  void slotUpdateAllClicked(void);
  void slotUpdateSelection(void);

  void logStatusMessage(const TQString&);
  void logErrorMessage(const TQString&);
  void slotReceivedQuote(const TQString&, const TQString&,const TQDate&, const double&);
  void slotQuoteFailed(const TQString& _id, const TQString& _symbol);

protected:
  void addPricePair(const MyMoneySecurityPair& pair, bool dontCheckExistance = false);
  void addInvestment(const MyMoneySecurity& inv);
  void finishUpdate(void);

private:
  bool m_fUpdateAll;
  WebPriceQuote m_webQuote;
};

#endif
