/*
 *   main.cpp
 *
 *   Copyright (C) 2003,2004 Waldo Bastian <bastian@kde.org>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License versin 2 as
 *   published by the Free Software Foundation.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
#include "kioskgui.h"

#include <dcopclient.h>

#include <tqfile.h>

#include <tdeaboutdata.h>
#include <tdeapplication.h>
#include <tdecmdlineargs.h>
#include <tdeversion.h>
#include <tdelocale.h>
#include <tdemessagebox.h>

static const char *description =
	I18N_NOOP("KIOSK Admin Tool");

static const char *version = "1.0";

#ifndef KDERC
#define KDERC      "/etc/tderc"
#endif

static const TDECmdLineOptions options[] =
{
   { "tderc <file>", I18N_NOOP("tderc file to save settings to"), KDERC },
   TDECmdLineLastOption
};

int main(int argc, char *argv[])
{
   TDEAboutData aboutData( "kiosktool", I18N_NOOP("KIOSK Admin Tool"),
                         version, description, TDEAboutData::License_GPL_V2,
                         "(c) 2003,2004 Waldo Bastian");
   aboutData.addAuthor("Waldo Bastian",I18N_NOOP("Author"), "bastian@kde.org");

   TDECmdLineArgs::init(argc, argv, &aboutData);

   TDECmdLineArgs::addCmdLineOptions( options );

   TDEApplication a;
   
   KioskGui *w = new KioskGui();
   a.setMainWidget(w);
   w->show();
   
   bool versionOk;
   if (TQFile::exists("/etc/SuSE-release"))
      versionOk = KDE::version() >= TDE_MAKE_VERSION(3,2,1);
   else
      versionOk = KDE::version() >= TDE_MAKE_VERSION(3,2,2);
   
   if (!versionOk)
   {
      KMessageBox::information(w, i18n("<qt>KIOSK Admin Tool requires KDE 3.2.2 or later!<p>"
                                       "With older versions you may experience problems with"
                                       "the <i>Setup</i> functionality of the various components."));
   }
   
   tdeApp->exec();

   return 0;
}
