/*
 * This file is part of the KFTPGrabber project
 *
 * Copyright (C) 2003-2004 by the KFTPGrabber developers
 * Copyright (C) 2003-2004 Jernej Kos <kostko@jweb-network.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * is provided AS IS, WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, and
 * NON-INFRINGEMENT.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */

#include "misc.h"

#include <kurl.h>
#include <kmdcodec.h>
#include <tdeapplication.h>
#include <tdestandarddirs.h>
#include <tdeconfig.h>

#include <tqcolor.h>
#include <tqpixmapcache.h>

#include <X11/Xlib.h>

namespace KFTPGrabberBase {

TQPixmap loadPanelPixmap(const TQString &name)
{
  return TDEGlobal::iconLoader()->loadIcon(name, TDEIcon::Panel, 0, true);
}

TQIconSet loadToolbarIcon(const TQString &name, int state)
{
  return TDEGlobal::iconLoader()->loadIconSet(name, TDEIcon::Toolbar,0,state);
}

TQIconSet loadSmallIcon(const TQString &name, int state)
{
  return TDEGlobal::iconLoader()->loadIconSet(name, TDEIcon::Small,0,state);
}

TQPixmap loadToolbarPixmap(const TQString &name)
{
  return TDEGlobal::iconLoader()->loadIcon(name, TDEIcon::Toolbar,0, true);
}

TQPixmap loadSmallPixmap(const TQString &name)
{
  return TDEGlobal::iconLoader()->loadIcon(name, TDEIcon::Small,0, true);
}

TQPixmap createColorPixmap(TQString color)
{
  TQPixmap tmp(28, 12);
  tmp.fill(TQColor(color));
  
  TQPixmap pixmap(32, 16);
  pixmap.fill(TQColor(0, 0, 0));
  
  copyBlt(&pixmap, 2, 2, &tmp, 0, 0, 28, 12);

  return pixmap;
}

TQString getStoreDir(const TQString &filename)
{
  return locateLocal("appdata", filename);
}

TQPixmap createProgressPixmap(int progress, int current)
{
  if (progress > 100)
    progress = 100;
    
  if (current > 100)
    current = 100;
    
  TQPixmap pixmap;
  TQString key = TQString("%1:%2").arg(progress).arg(current);
  
  if(!TQPixmapCache::find(key, pixmap)) {
    TQPixmap tmp(100, 16);
    tmp.fill(TQColor(237, 237, 237));
    
    if (progress > 0) {
      TQPixmap p_pix(progress, 16);
      p_pix.fill(TQColor(0, 115, 255));
      
      TQPixmap c_pix(current, 16);
      c_pix.fill(TQColor(0, 88, 192));
      
      copyBlt(&tmp, 0, 0, &p_pix, 0, 0, progress, 16);
      copyBlt(&tmp, 0, 0, &c_pix, 0, 0, current, 16);
    }
    
    TQPixmapCache::insert(key, tmp);
    return tmp;
  }
  
  return pixmap;
}

bool isModifierKeysPressed(unsigned int mask)
{
  Window root;
  Window child;
  int root_x, root_y, win_x, win_y;
  unsigned int keybstate;
  XQueryPointer(tqt_xdisplay(), tqt_xrootwin(), &root, &child, &root_x, &root_y, &win_x, &win_y, &keybstate);

  return keybstate & mask;
}

TQString appendPath(const TQString &path, const TQString &what)
{
  if (path.right(1) == "/")
    return path + what;
  else
    return path + "/" + what;
}

TQString path2Name(const TQString &path)
{
  // Convert full path to filename
  return (path == "/") ? TQString("/") : path.mid(path.findRev('/')+1);
}

TQString path2Dir(const TQString &path)
{
  // Convert full path to path
  return path.mid(0, path.findRev('/'));
}

TQString genID()
{
  return tdeApp->randomString(5);
}

TQString encodePassword(const TQString& password)
{
  return KCodecs::base64Encode(password.ascii(), true).data();
}

TQString decodePassword(const TQString& password)
{
  return KCodecs::base64Decode(password.ascii()).data();
}

TDEConfig *config(const TQString &section)
{
  TDEConfig *conf = tdeApp->config();
  conf->setGroup(section);
  
  return conf;
}

KURL remoteUrl(const TQString &path, KURL url)
{
  if (path.isEmpty())
    return KURL();
    
  KURL tmp = url;
  tmp.setPath(path);
  
  return tmp;
}

} // end namespace

