/***************************************************************************
 *   Copyright (C) 2004-2009 by Thomas Fischer                             *
 *   fischer@unix-ag.uni-kl.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <tqfile.h>
#include <tqapplication.h>
#include <tqregexp.h>
#include <tqbuffer.h>
#include <tqspinbox.h>

#include <klineedit.h>
#include <tdelocale.h>
#include <tdemessagebox.h>
#include <tdeio/netaccess.h>
#include <kurl.h>

#include "fileimporterbibtex.h"
#include "webqueryamatex.h"

namespace KBibTeX
{
    WebQueryAmatexWidget::WebQueryAmatexWidget( TQWidget *parent, const char *name )
            : WebQueryWidget( parent, name )
    {
        init();
    }

    WebQueryAmatex::WebQueryAmatex( TQWidget* parent ): WebQuery( parent )
    {
        m_widget = new WebQueryAmatexWidget( parent );
    }

    WebQueryAmatex::~WebQueryAmatex()
    {
        delete m_widget;
    }

    TQString WebQueryAmatex::title()
    {
        return i18n( "Amatex" );
    }

    TQString WebQueryAmatex::disclaimer()
    {
        return i18n( "About Amatex" );
    }

    TQString WebQueryAmatex::disclaimerURL()
    {
        return TQString( "http://www.2ndminute.org:8080/amatex/pages/about.jsp" );
    }

    WebQueryWidget *WebQueryAmatex::widget()
    {
        return m_widget;
    }

    void WebQueryAmatex::query()
    {
        WebQuery::query();
        int numberOfResults = m_widget->spinBoxMaxHits->value();
        setNumStages( 1 );

        TQString searchTerm = m_widget->lineEditQuery->text().stripWhiteSpace().replace( '$', "" ).replace( '$', "" );
        if ( searchTerm.isEmpty() )
        {
            setEndSearch( WebQuery::statusInvalidQuery );
            return;
        }

        KURL url = KURL( TQString( "http://www.2ndminute.org:8080/amatex/search.do?lang=US&querry=%1&suchart=kwd" ).arg( searchTerm.replace( "%", "%25" ).replace( "+", "%2B" ).replace( " ", "%20" ).replace( "#", "%23" ).replace( "&", "%26" ).replace( "?", "%3F" ) ) );

        TQString key = searchTerm.replace( TQRegExp( "[^-_+A-Za-z0-9]" ), "" );
        int count = 0;
        BibTeX::File *tmpBibFile = downloadBibTeXFile( url );
        if ( tmpBibFile != NULL && !m_aborted )
        {
            for ( BibTeX::File::ElementList::iterator it = tmpBibFile->begin(); !m_aborted && count < numberOfResults && it != tmpBibFile->end(); ++it )
            {
                BibTeX::Entry *entry = dynamic_cast<BibTeX::Entry*>( *it );
                if ( entry != NULL )
                {
                    entry->setId( TQString( "Amatex_%1_%2" ).arg( key ).arg( ++count ) );
                    emit foundEntry( entry, false );
                }
            }

            delete tmpBibFile;
            setEndSearch( WebQuery::statusSuccess );
        }
        else if ( !m_aborted )
        {
            TQString message = TDEIO::NetAccess::lastErrorString();
            if ( message.isEmpty() )
                message.prepend( '\n' );
            message.prepend( TQString( i18n( "Querying database '%1' failed." ) ).arg( title() ) );
            KMessageBox::error( m_parent, message );
            setEndSearch( WebQuery::statusError );
        }
        else
            emit endSearch( WebQuery::statusAborted );

        if ( tmpBibFile != NULL )
            delete tmpBibFile;
    }

}
#include "webqueryamatex.moc"
