/***************************************************************************
 *   Copyright (C) 2004-2009 by Thomas Fischer                             *
 *   fischer@unix-ag.uni-kl.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_YAZ

#ifndef KBIBTEXSETTINGSZ3950_H
#define KBIBTEXSETTINGSZ3950_H

#include <tqwidget.h>

#include "settings.h"

class TQSpinBox;
class KPushButton;
class TDEListView;
class KLineEdit;
class KComboBox;

namespace KBibTeX
{
    class ServerListViewItem: public TDEListViewItem
    {
    public:
        ServerListViewItem( TDEListView *, const TQString &, Settings::Z3950Server& server, bool newItem );
        ServerListViewItem( TDEListViewItem *, const TQString &, Settings::Z3950Server& server, bool newItem );

        void refresh();

    public:
        Settings::Z3950Server server;
        TQString id;
        bool newItem;
    };

    /**
     @author Thomas Fischer <fischer@unix-ag.uni-kl.de>
    */
    class SettingsZ3950Edit : public TQWidget
    {
        TQ_OBJECT
    public:
        ~SettingsZ3950Edit();

        static int execute( TQWidget *parent, TQString &id, Settings::Z3950Server &server );

    protected slots:
        void slotApply();

    protected:
        SettingsZ3950Edit( TQString &id, Settings::Z3950Server&, TQWidget *parent = 0, const char *name = 0 );

    private:
        TQString& m_id;
        Settings::Z3950Server& m_server;
        KLineEdit *m_lineEditId;
        KLineEdit *m_lineEditName;
        KLineEdit *m_lineEditHost;
        TQSpinBox *m_spinBoxPort;
        KLineEdit *m_lineEditDatabase;
        KLineEdit *m_lineEditUser;
        KLineEdit *m_lineEditPassword;
        KComboBox *m_comboBoxSyntax;
        KComboBox *m_comboBoxLocale;
        KComboBox *m_comboBoxCharset;
    };

    /**
     @author Thomas Fischer <fischer@unix-ag.uni-kl.de>
    */
    class SettingsZ3950 : public TQWidget
    {
        TQ_OBJECT
    public:
        SettingsZ3950( TQWidget *parent = 0, const char *name = 0 );
        ~SettingsZ3950();

        void applyData();
        void readData();

    signals:
        void configChanged();

    private slots:
        void slotNewServer();
        void slotEditServer();
        void slotDeleteServer();
        void slotMoveUpServer();
        void slotMoveDownServer();
        void slotResetToDefault();
        void updateGUI();

    private:
        TDEListView *m_listServers;
        KPushButton *m_buttonNewServer;
        KPushButton *m_buttonEditServer;
        KPushButton *m_buttonDeleteServer;
        KPushButton *m_buttonMoveUpServer;
        KPushButton *m_buttonMoveDownServer;
        KPushButton *m_buttonResetToDefault;

        void setupGUI();
    };

}

#endif

#endif // HAVE_YAZ
