/***************************************************************************
*   Copyright (C) 2004-2006 by Thomas Fischer                             *
*   fischer@unix-ag.uni-kl.de                                             *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#ifndef BIBTEXBIBTEXENTRY_H
#define BIBTEXBIBTEXENTRY_H

#include <tqvaluelist.h>
#include <tqstringlist.h>

#include "element.h"
#include "entryfield.h"

class TQString;
class TQStringList;

namespace BibTeX
{

    class Entry : public Element
    {
    public:
        typedef TQValueList<BibTeX::EntryField*> EntryFields;

        enum EntryType {etArticle, etBook, etBooklet, etCollection, etElectronic, etInBook, etInCollection, etInProceedings, etManual, etMastersThesis, etMisc, etPhDThesis, etProceedings, etTechReport, etUnpublished, etUnknown};

        enum FieldRequireStatus {frsRequired, frsOptional, frsIgnored};

        enum MergeSemantics {msAddNew, msForceAdding};

        Entry( );
        Entry( const EntryType entryType, const TQString &id );
        Entry( const TQString& entryTypeString, const TQString& id );
        Entry( const Entry *other );
        virtual ~Entry();
        Element* clone();
        bool equals( const Entry &other );
        TQString text() const;

        void setEntryType( const EntryType elementType );
        void setEntryTypeString( const TQString& elementTypeString );
        EntryType entryType() const;
        TQString entryTypeString() const;
        void setId( const TQString& id );
        TQString id() const;

        bool containsPattern( const TQString& pattern, EntryField::FieldType fieldType = EntryField::ftUnknown, BibTeX::Element::FilterType filterType = BibTeX::Element::ftExact, bool caseSensitive = false ) const;
        TQStringList urls() const;

        bool addField( EntryField *field );
        BibTeX::EntryField* getField( const EntryField::FieldType fieldType ) const;
        BibTeX::EntryField* getField( const TQString& fieldName ) const;
        bool deleteField( const BibTeX::EntryField::FieldType fieldType );
        bool deleteField( const TQString &fieldName );

        EntryFields::const_iterator begin() const;
        EntryFields::const_iterator end() const;
        int getFieldCount() const;
        void clearFields();

        void copyFrom( const BibTeX::Entry *other );
        void merge( BibTeX::Entry *other, MergeSemantics mergeSemantics );

        static TQString entryTypeToString( const EntryType entryType );
        static EntryType entryTypeFromString( const TQString &entryTypeString );
        static Entry::FieldRequireStatus getRequireStatus( Entry::EntryType entryType, EntryField::FieldType fieldType );

    private:
        EntryType m_entryType;
        TQString m_entryTypeString;
        TQString m_id;
        EntryFields m_fields;
    };

}

#endif
