//
// C++ Implementation: 
//
// Description: 
//
//
// Author: Jean-Michel PETIT <k9copy@free.fr>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//


#include "k9processlist.h"
#include <tqstyle.h>
#include <tqpainter.h>
#include <tqpixmap.h>
#include <tqlistview.h>
#include <tqrect.h>
#include <tqprogressbar.h>
#include <tqpixmap.h>
#include <tqapplication.h>
#include <tqeventloop.h>
#include <kpushbutton.h>

class _k9ProcessListItem : public TQListViewItem {
public:
    _k9ProcessListItem(TQListView *_listview,const TQString & _text):TQListViewItem(_listview,_text) {
        m_fileName="";
        m_pos=0;
        m_num=_listview->childCount();
    }
    void setFileName(const TQString &_fileName) { m_fileName=_fileName;}
    void setPos(double _pos) { m_pos=_pos;}

    TQString getFileName() const { return m_fileName;}

    double getPos() const { return m_pos;}
    int compare ( TQListViewItem * i, int col, bool ascending ) const {
        return m_num-((_k9ProcessListItem*)i)->m_num;
    }
private:
    TQString m_fileName;
    double m_pos;
    int m_num;
};


k9ProcessList::k9ProcessList(TQWidget* parent, const char* name, WFlags fl) : processList(parent,name,fl)
{
    m_processes.setAutoDelete(true);
    m_maxProcess=4;  
    connect(&m_timer,TQ_SIGNAL(timeout()),this,TQ_SLOT(timeout()));
    bCancel->setEnabled(false);
}

k9ProcessList::~k9ProcessList()
{
}
/*$SPECIALIZATION$*/
void k9ProcessList::timeout() {
   if (m_waitSync) {
   	TQApplication::eventLoop()->exitLoop();
   	m_waitSync=false;	
   }
}

void k9ProcessList::bCancelClick() {
    m_cancel=true;
    for (k9Process *p=m_processes.first();p;p=m_processes.next()) {
        if (p->isRunning()) 
                p->kill();
    }

}

void k9ProcessList::wait(int _msec) {
  m_waitSync=true;
  m_timer.start(_msec,true);
  TQApplication::eventLoop()->enterLoop();
}

int k9ProcessList::getNbRunning() {
    int res=0;
    for (int i=0;i<m_processes.count();i++) {
        k9Process *p=m_processes.at(i);
        if (p->isRunning())
            res++;
    }
    return res;
}


void k9ProcessList::execute() {
    bCancel->setEnabled(true);
    m_cancel=false;
    m_error=false;
    k9Process *p=NULL;
    for (TQPtrListStdIterator <k9Process> it=m_processes.begin() ;it!=m_processes.end() ;++it ) {
        p=(*it);
        while (getNbRunning() >=m_maxProcess && ! m_cancel) {
            wait(1000);
        }
        if (m_cancel)
            break;
        if (!p->start(TDEProcess::OwnGroup,TDEProcess::All))
            m_error=true;
     }
     //waiting for processes
        for (p=m_processes.first();p;p=m_processes.next()) {
            if (p->isRunning()) 
                    p->sync();
        }
    bCancel->setEnabled(false);
}

void k9ProcessList::addProgress(const TQString &_text) {
    TQListViewItem *item = new _k9ProcessListItem(lProcess,_text);
    TQProgressBar b(this);
    b.setProgress(100,100);
    b.resize(100,40);
    item->setPixmap(0,TQPixmap::grabWidget(&b,0,0,b.width(),b.height()));
}

void k9ProcessList::setProgress (k9Process * _process,int _position, int _total) {
    TQProgressBar b(this);
    b.setProgress(_position,_total);
    b.resize(100,40);
    TQListViewItem *it =m_items[_process];
    it->setPixmap(0,TQPixmap::grabWidget(&b,0,0,b.width(),b.height()));
}

void k9ProcessList::setText(k9Process *_process, const TQString &_text,int _col) {
    TQListViewItem *it =m_items[_process];
    it->setText(_col,_text);
}

void k9ProcessList::setFileName(k9Process *_process,const TQString &_fileName) {
    _k9ProcessListItem *it = (_k9ProcessListItem*)m_items[_process];
    it->setFileName(_fileName);

}

void k9ProcessList::setPos(k9Process *_process,double _pos) {
    _k9ProcessListItem *it = (_k9ProcessListItem*)m_items[_process];
    it->setPos(_pos);
}

k9Process *k9ProcessList::addProcess(const TQString &label) {
    TQString name=TQString("process%1").arg(m_items.count()) ;
    k9Process *process=new k9Process(this,name.latin1());
    m_processes.append(process);
    TQListViewItem *item = new _k9ProcessListItem(lProcess,label);
    m_items[process]=item;
    setProgress(process,0,100);
    connect(process,TQ_SIGNAL(processExited( TDEProcess* )),this,TQ_SLOT(processExited(TDEProcess*)));
    return process;
}

void k9ProcessList::processExited(TDEProcess *_process){
    if (!_process->normalExit())
        m_cancel=true;
    else if (_process->exitStatus() !=0 ) 
        m_error=true;
        
}

#include "k9processlist.moc"

void k9ProcessList::clear() {
    m_processes.clear();
    m_items.clear();
}

int k9ProcessList::getMaxProcess() const {
    return m_maxProcess;
}


void k9ProcessList::setMaxProcess(int _value) {
    m_maxProcess = _value;
}


bool k9ProcessList::getCancel() const {
    return m_cancel;
}


bool k9ProcessList::getError() const {
    return m_error;
}
