/*
Gwenview - A simple image viewer for TDE
Copyright 2000-2004 Aurlien Gteau
 
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 
*/
#ifndef IMAGEFRAME_H
#define IMAGEFRAME_H

// TQt
#include <tqimage.h>
#include <tqvaluevector.h>
namespace Gwenview {

// Local

struct ImageFrame {
	ImageFrame( const TQImage& i, int d ) : image( i ), delay( d ) {};
	ImageFrame() : delay( 0 ) {} // stupid TQt containers
	TQImage image;
	int delay; // how long this frame should be shown in the animation
};

typedef TQValueVector< ImageFrame > ImageFrames;

} // namespace
#endif /* IMAGEFRAME_H */

