#ifndef tdegtk_signal_h
#define tdegtk_signal_h

/*
* this file was largely taken from the oxygen gtk engine
* Copyright (c) 2010 Hugo Pereira Da Costa <hugo@oxygen-icons.org>
*
* This  library is free  software; you can  redistribute it and/or
* modify it  under  the terms  of the  GNU Lesser  General  Public
* License  as published  by the Free  Software  Foundation; either
* version 2 of the License, or(at your option ) any later version.
*
* This library is distributed  in the hope that it will be useful,
* but  WITHOUT ANY WARRANTY; without even  the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License  along  with  this library;  if not,  write to  the Free
* Software Foundation, Inc., 51  Franklin St, Fifth Floor, Boston,
* MA 02110-1301, USA.
*/

#include <gtk/gtk.h>
#include <cassert>
#include <string>

    //! handles gtk signal connections
    class Signal
    {
        public:

        //! constructor
        Signal( void ):
            _id(0),
            _object(0L)
        {}

        //! destructor
        virtual ~Signal( void )
        {}

        //! true if connected
        bool isConnected( void ) const
        { return _id > 0 && _object; }

        //! connect
        bool connect( GObject*, const std::string&, GCallback, gpointer, bool after=false );

        //! disconnect
        void disconnect( void );

        private:

        //! signal id
        guint _id;

        //! connected object
        GObject* _object;

    };

#endif

