/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2007-27-08
 * Description : an tool bar action object to display logo
 *
 * Copyright (C) 2007-2008 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

// TQt includes.

#include <tqtooltip.h>
#include <tqpixmap.h>

// KDE includes.

#include <kurllabel.h>
#include <tdetoolbar.h>
#include <kiconloader.h>
#include <tdeapplication.h>
#include <tdestandarddirs.h>
#include <tdelocale.h>

// Local includes.

#include "daboutdata.h"
#include "dlogoaction.h"
#include "dlogoaction.moc"

namespace Digikam
{

DLogoAction::DLogoAction(TQObject* parent, const char* name)
           : TDEAction(parent, name)
{
    setText("digikam.org");
    setIcon("digikam");
}

int DLogoAction::plug(TQWidget *widget, int index)
{
    if (tdeApp && !tdeApp->authorizeTDEAction(name()))
        return -1;

    if ( widget->inherits( "TDEToolBar" ) )
    {
        TDEToolBar *bar         = (TDEToolBar *)widget;
        int id                = getToolButtonID();
        KURLLabel *pixmapLogo = new KURLLabel(Digikam::webProjectUrl(), TQString(), bar);
        pixmapLogo->setMargin(0);
        pixmapLogo->setScaledContents(false);
        pixmapLogo->setSizePolicy(TQSizePolicy(TQSizePolicy::Minimum, TQSizePolicy::Minimum));
        TQToolTip::add(pixmapLogo, i18n("Visit digiKam project website"));
        TDEGlobal::dirs()->addResourceType("banner-digikam", TDEGlobal::dirs()->kde_default("data") + "digikam/data");
        TQString directory = TDEGlobal::dirs()->findResourceDir("banner-digikam", "banner-digikam.png");
        pixmapLogo->setPixmap(TQPixmap( directory + "banner-digikam.png" ));
        pixmapLogo->setFocusPolicy(TQWidget::NoFocus);

        bar->insertWidget(id, pixmapLogo->width(), pixmapLogo);
        bar->alignItemRight(id);

        addContainer(bar, id);

        connect(bar, TQ_SIGNAL(destroyed()),
                this, TQ_SLOT(slotDestroyed()));

        connect(pixmapLogo, TQ_SIGNAL(leftClickedURL(const TQString&)),
                this, TQ_SLOT(slotProcessURL(const TQString&)));

        return containerCount() - 1;
    }

    int containerId = TDEAction::plug( widget, index );

    return containerId;
}

void DLogoAction::slotProcessURL(const TQString& url)
{
    tdeApp->invokeBrowser(url);
}

} // namespace Digikam
