/*
  Copyright (c) 2006  Nikolaj Hald Nielsen <nhnFreespirit@gmail.com>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this library; see the file COPYING.LIB.  If not, write to
  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
  Boston, MA 02110-1301, USA.
*/

#include "debug.h"
#include "magnatunelistviewitems.h"

#include <tdeglobal.h>
#include <kiconloader.h> 
#include <tdelocale.h>

#include <tqdatetime.h>


MagnatuneListViewArtistItem::MagnatuneListViewArtistItem( MagnatuneArtist artist, TDEListView * parent )
: TDEListViewItem( parent ), MagnatuneArtist( artist )
{
    TDEListViewItem::setText( 0, artist.getName() );

    setPixmap(0, TDEGlobal::iconLoader()->loadIcon( "preferences-desktop-personal", TDEIcon::Toolbar, TDEIcon::SizeSmall ) );

    setDragEnabled ( true );
}

MagnatuneListViewArtistItem::~ MagnatuneListViewArtistItem( )
{
}

void MagnatuneListViewArtistItem::setOpen( bool o )
{
    if ( o && !childCount() ) {
        listView()->setUpdatesEnabled( false );

        MagnatuneAlbumList albums;
        albums = MagnatuneDatabaseHandler::instance()->getAlbumsByArtistId( getId(), "" );

        MagnatuneAlbumList::iterator it;
        for ( it = albums.begin(); it != albums.end(); ++it ) {
           new MagnatuneListViewAlbumItem( (*it), this );
        }
    }
    listView()->setUpdatesEnabled( true );
    TDEListViewItem::setOpen( o );
    invalidateHeight();
    listView()->repaintContents();
}


void MagnatuneListViewArtistItem::setup()
{
    setExpandable( true );
    TDEListViewItem::setup();
}

MagnatuneListViewAlbumItem::MagnatuneListViewAlbumItem( MagnatuneAlbum album, TDEListViewItem * parent )
: TDEListViewItem( parent ), MagnatuneAlbum( album )
{
    TDEListViewItem::setText( 0, album.getName() );
    setDragEnabled( true );

    //setPixmap(0, TDEGlobal::iconLoader()->loadIcon( "media-optical-cdrom-unmounted", TDEIcon::Toolbar, TDEIcon::SizeSmall ) );
}

MagnatuneListViewAlbumItem::~ MagnatuneListViewAlbumItem( )
{
}

void MagnatuneListViewAlbumItem::setOpen( bool o )
{

    if ( o && !childCount() ) {
        listView()->setUpdatesEnabled( false );

        MagnatuneTrackList tracks;
        tracks = MagnatuneDatabaseHandler::instance()->getTracksByAlbumId( getId() );

        MagnatuneTrackList::iterator it;
        for ( it = tracks.begin(); it != tracks.end(); ++it ) {
            new MagnatuneListViewTrackItem( (*it), this );
        }
    }

    listView()->setUpdatesEnabled( true );
    TDEListViewItem::setOpen( o );
    invalidateHeight();
    listView()->repaintContents();
}

void MagnatuneListViewAlbumItem::setup( )
{
    setExpandable( true );
    TDEListViewItem::setup();
}

MagnatuneListViewTrackItem::MagnatuneListViewTrackItem( MagnatuneTrack track, TDEListViewItem * parent )
: TDEListViewItem( parent ), MagnatuneTrack( track )
{
    int trackNumber = track.getTrackNumber();
    TQString trackNumberString = TQString::number( trackNumber );
    if (trackNumber < 10)
        trackNumberString = '0' + trackNumberString;
    
    TDEListViewItem::setText( 0, trackNumberString + " - " +  track.getName() );
    
    debug() << "track duration: " << TQString::number( track.getDuration() ) <<  endl;
    
    TQTime duration;
    duration = duration.addSecs(track.getDuration());
    
    if (duration.hour() == 0)
        TDEListViewItem::setText( 1, duration.toString( "m:ss" ) );
    else
        TDEListViewItem::setText( 1, duration.toString( "h:mm:ss" ) );
    
    setDragEnabled( true );

     //setPixmap(0, TDEGlobal::iconLoader()->loadIcon( "track", TDEIcon::Toolbar, TDEIcon::SizeSmall ) );
}

MagnatuneListViewTrackItem::~ MagnatuneListViewTrackItem( )
{
}
