/***************************************************************************
                          tagxml.h  -  description
                             -------------------
    begin                : � � 25 14:34:07 EEST 2000
    copyright            : (C) 2000 by Dmitry Poplavsky & Alexander Yakovlev & Eric Laffoon <pdima@users.sourceforge.net,yshurik@penguinpowered.com,sequitur@easystreet.com>
                           (C) 2003, 2004 by Andras Mantia <amantia@kde.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TAGXML_H
#define TAGXML_H

#include <tqwidget.h>
#include <tqdom.h>
#include <tqptrlist.h>

#include "tagattr.h"
#include "tagwidget.h"
#include "qtag.h"

class Tagxml : public TQWidget, TagWidget {
  TQ_OBJECT
  
  public:
    /** construtor */
    Tagxml(TQDomNode &d, TQTag *dtdTag, TQWidget* parent=0, const char *name=0);
    Tagxml(TQDomNode &d, TQTag *dtdTag, const TQString& selection, TQWidget* parent=0, const char *name=0);
    /** destructor */
    ~Tagxml();

    TQPtrList<Attr> attributes;

    void readAttributes( TQDict<TQString> *d);
    void writeAttributes( TQDict<TQString> *d );
    void focusToFirstItem();

  private:
    void initialize(TQDomNode &d, TQTag *dtdTag);
      
    TQDomNode doc;
    const DTDStruct *m_dtd;
    TQWidget *m_firstItem;
    TQTag *m_dtdTag;
    TQString m_selection;
};



#endif
