/*
  TDevelop Autotools Support
  Copyright (c) 2005 by Matt Rogers <mattr@kde.org>

***************************************************************************
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************
*/
#ifndef AUTOTOOLSACTION_H
#define AUTOTOOLSACTION_H

#include <kxmlguiclient.h>
#include <tdeaction.h>

class TQObject;
class TDEActionCollection;

/**
 * A TDEAction derivative that will work with the TQToolButtons used in
 * the Automake Manager
 * @author Matt Rogers
 */
class AutoToolsAction : public TDEAction
{
public:
	virtual ~AutoToolsAction();

	AutoToolsAction( const TQString& text, const TDEShortcut& cut,
	                 const TQObject* receiver, const char* slot,
	                 TDEActionCollection* parent, const char* name );

	AutoToolsAction( const TQString& text, const TQIconSet& pix, const TDEShortcut& cut,
	                 const TQObject* receiver, const char* slot,
	                 TDEActionCollection* parent, const char* name );

	AutoToolsAction( const TQString& text, const TQString& pix, const TDEShortcut& cut,
	                 const TQObject* receiver, const char* slot,
	                 TDEActionCollection* parent, const char* name );

	AutoToolsAction( const KGuiItem& item, const TDEShortcut& cut,
	                 const TQObject* receiver, const char* slot,
	                 TDEActionCollection* parent, const char* name );

	AutoToolsAction( const TQString& text, const TDEShortcut& cut = TDEShortcut(), TQObject* parent = 0, const char* name = 0 );
	AutoToolsAction( const TQString& text, const TDEShortcut& cut,
	                 const TQObject* receiver, const char* slot, TQObject* parent, const char* name = 0 );
	AutoToolsAction( const TQString& text, const TQIconSet& pix, const TDEShortcut& cut = TDEShortcut(),
	                 TQObject* parent = 0, const char* name = 0 );
	AutoToolsAction( const TQString& text, const TQString& pix, const TDEShortcut& cut = TDEShortcut(),
	                 TQObject* parent = 0, const char* name = 0 );
	AutoToolsAction( const TQString& text, const TQIconSet& pix, const TDEShortcut& cut,
	                 const TQObject* receiver, const char* slot, TQObject* parent, const char* name = 0 );
	AutoToolsAction( const TQString& text, const TQString& pix, const TDEShortcut& cut,
	                 const TQObject* receiver, const char* slot, TQObject* parent,
	                 const char* name = 0 );
	AutoToolsAction( TQObject* parent = 0, const char* name = 0 );

	virtual int plug( TQWidget *widget, int index = -1 );

	virtual void updateEnabled( int i );
};

#endif
