/*
 * libjingle
 * Copyright 2004--2005, Google Inc.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice, 
 *     this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright notice,
 *     this list of conditions and the following disclaimer in the documentation
 *     and/or other materials provided with the distribution.
 *  3. The name of the author may not be used to endorse or promote products 
 *     derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _CRICKET_XMPP_XMPPLIB_BUZZ_CONSTANTS_H_
#define _CRICKET_XMPP_XMPPLIB_BUZZ_CONSTANTS_H_

#include <string>
#include "talk/xmllite/qname.h"
#include "talk/xmpp/jid.h"


#define NS_CLIENT Constants::ns_client()
#define NS_SERVER Constants::ns_server()
#define NS_STREAM Constants::ns_stream()
#define NS_XSTREAM Constants::ns_xstream()
#define NS_TLS Constants::ns_tls()
#define NS_SASL Constants::ns_sasl()
#define NS_BIND Constants::ns_bind()
#define NS_DIALBACK Constants::ns_dialback()
#define NS_SESSION Constants::ns_session()
#define NS_STANZA Constants::ns_stanza()
#define NS_PRIVACY Constants::ns_privacy()
#define NS_ROSTER Constants::ns_roster()
#define NS_VCARD Constants::ns_vcard()
#define STR_CLIENT Constants::str_client()
#define STR_SERVER Constants::str_server()
#define STR_STREAM Constants::str_stream()

namespace buzz {

extern const Jid JID_EMPTY;

class Constants {
 public:
  static const std::string & ns_client();
  static const std::string & ns_server();
  static const std::string & ns_stream();
  static const std::string & ns_xstream();
  static const std::string & ns_tls();
  static const std::string & ns_sasl();
  static const std::string & ns_bind();
  static const std::string & ns_dialback();
  static const std::string & ns_session();
  static const std::string & ns_stanza();
  static const std::string & ns_privacy();
  static const std::string & ns_roster();
  static const std::string & ns_vcard();
  
  static const std::string & str_client();
  static const std::string & str_server();
  static const std::string & str_stream();
};

extern const std::string STR_GET;
extern const std::string STR_SET;
extern const std::string STR_RESULT;
extern const std::string STR_ERROR;

extern const std::string STR_FROM;
extern const std::string STR_TO;
extern const std::string STR_BOTH;
extern const std::string STR_REMOVE;

extern const std::string STR_MESSAGE;
extern const std::string STR_BODY;
extern const std::string STR_PRESENCE;
extern const std::string STR_STATUS;
extern const std::string STR_SHOW;
extern const std::string STR_PRIOIRTY;
extern const std::string STR_IQ;

extern const std::string STR_TYPE;
extern const std::string STR_NAME;
extern const std::string STR_ID;
extern const std::string STR_JID;
extern const std::string STR_SUBSCRIPTION;
extern const std::string STR_ASK;
extern const std::string STR_X;
extern const std::string STR_GOOGLE_COM;
extern const std::string STR_GMAIL_COM;
extern const std::string STR_GOOGLEMAIL_COM;
extern const std::string STR_DEFAULT_DOMAIN;

extern const std::string STR_UNAVAILABLE;
extern const std::string STR_INVISIBLE;

extern const TQName TQN_STREAM_STREAM;
extern const TQName TQN_STREAM_FEATURES;
extern const TQName TQN_STREAM_ERROR;

extern const TQName TQN_XSTREAM_BAD_FORMAT;
extern const TQName TQN_XSTREAM_BAD_NAMESPACE_PREFIX;
extern const TQName TQN_XSTREAM_CONFLICT;
extern const TQName TQN_XSTREAM_CONNECTION_TIMEOUT;
extern const TQName TQN_XSTREAM_HOST_GONE;
extern const TQName TQN_XSTREAM_HOST_UNKNOWN;
extern const TQName TQN_XSTREAM_IMPROPER_ADDRESSIING;
extern const TQName TQN_XSTREAM_INTERNAL_SERVER_ERROR;
extern const TQName TQN_XSTREAM_INVALID_FROM;
extern const TQName TQN_XSTREAM_INVALID_ID;
extern const TQName TQN_XSTREAM_INVALID_NAMESPACE;
extern const TQName TQN_XSTREAM_INVALID_XML;
extern const TQName TQN_XSTREAM_NOT_AUTHORIZED;
extern const TQName TQN_XSTREAM_POLICY_VIOLATION;
extern const TQName TQN_XSTREAM_REMOTE_CONNECTION_FAILED;
extern const TQName TQN_XSTREAM_RESOURCE_CONSTRAINT;
extern const TQName TQN_XSTREAM_RESTRICTED_XML;
extern const TQName TQN_XSTREAM_SEE_OTHER_HOST;
extern const TQName TQN_XSTREAM_SYSTEM_SHUTDOWN;
extern const TQName TQN_XSTREAM_UNDEFINED_CONDITION;
extern const TQName TQN_XSTREAM_UNSUPPORTED_ENCODING;
extern const TQName TQN_XSTREAM_UNSUPPORTED_STANZA_TYPE;
extern const TQName TQN_XSTREAM_UNSUPPORTED_VERSION;
extern const TQName TQN_XSTREAM_XML_NOT_WELL_FORMED;
extern const TQName TQN_XSTREAM_TEXT;

extern const TQName TQN_TLS_STARTTLS;
extern const TQName TQN_TLS_REQUIRED;
extern const TQName TQN_TLS_PROCEED;
extern const TQName TQN_TLS_FAILURE;

extern const TQName TQN_SASL_MECHANISMS;
extern const TQName TQN_SASL_MECHANISM;
extern const TQName TQN_SASL_AUTH;
extern const TQName TQN_SASL_CHALLENGE;
extern const TQName TQN_SASL_RESPONSE;
extern const TQName TQN_SASL_ABORT;
extern const TQName TQN_SASL_SUCCESS;
extern const TQName TQN_SASL_FAILURE;
extern const TQName TQN_SASL_ABORTED;
extern const TQName TQN_SASL_INCORRECT_ENCODING;
extern const TQName TQN_SASL_INVALID_AUTHZID;
extern const TQName TQN_SASL_INVALID_MECHANISM;
extern const TQName TQN_SASL_MECHANISM_TOO_WEAK;
extern const TQName TQN_SASL_NOT_AUTHORIZED;
extern const TQName TQN_SASL_TEMPORARY_AUTH_FAILURE;

extern const TQName TQN_DIALBACK_RESULT;
extern const TQName TQN_DIALBACK_VERIFY;

extern const TQName TQN_STANZA_BAD_REQUEST;
extern const TQName TQN_STANZA_CONFLICT;
extern const TQName TQN_STANZA_FEATURE_NOT_IMPLEMENTED;
extern const TQName TQN_STANZA_FORBIDDEN;
extern const TQName TQN_STANZA_GONE;
extern const TQName TQN_STANZA_INTERNAL_SERVER_ERROR;
extern const TQName TQN_STANZA_ITEM_NOT_FOUND;
extern const TQName TQN_STANZA_JID_MALFORMED;
extern const TQName TQN_STANZA_NOT_ACCEPTABLE;
extern const TQName TQN_STANZA_NOT_ALLOWED;
extern const TQName TQN_STANZA_PAYMENT_REQUIRED;
extern const TQName TQN_STANZA_RECIPIENT_UNAVAILABLE;
extern const TQName TQN_STANZA_REDIRECT;
extern const TQName TQN_STANZA_REGISTRATION_REQUIRED;
extern const TQName TQN_STANZA_REMOTE_SERVER_NOT_FOUND;
extern const TQName TQN_STANZA_REMOTE_SERVER_TIMEOUT;
extern const TQName TQN_STANZA_RESOURCE_CONSTRAINT;
extern const TQName TQN_STANZA_SERVICE_UNAVAILABLE;
extern const TQName TQN_STANZA_SUBSCRIPTION_REQUIRED;
extern const TQName TQN_STANZA_UNDEFINED_CONDITION;
extern const TQName TQN_STANZA_UNEXPECTED_REQUEST;
extern const TQName TQN_STANZA_TEXT;

extern const TQName TQN_BIND_BIND;
extern const TQName TQN_BIND_RESOURCE;
extern const TQName TQN_BIND_JID;

extern const TQName TQN_MESSAGE;
extern const TQName TQN_BODY;
extern const TQName TQN_SUBJECT;
extern const TQName TQN_THREAD;
extern const TQName TQN_PRESENCE;
extern const TQName TQN_SHOW;
extern const TQName TQN_STATUS;
extern const TQName TQN_LANG;
extern const TQName TQN_PRIORITY;
extern const TQName TQN_IQ;
extern const TQName TQN_ERROR;

extern const TQName TQN_SERVER_MESSAGE;
extern const TQName TQN_SERVER_BODY;
extern const TQName TQN_SERVER_SUBJECT;
extern const TQName TQN_SERVER_THREAD;
extern const TQName TQN_SERVER_PRESENCE;
extern const TQName TQN_SERVER_SHOW;
extern const TQName TQN_SERVER_STATUS;
extern const TQName TQN_SERVER_LANG;
extern const TQName TQN_SERVER_PRIORITY;
extern const TQName TQN_SERVER_IQ;
extern const TQName TQN_SERVER_ERROR;

extern const TQName TQN_SESSION_SESSION;

extern const TQName TQN_PRIVACY_QUERY;
extern const TQName TQN_PRIVACY_ACTIVE;
extern const TQName TQN_PRIVACY_DEFAULT;
extern const TQName TQN_PRIVACY_LIST;
extern const TQName TQN_PRIVACY_ITEM;
extern const TQName TQN_PRIVACY_IQ;
extern const TQName TQN_PRIVACY_MESSAGE;
extern const TQName TQN_PRIVACY_PRESENCE_IN;
extern const TQName TQN_PRIVACY_PRESENCE_OUT;

extern const TQName TQN_ROSTER_QUERY;
extern const TQName TQN_ROSTER_ITEM;
extern const TQName TQN_ROSTER_GROUP;

extern const TQName TQN_VCARD_QUERY;
extern const TQName TQN_VCARD_FN;

extern const TQName TQN_XML_LANG;

extern const TQName TQN_ENCODING;
extern const TQName TQN_VERSION;
extern const TQName TQN_TO;
extern const TQName TQN_FROM;
extern const TQName TQN_TYPE;
extern const TQName TQN_ID;
extern const TQName TQN_CODE;
extern const TQName TQN_NAME;
extern const TQName TQN_VALUE;
extern const TQName TQN_ACTION;
extern const TQName TQN_ORDER;
extern const TQName TQN_MECHANISM;
extern const TQName TQN_ASK;
extern const TQName TQN_JID;
extern const TQName TQN_SUBSCRIPTION;


extern const TQName TQN_XMLNS_CLIENT;
extern const TQName TQN_XMLNS_SERVER;
extern const TQName TQN_XMLNS_STREAM;

// Presence
extern const std::string STR_SHOW_AWAY;
extern const std::string STR_SHOW_CHAT;
extern const std::string STR_SHOW_DND;
extern const std::string STR_SHOW_XA;

// Subscription
extern const std::string STR_SUBSCRIBE;
extern const std::string STR_SUBSCRIBED;
extern const std::string STR_UNSUBSCRIBE;
extern const std::string STR_UNSUBSCRIBED;


// JEP 0030
extern const TQName TQN_NODE;
extern const TQName TQN_CATEGORY;
extern const TQName TQN_VAR;
extern const std::string NS_DISCO_INFO;
extern const std::string NS_DISCO_ITEMS;

extern const TQName TQN_DISCO_INFO_QUERY;
extern const TQName TQN_DISCO_IDENTITY;
extern const TQName TQN_DISCO_FEATURE;

extern const TQName TQN_DISCO_ITEMS_QUERY;
extern const TQName TQN_DISCO_ITEM;


// JEP 0115
extern const std::string NS_CAPS;
extern const TQName TQN_CAPS_C;
extern const TQName TQN_VER;
extern const TQName TQN_EXT;


// JEP 0091 Delayed Delivery
extern const std::string kNSDelay;
extern const TQName kQnDelayX;
extern const TQName kQnStamp;

}

#endif // _CRICKET_XMPP_XMPPLIB_BUZZ_CONSTANTS_H_
