/*
    oscarversionupdater.h  -  Version Updater

    Copyright (c) 2006 by Roman Jarosz <kedgedev@centrum.cz>
    Kopete    (c) 2006 by the Kopete developers  <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef OSCARVERSIONUPDATER_H
#define OSCARVERSIONUPDATER_H

#include <tqobject.h>

#include <oscartypes.h>

namespace TDEIO
{
class Job;
class TransferJob;
}

class TQDomElement;
class TQDomDocument;

/**
	@author Roman Jarosz <kedgedev@centrum.cz>
*/

class OscarVersionUpdater : public TQObject
{
	TQ_OBJECT
  
	
public:
	OscarVersionUpdater();
	~OscarVersionUpdater();
	
	static OscarVersionUpdater* self();
	
	/**
	 * Update version info from server.
	 * @param stamp is update number.
	 */
	bool update( unsigned int stamp );
	
	/**
	 * Update version info from server.
	 * @return true if update is in progress or starts.
	 */
	unsigned int stamp() const;
	
	/**
	 * Return structure with version info for ICQ.
	 * @return Oscar::ClientVersion.
	 */
	const Oscar::ClientVersion* getICQVersion() const { return &mICQVersion; }
	
	/**
	 * Return structure with version info for AIM.
	 * @return Oscar::ClientVersion.
	 */
	const Oscar::ClientVersion* getAIMVersion() const { return &mAIMVersion; }

	/**
	 * Set structure with ICQ version info to default.
	 */
	void initICQVersionInfo();
	
	/**
	 * Set structure with AIM version info to default.
	 */
	void initAIMVersionInfo();

	/**
	 * Print debug info.
	 */
	void printDebug();

private slots:
	void slotTransferData( TDEIO::Job *job, const TQByteArray &data );
	void slotTransferResult( TDEIO::Job *job );
	
private:
	void parseDocument( TQDomDocument& doc );
	bool parseVersion( Oscar::ClientVersion& version, TQDomElement& element );
	
	/**
	 * Store version info structure to TDEConfigGroup
	 * @param group is the group name.
	 * @param version is version info structure.
	 */
	void storeVersionInfo( const TQString& group, const Oscar::ClientVersion& version ) const;
	
	/**
	 * Compare two versions.
	 * @return true if a and b is equal.
	 */
	bool equal( const Oscar::ClientVersion& a, const Oscar::ClientVersion& b ) const;
	
private:
	static OscarVersionUpdater *versionUpdaterStatic;
	
	Oscar::ClientVersion mICQVersion;
	Oscar::ClientVersion mAIMVersion;
	
	TDEIO::TransferJob *mTransferJob;
	TQByteArray mVersionData;
	
	unsigned int mStamp;
	bool mUpdating;
};

#endif
