/* This file is part of the TDE project
 * Copyright (C) 2025 mio <stigma@disroot.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation version 2.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */
#ifndef __TDEFILE_MP4_H__
#define __TDEFILE_MP4_H__

#include <tdefilemetainfo.h>

class TQStringList;

class TDEMp4Plugin : public KFilePlugin
{
	TQ_OBJECT

public:
	TDEMp4Plugin(TQObject *parent, const char *name, const TQStringList& meta);

	TQValidator* createValidator(const TQString& mimeType, const TQString& group,
		const TQString& key, TQObject *parent, const char* name) const override;

	bool readInfo(KFileMetaInfo& info, unsigned what) override;
	bool writeInfo(const KFileMetaInfo& info) const override;
};

#endif /* __TDEFILE_MP4_H__ */
