/*

    Copyright (C) 2000-2001 Stefan Westerfeld
	                        <stefan@space.twc.de>
                  2003 Arnold Krille <arnold@arnoldarts.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

    */

#ifndef MAIN_H
#define MAIN_H
#include <qiomanager.h>
#include <dispatcher.h>
#include <tqmessagebox.h>
#include <tdeapplication.h>
#include <tqframe.h>
#include <tdemainwindow.h>
#include <tdecmdlineargs.h>
#include <tdeaboutdata.h>
#include <tdelocale.h>
#include <kstdaction.h>
#include <tqlayout.h>
#include <tqpushbutton.h>
#include <artsflow.h>
#include <soundserver.h>
#include <tqobject.h>
#include <kartswidget.h>
#include <flowsystem.h>
#include <artsmodules.h>
#include <kartsserver.h>

class LevelMeter;
class PeakBar;
class PeakLevelMeter;
class VScale;

class FreeVerbView : public TQWidget {
	TQ_OBJECT
	
protected:
	Arts::Synth_FREEVERB freeverb;
	Arts::SimpleSoundServer server;
	long effectID;

	void closeEvent(TQCloseEvent *e);
public:
	FreeVerbView(Arts::SimpleSoundServer server);
	~FreeVerbView();
signals:
	void closed();
};

class KArtsWidget;

class VControl : public TQFrame {
	TQ_OBJECT
  
protected:
	class StereoLevelMeter *stereoMeter;
	FreeVerbView *freeVerbView;
	Arts::StereoVolumeControl svc;
	Arts::StereoVolumeControlGui svcgui;
	KArtsWidget *svcguiw;
	KArtsServer *server;
	
	TQBoxLayout *boxLayout;

public:
	VControl( KArtsServer*, TQWidget *parent);
	~VControl();

public slots:
	void useOldVolumeBar(int old);
	void showFreeVerbView();
private slots:
	void initaRtsConnections();
};

#include "artsactions.h"

class MainWindow : public TDEMainWindow {
	TQ_OBJECT
  
protected:
	VControl *vc;
	TDEToggleAction *showOldVolumeDisplay;
	ArtsActions* artsactions;
	KArtsServer *kartsserver;

public slots:
	void toggleVolumeBar();

	void serverRestarted();
public:
	MainWindow();
};

//Arts::Environment::Container defaultEnvironment();

#endif /* MAIN_H */
