/*
 *
 *  Adapter Implementation of bluez5 for libtdebluez
 *
 *  Copyright (C) 2018  Emanoil Kotsev <deloptes@gmail.com>
 *
 *
 *  This file is part of libtdebluez.
 *
 *  libtdebluez is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  libtdebluez is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with kbluetooth; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#if !defined(ADAPTERIMPL_H_INCLUDED)
#define ADAPTERIMPL_H_INCLUDED

#include "tdemacros.h"

#include "interfaces/adapter1Proxy.h"

using namespace org::bluez;

namespace TDEBluetooth
{

class TDE_EXPORT AdapterImpl: public Adapter1Proxy
{
    TQ_OBJECT

public:
    AdapterImpl(const TQString& service, const TQString& path, TQObject* parent = 0, const char* name = 0);

    virtual ~AdapterImpl();
    void powerOn(bool state);
    TQString getPath();

public slots:
    void slotSetAlias(const TQString& alias);
    void slotSetTimeout(int timeout);

};
// class AdapterImpl

};
// namespace TDEBluetooth

#endif //ADAPTERIMPL_H_INCLUDED

// End of File
