/***************************************************************************
* $Id$
**
* Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
* This file is part of an example program for Qt.  This example
* program may be used, distributed and modified without limitation.
**
****************************************************************************/

import org.trinitydesktop.qt.*;
import java.util.ArrayList;

class ApplicationWindow extends TQMainWindow
{

private    TQPrinter printer;
private    TQWorkspace ws;
/* Keep a copy of ws.windowList(), so that the MDIWindow
   widgets in it won't get garbage collected */
private    ArrayList windows;
private    TQToolBar fileTools;
private    TQPopupMenu windowsMenu;



private String  fileOpenText = "Click this button to open a <em>new file</em>. <br><br>"
+ "You can also select the <b>Open command</b> from the File menu.";
private String  fileSaveText = "Click this button to save the file you are "
+ "editing.  You will be prompted for a file name.\n\n"
+ "You can also select the Save command from the File menu.\n\n"
+ "Note that implementing this function is left as an exercise for the reader.";
private String  filePrintText = "Click this button to print the file you "
+ "are editing.\n\n"
+ "You can also select the Print command from the File menu.";

/* XPM */
static String filesave[] = {
"    14    14        4            1",
". c #040404",
"# c #808304",
"a c #bfc2bf",
"b c None",
"..............",
".#.aaaaaaaa.a.",
".#.aaaaaaaa...",
".#.aaaaaaaa.#.",
".#.aaaaaaaa.#.",
".#.aaaaaaaa.#.",
".#.aaaaaaaa.#.",
".##........##.",
".############.",
".##.........#.",
".##......aa.#.",
".##......aa.#.",
".##......aa.#.",
"b............."
};

/* XPM */
static String fileopen[] = {
"    16    13        5            1",
". c #040404",
"# c #808304",
"a c None",
"b c #f3f704",
"c c #f3f7f3",
"aaaaaaaaa...aaaa",
"aaaaaaaa.aaa.a.a",
"aaaaaaaaaaaaa..a",
"a...aaaaaaaa...a",
".bcb.......aaaaa",
".cbcbcbcbc.aaaaa",
".bcbcbcbcb.aaaaa",
".cbcb...........",
".bcb.#########.a",
".cb.#########.aa",
".b.#########.aaa",
"..#########.aaaa",
"...........aaaaa"
};

/* XPM */
static String fileprint[] = {
"    16    14        6            1",
". c #000000",
"# c #848284",
"a c #c6c3c6",
"b c #ffff00",
"c c #ffffff",
"d c None",
"ddddd.........dd",
"dddd.cccccccc.dd",
"dddd.c.....c.ddd",
"ddd.cccccccc.ddd",
"ddd.c.....c....d",
"dd.cccccccc.a.a.",
"d..........a.a..",
".aaaaaaaaaa.a.a.",
".............aa.",
".aaaaaa###aa.a.d",
".aaaaaabbbaa...d",
".............a.d",
"d.aaaaaaaaa.a.dd",
"dd...........ddd"
};

ApplicationWindow()
{
    super( null, "example application main window", WDestructiveClose );
    int id;

    TQPixmap openIcon, saveIcon;

    fileTools = new TQToolBar( this, "file operations" );
    addToolBar( fileTools, tr( "File Operations" ), DockTop, true );

    openIcon = new TQPixmap( fileopen );
    TQToolButton  fileOpen
	= new TQToolButton( new TQIconSet(openIcon), "Open File", "",
			   this, TQ_SLOT("load()"), fileTools, "open file" );

    saveIcon = new TQPixmap( filesave );
    TQToolButton  fileSave
	= new TQToolButton( new TQIconSet(saveIcon), "Save File", "",
			   this, TQ_SLOT("save()"), fileTools, "save file" );

    printer = new TQPrinter();
    TQPixmap printIcon;

    printIcon = new TQPixmap( fileprint );
    TQToolButton  filePrint
	= new TQToolButton( new TQIconSet(printIcon), "Print File", "",
			   this, TQ_SLOT("print()"), fileTools, "print file" );
    TQWhatsThis.add( filePrint, filePrintText );

    TQWhatsThis.whatsThisButton( fileTools );

    TQWhatsThis.add( fileOpen, fileOpenText );
    TQWhatsThis.add( fileSave, fileSaveText );

    TQPopupMenu  file = new TQPopupMenu( this );
    menuBar().insertItem( "&File", file );

    file.insertItem( "&New", this, TQ_SLOT("newDoc()"), new TQKeySequence(CTRL+Key_N) );

    id = file.insertItem( new TQIconSet(openIcon), "&Open...",
			   this, TQ_SLOT("load()"), new TQKeySequence(CTRL+Key_O) );
    file.setWhatsThis( id, fileOpenText );

    id = file.insertItem( new TQIconSet(saveIcon), "&Save",
			   this, TQ_SLOT("save()"), new TQKeySequence(CTRL+Key_S) );
    file.setWhatsThis( id, fileSaveText );
    id = file.insertItem( "Save &As...", this, TQ_SLOT("saveAs()") );
    file.setWhatsThis( id, fileSaveText );
    file.insertSeparator();
    id = file.insertItem( new TQIconSet(printIcon), "&Print...",
			   this, TQ_SLOT("print()"), new TQKeySequence(CTRL+Key_P) );
    file.setWhatsThis( id, filePrintText );
    file.insertSeparator();
    file.insertItem( "&Close", this, TQ_SLOT("closeWindow()"), new TQKeySequence(CTRL+Key_W) );
    file.insertItem( "&Quit", tqApp(), TQ_SLOT(" closeAllWindows()"), new TQKeySequence(CTRL+Key_Q) );

    windowsMenu = new TQPopupMenu( this );
    windowsMenu.setCheckable( true );
    connect( windowsMenu, TQ_SIGNAL(" aboutToShow()"),
	     this, TQ_SLOT(" windowsMenuAboutToShow()") );
    menuBar().insertItem( "&Windows", windowsMenu );

    menuBar().insertSeparator();
    TQPopupMenu  help = new TQPopupMenu( this );
    menuBar().insertItem( "&Help", help );

    help.insertItem( "&About", this, TQ_SLOT("about()"), new TQKeySequence(Key_F1));
    help.insertItem( "About &Qt", this, TQ_SLOT("aboutTQt()"));
    help.insertSeparator();
    help.insertItem( "What's &This", this, TQ_SLOT("whatsThis()"), new TQKeySequence(SHIFT+Key_F1));

    TQVBox vb = new TQVBox( this );
    vb.setFrameStyle( TQFrame.StyledPanel | TQFrame.Sunken );
    ws = new TQWorkspace( vb );
    ws.setScrollBarsEnabled( true );
    setCentralWidget( vb );

    statusBar().message( "Ready", 2000 );
}


MDIWindow newDoc()
{
    MDIWindow w = new MDIWindow( ws, null, WDestructiveClose );
    connect( w, TQ_SIGNAL("message(String,int)"), statusBar(), TQ_SLOT("message(String,int)") );
    w.setCaption("unnamed document");
    w.setIcon( new TQPixmap("document.xpm") );
    // show the very first window in maximized mode
	windows = ws.windowList();
    if ( windows.size() == 0 )
	w.showMaximized();
    else
	w.show();
    return w;
}

void load()
{
    String fn = TQFileDialog.getOpenFileName( "", "", this );
    if ( !fn.equals("") ) {
	MDIWindow w = newDoc();
	w.load( fn );
    }  else {
	statusBar().message( "Loading aborted", 2000 );
    }
}

void save()
{
    MDIWindow m = (MDIWindow)ws.activeWindow();
    if ( m != null )
	m.save();
}


void saveAs()
{
    MDIWindow m = (MDIWindow)ws.activeWindow();
    if ( m != null )
	m.saveAs();
}


void print()
{
    MDIWindow m = (MDIWindow)ws.activeWindow();
    if ( m != null)
	m.print( printer );
}


void closeWindow()
{
    MDIWindow m = (MDIWindow)ws.activeWindow();
    if ( m != null )
	m.close();
}

void about()
{
    TQMessageBox.about( this, "Qt Application Example",
			"This example demonstrates simple use of\n "
			+ "Qt's Multiple Document Interface (MDI).");
}


void aboutTQt()
{
    TQMessageBox.aboutTQt( this, "Qt Application Example" );
}


void windowsMenuAboutToShow()
{
    windowsMenu.clear();
    int cascadeId = windowsMenu.insertItem("&Cascade", ws, TQ_SLOT("cascade()") );
    int tileId = windowsMenu.insertItem("&Tile", ws, TQ_SLOT("tile()") );
    windows = ws.windowList();
    if ( windows.size() == 0 ) {
	windowsMenu.setItemEnabled( cascadeId, false );
	windowsMenu.setItemEnabled( tileId, false );
    }
    windowsMenu.insertSeparator();
    for ( int i = 0; i < windows.size(); ++i ) {
	int id = windowsMenu.insertItem(((TQWidget) windows.get(i)).caption(),
					 this, TQ_SLOT(" windowsMenuActivated( int )") );
	windowsMenu.setItemParameter( id, i );
	windowsMenu.setItemChecked( id, ws.activeWindow() == windows.get(i) );
    }
}

void windowsMenuActivated( int id )
{
    windows = ws.windowList();
    TQWidget w = (TQWidget) windows.get( id );
    if ( w != null )
	w.showNormal();
    w.setFocus();
}


}

