#!/usr/bin/env kjscmd

// Globals
var frame = new TQFrame(this);
var labels = new Array();
var startPos = new Point(0,0);
var lastPos = new Point(0,0);

frame.resize(300,300);
frame.paletteBackgroundColor = "blue";

var target = new Target(frame,"Target");
for( var idx = 0; idx < 3; ++idx)
  labels[idx] = new Block(frame, "Label " + idx);

frame.show();
application.exec();

function Target( parent, text)
{
  var x = Math.floor( Math.random() * parent.width );
  var y = Math.floor( Math.random() * parent.height );
  var w = 100;
  var h = 100;

  this.label = new TQLabel(parent);
  this.text = text;
  this.label.paletteBackgroundColor = "green";
  this.label.geometry = new Rect(x,y,w,h);

  this.checkInside = function( objectRect )
  {
    return this.label.geometry.contains(objectRect);
  }

}

function Block(parent,text)
{
    this.label = new TQLabel(parent);
    var x = Math.floor( Math.random() * parent.width );
    var y = Math.floor( Math.random() * parent.height );
    var w = 25;
    var h = 25;
    this.label.text = text;
    this.label.geometry = new Rect(x,y,w,h);
    this.label.frameShape = TQFrame.WinPanel;
    this.label.frameShadow = TQFrame.Plain;
    this.label.paletteBackgroundColor = "white";  
    this.label.setMouseTracking(true);
    this.label.adjustSize();
    
    // Event handlers
    this.label.mousePressEvent = function(ev)
    {
      //println("Press: " + this.text);
      startPos = this.pos;
      lastPos = ev.globalPos;
      println("Start: " + startPos.x() + "," + startPos.y());
      
    }
  
    this.label.mouseReleaseEvent = function(ev)
    {
      if( target.checkInside(this.geometry) )
	alert( "You got " + this.text + " on target!" );
      else
      {
	println("Reset: " + startPos.x() + "," + startPos.y());
	this.pos = startPos;
      }
    }
  
    this.label.mouseMoveEvent = function(ev)
    {
	if( ev.state == 1)
	{
	  var xDelta = ev.globalX - lastPos.x();
	  var yDelta = ev.globalY - lastPos.y();
	  this.move( this.x + xDelta, this.y + yDelta );
	  lastPos = ev.globalPos;
	}
    }
}





