#################################################
#
#  Improvements and feedback are welcome
#
#  This file is released under GPL >= 3
#
#################################################

# required stuff

tde_setup_compiler_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )

find_package( TQt )
find_package( TDE )


##### check for gcc visibility support #########

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( )


##### check headers and functions for kuser

if( BUILD_KUSER )

  #### check for headers

  check_include_file( "unistd.h"           HAVE_UNISTD_H           )
  check_include_file( "sys/stat.h"         HAVE_SYS_STAT_H         )
  check_include_file( "crypt.h"            HAVE_CRYPT_H            )
  check_include_file( "paths.h"            HAVE_PATHS_H            )


  #### check for functions

  check_function_exists( crypt HAVE_CRYPT )
  if( NOT HAVE_CRYPT )
    check_library_exists( crypt crypt "" HAVE_CRYPT_LIB )
    if( HAVE_CRYPT_LIB )
      set( HAVE_CRYPT 1 )
      set( CRYPT_LIBRARIES crypt )
    endif( HAVE_CRYPT_LIB )
  endif( NOT HAVE_CRYPT )
  if( NOT HAVE_CRYPT )
    check_library_exists( c crypt "" HAVE_CRYPT_LIBC )
    if( HAVE_CRYPT_LIBC )
      set( HAVE_CRYPT 1 )
      set( CRYPT_LIBRARIES c )
    endif( HAVE_CRYPT_LIBC )
  endif( NOT HAVE_CRYPT )
  if( NOT HAVE_CRYPT )
    tde_message_fatal( "KUser build is requested, but the crypt function was not found." )
  endif()

  check_function_exists( getspent HAVE_GETSPENT )
  if( HAVE_GETSPENT )
    set( HAVE_SHADOW 1 )
  else( )
    check_library_exists( shadow getspent "" LIBSHADOW )
    if( LIBSHADOW )
      set( HAVE_SHADOW 1 )
      set( SHADOW_LIBRARIES shadow )
    else( )
      check_library_exists( gen getspent "" LIBGEN )
      if( LIBGEN )
        set( HAVE_SHADOW 1 )
        set( SHADOW_LIBRARIES gen )
      endif( )
    endif( )
  endif( )

  tde_save_and_set( CMAKE_REQUIRED_INCLUDES "pwd.h" )
  check_function_exists( fgetpwent HAVE_FGETPWENT )
  tde_restore( CMAKE_REQUIRED_INCLUDES )

  tde_save_and_set( CMAKE_REQUIRED_INCLUDES "grp.h" )
  check_function_exists( fgetgrent HAVE_FGETGRENT )
  tde_restore( CMAKE_REQUIRED_INCLUDES )

  tde_save_and_set( CMAKE_REQUIRED_INCLUDES "shadow.h" )
  check_function_exists( fgetspent HAVE_FGETSPENT )
  tde_restore( CMAKE_REQUIRED_INCLUDES )

endif( BUILD_KUSER)
