/***************************************************************************
    smb4ksynchronizeoptions  -  The configuration page for the rsync options
                             -------------------
    begin                : So Nov 20 2005
    copyright            : (C) 2005-2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

// TQt includes
#include <tqlayout.h>
#include <tqbuttongroup.h>
#include <tqcheckbox.h>
#include <tqlabel.h>
#include <tqradiobutton.h>

// KDE includes
#include <tdelocale.h>
#include <kurlrequester.h>
#include <klineedit.h>
#include <knuminput.h>
#include <klineedit.h>
#include <tdefile.h>

// application specific includes
#include "smb4tdersyncoptions.h"

Smb4KRsyncOptions::Smb4KRsyncOptions( TQWidget *parent, const char *name ) : TQTabWidget( parent, name )
{
  setMargin( 10 );

  //
  // The Copying tab
  //
  TQWidget *copying_tab = new TQWidget( this, "RsyncCopying" );
  TQGridLayout *copying_layout = new TQGridLayout( copying_tab );
  copying_layout->setSpacing( 10 );

  TQGroupBox *directory_box = new TQGroupBox( 2, TQt::Horizontal, i18n( "Default Destination" ),
                             copying_tab, "RsyncDestinationBox" );
  directory_box->setInsideSpacing( 5 );

  (void) new TQLabel( i18n( "Rsync prefix:" ), directory_box, "RsyncPrefixLabel" );
  KURLRequester *prefix = new KURLRequester( directory_box, "kcfg_RsyncPrefix" );
  prefix->setMode( KFile::Directory | KFile::LocalOnly );

  TQButtonGroup *general_box = new TQButtonGroup( 2, TQt::Horizontal, i18n( "General" ),
                              copying_tab, "RsyncModeBox" );
  general_box->setInsideSpacing( 5 );

  TQCheckBox *archive_mode = new TQCheckBox( i18n( "Archive mode" ), general_box, "kcfg_ArchiveMode" );
  TQCheckBox *recursive = new TQCheckBox( i18n( "Recurse into directories" ), general_box, "kcfg_RecurseIntoDirectories" );
  (void) new TQCheckBox( i18n( "Skip files that are newer in target directory" ), general_box, "kcfg_UpdateTarget" );
  (void) new TQCheckBox( i18n( "Update destination files in place" ), general_box, "kcfg_UpdateInPlace" );
  (void) new TQCheckBox( i18n( "Use relative path names" ), general_box, "kcfg_RelativePathNames" );
  (void) new TQCheckBox( i18n( "Don't send implied directories" ), general_box, "kcfg_NoImpliedDirectories" );
  (void) new TQCheckBox( i18n( "Transfer directories without recursing" ), general_box, "kcfg_TransferDirectories" );
  (void) new TQCheckBox( i18n( "Compress data during transfer" ), general_box, "kcfg_CompressData" );

  TQButtonGroup *links_box = new TQButtonGroup( 2, TQt::Horizontal, i18n( "Links" ), copying_tab, "RsyncModeBox" );
  links_box->setInsideSpacing( 5 );

  TQCheckBox *links = new TQCheckBox( i18n( "Preserve symlinks" ), links_box, "kcfg_PreserveSymlinks" );
  (void) new TQCheckBox( i18n( "Transform symlinks" ), links_box, "kcfg_TransformSymlinks" );
  (void) new TQCheckBox( i18n( "Only transform unsafe symlinks" ), links_box, "kcfg_TransformUnsafeSymlinks" );
  (void) new TQCheckBox( i18n( "Ignore unsafe symlinks" ), links_box, "kcfg_IgnoreUnsafeSymlinks" );
  (void) new TQCheckBox( i18n( "Preserve hard links" ), links_box, "kcfg_PreserveHardLinks" );
  (void) new TQCheckBox( i18n( "Keep directory symlinks" ), links_box, "kcfg_KeepDirectorySymlinks" );

  TQButtonGroup *perm_box = new TQButtonGroup( 2, TQt::Horizontal, i18n( "File Permissions, etc." ),
                           copying_tab, "RsyncPreservationBox" );
  perm_box->setInsideSpacing( 5 );

  TQCheckBox *perms = new TQCheckBox( i18n( "Preserve permissions" ), perm_box, "kcfg_PreservePermissions" );
  TQCheckBox *group = new TQCheckBox( i18n( "Preserve group" ), perm_box, "kcfg_PreserveGroup" );
  TQCheckBox *owner = new TQCheckBox( i18n( "Preserve owner" ), perm_box, "kcfg_PreserveOwner" );
  TQCheckBox *devices = new TQCheckBox( i18n( "Preserve device and special files" ), perm_box, "kcfg_PreserveDevicesAndSpecials" );
  TQCheckBox *times = new TQCheckBox( i18n( "Preserve times" ), perm_box, "kcfg_PreserveTimes" );
  (void) new TQCheckBox( i18n( "Omit directories when preserving times" ), perm_box, "kcfg_OmitDirectoryTimes" );

  TQSpacerItem *spacer1 = new TQSpacerItem( 0, 0, TQSizePolicy::Preferred, TQSizePolicy::Expanding );

  copying_layout->addWidget( directory_box, 0, 0, 0 );
  copying_layout->addWidget( general_box, 1, 0, 0 );
  copying_layout->addWidget( links_box, 2, 0, 0 );
  copying_layout->addWidget( perm_box, 3, 0, 0 );
  copying_layout->addItem( spacer1, 4, 0 );

  addTab( copying_tab, i18n( "Copying" ) );


  //
  // The File Deletion & Transfer tab
  //
  TQWidget *deltrans_tab = new TQWidget( this, "RsyncFileDeletion" );
  TQGridLayout *deltrans_layout = new TQGridLayout( deltrans_tab );
  deltrans_layout->setSpacing( 10 );

  TQButtonGroup *delete_box = new TQButtonGroup( 2, TQt::Horizontal, i18n( "File Deletion" ), deltrans_tab, "RsyncDeleteBox" );
  delete_box->setInsideSpacing( 5 );

  (void) new TQCheckBox( i18n( "Remove synchronized source files" ), delete_box, "kcfg_RemoveSourceFiles" );
  (void) new TQCheckBox( i18n( "Delete extraneous files" ), delete_box, "kcfg_DeleteExtraneous" );
  (void) new TQCheckBox( i18n( "Delete files before transfer" ), delete_box, "kcfg_DeleteBefore" );
  (void) new TQCheckBox( i18n( "Delete files after transfer" ), delete_box, "kcfg_DeleteAfter" );
  (void) new TQCheckBox( i18n( "Delete files during transfer" ), delete_box, "kcfg_DeleteDuring" );
  (void) new TQCheckBox( i18n( "Also delete excluded files" ), delete_box, "kcfg_DeleteExcluded" );
  (void) new TQCheckBox( i18n( "Delete even if I/O errors occur" ), delete_box, "kcfg_IgnoreErrors" );
  (void) new TQCheckBox( i18n( "Force deletion of non-void directories" ), delete_box, "kcfg_ForceDirectoryDeletion" );

  TQButtonGroup *delete_restrictions_box = new TQButtonGroup( 2, TQt::Horizontal, i18n( "Restrictions" ), deltrans_tab, "RsyncDeleteRestrictionsBox" );
  delete_restrictions_box->setInsideSpacing( 5 );

  (void) new TQCheckBox( i18n( "Don't delete more than this many files:" ), delete_restrictions_box, "kcfg_UseMaximumDelete" );
  (void) new KIntNumInput( delete_restrictions_box, "kcfg_MaximumDeleteValue" );

  TQButtonGroup *transfer_box = new TQButtonGroup( 2, TQt::Horizontal, i18n( "File Transfer" ),
                               deltrans_tab, "RsyncFileTransferBox" );
  transfer_box->setInsideSpacing( 5 );

  (void) new TQCheckBox( i18n( "Don't transfer any file smaller than:" ), transfer_box, "kcfg_UseMinimalTransferSize" );
  KIntNumInput *min_size = new KIntNumInput( transfer_box, "kcfg_MinimalTransferSize" );
  min_size->setSuffix( " kB" );
  (void) new TQCheckBox( i18n( "Don't transfer any file larger than:" ), transfer_box, "kcfg_UseMaximalTransferSize" );
  KIntNumInput *max_size = new KIntNumInput( transfer_box, "kcfg_MaximalTransferSize" );
  max_size->setSuffix( " kB" );
  (void) new TQCheckBox( i18n( "Keep partially transferred files" ), transfer_box, "kcfg_KeepPartial" );
  transfer_box->addSpace( 0 );
  (void) new TQCheckBox( i18n( "Put a partially transferred file into:" ), transfer_box, "kcfg_UsePartialDirectory" );
  KURLRequester *partial_dir = new KURLRequester( transfer_box, "kcfg_PartialDirectory" );
  partial_dir->setMode( KFile::Directory | KFile::LocalOnly );

  TQSpacerItem *spacer2 = new TQSpacerItem( 0, 0, TQSizePolicy::Preferred, TQSizePolicy::Expanding );

  deltrans_layout->addWidget( delete_box, 0, 0, 0 );
  deltrans_layout->addWidget( delete_restrictions_box, 1, 0, 0 );
  deltrans_layout->addWidget( transfer_box, 2, 0, 0 );
  deltrans_layout->addItem( spacer2, 3, 0 );

  addTab( deltrans_tab, i18n( "File Deletion && Transfer" ) );


  //
  // The Filter tab
  //
  TQWidget *filter_tab = new TQWidget( this, "RsyncFiltering" );
  TQGridLayout *filter_layout = new TQGridLayout( filter_tab );
  filter_layout->setSpacing( 10 );

  TQButtonGroup *general_filter_box = new TQButtonGroup( 2, TQt::Horizontal, i18n( "General" ),
                                     filter_tab, "RsyncGeneralFilterBox" );
  general_filter_box->setInsideSpacing( 5 );

  (void) new TQCheckBox( i18n( "Auto-ignore files in the same way CVS does" ), general_filter_box, "kcfg_UseCVSExclude" );
  general_filter_box->addSpace( 0 );
  (void) new TQCheckBox( i18n( "Exclude files matching this pattern:" ), general_filter_box, "kcfg_UseExcludePattern" );
  (void) new KLineEdit( general_filter_box, "kcfg_ExcludePattern" );
  (void) new TQCheckBox( i18n( "Read exclude patterns from:" ), general_filter_box, "kcfg_UseExcludeFrom" );
  KURLRequester *exclude_from = new KURLRequester( general_filter_box, "kcfg_ExcludeFrom" );
  exclude_from->setMode( KFile::File | KFile::LocalOnly );
  (void) new TQCheckBox( i18n( "Don't exclude files matching this pattern:" ), general_filter_box, "kcfg_UseIncludePattern" );
  (void) new KLineEdit( general_filter_box, "kcfg_IncludePattern" );
  (void) new TQCheckBox( i18n( "Read include patterns from:" ), general_filter_box, "kcfg_UseIncludeFrom" );
  KURLRequester *include_from = new KURLRequester( general_filter_box, "kcfg_IncludeFrom" );
  include_from->setMode( KFile::File | KFile::LocalOnly );

  TQButtonGroup *filter_rules_box = new TQButtonGroup( 1, TQt::Horizontal, i18n( "Filter Rules" ),
                                   filter_tab, "RsyncFilterRulesBox" );
  filter_rules_box->setInsideSpacing( 5 );
  TQLabel *filter_rules_label = new TQLabel( i18n( "The rules defined below will be added to the \"rsync\" command as they are. Thus, you have to start with the --filter=... argument." ), filter_rules_box );
  filter_rules_label->setTextFormat( TQt::RichText );
  (void) new KLineEdit( filter_rules_box, "kcfg_CustomFilteringRules" );
  (void) new TQLabel( i18n( "Special filter rules:" ), filter_rules_box );
  TQCheckBox *f_filter = new TQCheckBox( i18n( "Use --filter='dir-merge /.rsync-filter' filter rule" ), filter_rules_box, "kcfg_UseFFilterRule" );
  TQCheckBox *ff_filter = new TQCheckBox( i18n( "Use --filter='exclude .rsync-filter' filter rule" ), filter_rules_box, "kcfg_UseFFFilterRule" );

  TQSpacerItem *spacer3 = new TQSpacerItem( 0, 0, TQSizePolicy::Preferred, TQSizePolicy::Expanding );

  filter_layout->addWidget( general_filter_box, 0, 0, 0 );
  filter_layout->addWidget( filter_rules_box, 1, 0, 0 );
  filter_layout->addItem( spacer3, 2, 0 );

  addTab( filter_tab, i18n( "Filtering" ) );


  //
  // The Advanced tab
  //
  TQWidget *advanced_tab = new TQWidget( this, "RsyncAdvanced" );
  TQGridLayout *advanced_layout = new TQGridLayout( advanced_tab );
  advanced_layout->setSpacing( 10 );

  TQButtonGroup *misc_box = new TQButtonGroup( 2, TQt::Horizontal, i18n( "General" ),
                           advanced_tab, "RsyncAdvancedMiscBox" );
  misc_box->setInsideSpacing( 5 );

  (void) new TQCheckBox( i18n( "Handle sparse files efficiently" ), misc_box, "kcfg_EfficientSparseFileHandling" );
  (void) new TQCheckBox( i18n( "Copy files whole (no rsync algorithm)" ), misc_box, "kcfg_CopyFilesWhole" );
  (void) new TQCheckBox( i18n( "Don't cross file system boundaries" ), misc_box, "kcfg_OneFileSystem" );
  (void) new TQCheckBox( i18n( "Only update files that already exist" ), misc_box, "kcfg_UpdateExisting" );
  (void) new TQCheckBox( i18n( "Ignore files that already exist" ), misc_box, "kcfg_IgnoreExisting" );
  (void) new TQCheckBox( i18n( "Delay updates until the end of transfer" ), misc_box, "kcfg_DelayUpdates" );

  TQButtonGroup *backup_box = new TQButtonGroup( 2, TQt::Horizontal, i18n( "Backup" ), advanced_tab, "RsyncBackupBox" );
  backup_box->setInsideSpacing( 5 );

  TQCheckBox *backup = new TQCheckBox( i18n( "Make backups" ), backup_box, "kcfg_MakeBackups" );
  backup_box->addSpace( 0 );
  (void) new TQCheckBox( i18n( "Backup suffix:" ), backup_box, "kcfg_UseBackupSuffix" );
  (void) new KLineEdit( backup_box, "kcfg_BackupSuffix" );
  (void) new TQCheckBox( i18n( "Backup directory:" ), backup_box, "kcfg_UseBackupDirectory" );
  KURLRequester *backup_dir = new KURLRequester( backup_box, "kcfg_BackupDirectory" );
  backup_dir->setMode( KFile::Directory | KFile::LocalOnly );

  TQButtonGroup *checksum_box = new TQButtonGroup( 2, TQt::Horizontal, i18n( "Checksums" ), advanced_tab, "RsyncChecksumsBox" );
  checksum_box->setInsideSpacing( 5 );

  (void) new TQCheckBox( i18n( "Force fixed checksum block size:" ), checksum_box, "kcfg_UseBlockSize" );
  (void) new KIntNumInput( checksum_box, "kcfg_BlockSize" );
  (void) new TQCheckBox( i18n( "Set block/file checksum seed:" ), checksum_box, "kcfg_UseChecksumSeed" );
  (void) new KIntNumInput( checksum_box, "kcfg_ChecksumSeed" );
  (void) new TQCheckBox( i18n( "Skip files based on checksum" ), checksum_box, "kcfg_UseChecksum" );
  checksum_box->addSpace( 0 );

  TQSpacerItem *spacer4 = new TQSpacerItem( 0, 0, TQSizePolicy::Preferred, TQSizePolicy::Expanding );

  advanced_layout->addWidget( misc_box, 0, 0, 0 );
  advanced_layout->addWidget( backup_box, 1, 0, 0 );
  advanced_layout->addWidget( checksum_box, 2, 0, 0 );
  advanced_layout->addItem( spacer4, 3, 0 );

  addTab( advanced_tab, i18n( "Advanced" ) );

  connect( archive_mode, TQ_SIGNAL( toggled( bool ) ),
           this,         TQ_SLOT( slotArchiveToggled( bool ) ) );

  connect( recursive,    TQ_SIGNAL( toggled( bool ) ),
           this,         TQ_SLOT( slotUncheckArchive( bool ) ) );

  connect( links,        TQ_SIGNAL( toggled( bool ) ),
           this,         TQ_SLOT( slotUncheckArchive( bool ) ) );

  connect( perms,        TQ_SIGNAL( toggled( bool ) ),
           this,         TQ_SLOT( slotUncheckArchive( bool ) ) );

  connect( times,        TQ_SIGNAL( toggled( bool ) ),
           this,         TQ_SLOT( slotUncheckArchive( bool ) ) );

  connect( group,        TQ_SIGNAL( toggled( bool ) ),
           this,         TQ_SLOT( slotUncheckArchive( bool ) ) );

  connect( owner,        TQ_SIGNAL( toggled( bool ) ),
           this,         TQ_SLOT( slotUncheckArchive( bool ) ) );

  connect( devices,      TQ_SIGNAL( toggled( bool ) ),
           this,         TQ_SLOT( slotUncheckArchive( bool ) ) );

  connect( backup,       TQ_SIGNAL( toggled( bool ) ),
           this,         TQ_SLOT( slotBackupToggled( bool ) ) );

  connect( f_filter,     TQ_SIGNAL( toggled( bool ) ),
           this,         TQ_SLOT( slotFShortcutToggled( bool ) ) );

  connect( ff_filter,    TQ_SIGNAL( toggled( bool ) ),
           this,         TQ_SLOT( slotFFShortcutToggled( bool ) ) );

  slotArchiveToggled( true );
  slotBackupToggled( false );
}


Smb4KRsyncOptions::~Smb4KRsyncOptions()
{
}


/////////////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATIONS
/////////////////////////////////////////////////////////////////////////////

void Smb4KRsyncOptions::slotArchiveToggled( bool on )
{
  if ( on )
  {
    static_cast<TQCheckBox *>( child( "kcfg_RecurseIntoDirectories", "TQCheckBox", true ) )->setChecked( on );
    static_cast<TQCheckBox *>( child( "kcfg_PreserveSymlinks", "TQCheckBox", true ) )->setChecked( on );
    static_cast<TQCheckBox *>( child( "kcfg_PreservePermissions", "TQCheckBox", true ) )->setChecked( on );
    static_cast<TQCheckBox *>( child( "kcfg_PreserveTimes", "TQCheckBox", true ) )->setChecked( on );
    static_cast<TQCheckBox *>( child( "kcfg_PreserveGroup", "TQCheckBox", true ) )->setChecked( on );
    static_cast<TQCheckBox *>( child( "kcfg_PreserveOwner", "TQCheckBox", true ) )->setChecked( on );
    static_cast<TQCheckBox *>( child( "kcfg_PreserveDevicesAndSpecials", "TQCheckBox", true ) )->setChecked( on );
  }
}


void Smb4KRsyncOptions::slotUncheckArchive( bool on )
{
  if ( !on )
  {
    static_cast<TQCheckBox *>( child( "kcfg_ArchiveMode", "TQCheckBox", true ) )->setChecked( on );
  }
}


void Smb4KRsyncOptions::slotBackupToggled( bool on )
{
  static_cast<TQCheckBox *>( child( "kcfg_UseBackupDirectory", "TQCheckBox", true ) )->setEnabled( on );
  static_cast<KURLRequester *>( child( "kcfg_BackupDirectory", "KURLRequester", true ) )->setEnabled( on );
  static_cast<TQCheckBox *>( child( "kcfg_UseBackupSuffix", "TQCheckBox", true ) )->setEnabled( on );
  static_cast<KLineEdit *>( child( "kcfg_BackupSuffix", "KLineEdit", true ) )->setEnabled( on );
}


void Smb4KRsyncOptions::slotFShortcutToggled( bool on )
{
  TQCheckBox *ff_filter = static_cast<TQCheckBox *>( child( "kcfg_UseFFFilterRule", "TQCheckBox", true ) );

  if ( on && ff_filter->isChecked() )
  {
    ff_filter->setChecked( false );
  }
}


void Smb4KRsyncOptions::slotFFShortcutToggled( bool on )
{
  TQCheckBox *f_filter = static_cast<TQCheckBox *>( child( "kcfg_UseFFilterRule", "TQCheckBox", true ) );

  if ( on && f_filter->isChecked() )
  {
    f_filter->setChecked( false );
  }
}

#include "smb4tdersyncoptions.moc"
