/***************************************************************************
                          commands_insert  -  description
                             -------------------
    begin                : Wed Nov 26 2003
    copyright            : (C) 2003 by The KXMLEditor Team
    email                : lvanek.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef COMMANDS_INSERT_H
#define COMMANDS_INSERT_H

#include <tdelocale.h>

#include "kxecommand.h"
#include "kxechardatadialog.h"

/**
@author The KXMLEditor Team
*/
class KXEElementCommand : public KXECommand
{
	public:
		KXEElementCommand(KXEDocument*, TQDomDocument *, TQString, TQString, TQString);
		KXEElementCommand(KXEDocument*, TQDomElement &, TQString, TQString, TQString, bool);
		~KXEElementCommand();
		virtual void execute();
		virtual void unexecute();
		virtual TQString name() const { return i18n("Insert element"); }

	protected:
		TQDomDocument * m_pDomDoc;
		TQDomElement m_domParentElement;
		bool m_bAtTop;
		TQDomElement m_domElement;
};

class KXEAttributeCommand : public KXECommand
{
	public:
		KXEAttributeCommand(KXEDocument*, TQDomElement &, TQString, TQString, TQString);
		~KXEAttributeCommand();
		virtual void execute();
		virtual void unexecute();
		virtual TQString name() const { return i18n("Insert attribute"); }

	protected:
		TQString m_strNamespace;
		TQString m_strQName;
		TQString m_strValue;
		TQDomElement m_domOwnerElement;
};

class KXECharDataCommand : public KXECommand
{
	public:
		KXECharDataCommand(KXEDocument*, TQDomElement &, bool, CharDataKind, TQString);
		~KXECharDataCommand();
		virtual void execute();
		virtual void unexecute();
		virtual TQString name() const { return i18n("Insert char data"); }

	protected:

		bool m_bAtTop;
		TQDomElement m_domParentElement;
		TQDomCharacterData m_domCharData;
};

class KXEProcInstrCommand : public KXECommand
{
	public:
		KXEProcInstrCommand(KXEDocument*, TQDomDocument *, bool, TQString, TQString);
		KXEProcInstrCommand(KXEDocument*, TQDomElement &, bool, TQString, TQString);
		~KXEProcInstrCommand();
		virtual void execute();
		virtual void unexecute();
		virtual TQString name() const { return i18n("Insert proc. instr."); }

	protected:
		TQDomDocument * m_pDomDoc;
		TQDomElement m_domParentElement;
		bool m_bAtTop;
		TQDomProcessingInstruction m_domProcInstr;
};

#endif
