/*
	configuration.cpp - A configuration
	Copyright (C) 2004  Konrad Twardowski <kdtonline@poczta.onet.pl>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "actions.h"
#include "configuration.h"
#include "mmainwindow.h"
#include "msystemtray.h"

Config *Config::_instance = 0;

// public

Config::Config()
{
	// automation
	setCurrentGroup("Automation");
	i_cdTrayClose = addItemBool("cd_tray_close", cdTrayClose, false, "CDTrayClose");
#ifdef Q_OS_FREEBSD
	i_cdTrayCloseCommand = addItemString("cd_tray_close_command", cdTrayCloseCommand, "cdcontrol close", "CDTrayCloseCommand");
#else
	i_cdTrayCloseCommand = addItemString("cd_tray_close_command", cdTrayCloseCommand, "eject -t", "CDTrayCloseCommand");
#endif

	// custom message
	setCurrentGroup("Custom Message");
	i_customMessageEnabled = addItemBool("custom_message_enabled", customMessageEnabled, true, "Enabled");
	i_customMessageCommand = addItemString("custom_message_command", customMessageCommand, KS_CONFIG_KDIALOG_MESSAGE);

	// general
	setCurrentGroup("General");
	ItemInt *i;
	i = addItemInt("general_action", generalAction, Action::ShutDown, "Action");
	i->setMinValue(Action::ShutDown);
	i->setMaxValue(Action::Extras);
	i = addItemInt("general_delay_type", generalDelayType, MMainWindow::DelayType_TimeFromNow, "DelayType");
	i->setMinValue(MMainWindow::DelayType_Now);
	i->setMaxValue(MMainWindow::DelayType_OnAppExit);
	addItemDateTime("general_date_time", generalDateTime, TQDateTime::currentDateTime(), "DelayTime");

	// progress bar
	setCurrentGroup("Progress Bar");
	i_progressBarEnabled = addItemBool("progress_bar_enabled", progressBarEnabled, false, "Enabled");
	i_progressBarPosition = addItemInt("progress_bar_position", progressBarPosition, 0, "Position");

	// statistics
	setCurrentGroup("Statistics");
	i_statsLongFormat = addItemBool("stats_long_format", statsLongFormat, false, "LongFormat");
	i_statsToggleFromField = addItemBool("stats_toggle_from_field", statsToggleFromField, false, "ToggleFromField");

	// system tray
	setCurrentGroup("System Tray");
	i_systemTray = addItemInt("system_tray", systemTray, MSystemTray::Always, "Always");
	i_systemTray->setMinValue(MSystemTray::Always);
	i_systemTray->setMaxValue(MSystemTray::Never);

	// warning message
	setCurrentGroup("Warning Message");
	i_warningMessageEnabled = addItemBool("warning_message_enabled", warningMessageEnabled, true, "Enabled");
	i_warningMessageDelay = addItemInt("warning_message_delay", warningMessageDelay, 2, "Delay");
	i_warningMessageDelay->setMinValue(1);
	i_warningMessageDelay->setMaxValue(60);

	readConfig();
}
