/***************************************************************************
                          datetime.cpp  -  description
                             -------------------
    begin                : Mon Jan 7 2002
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "datetime.h"

// TQt includes
#include <tqcheckbox.h>
#include <tqfileinfo.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqpushbutton.h>

// TDE includes
#include <tdeapplication.h>
#include <kiconloader.h>
#include <kdatepik.h>
#include <knuminput.h>
#include <tdelocale.h>

// OS includes
#include <stdio.h>
#include <time.h>
#include <utime.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>

const TQString MyDatePlugin::getName() const
{
    return i18n("Date & Time");
}

const TQString MyDatePlugin::getAccelName() const
{
    return i18n("Date && &Time");
}

const int MyDatePlugin::type() const
{
    return TYPE_FINAL_FILE;
}

bool MyDatePlugin::checkError()
{
    return true;
}

const TQPixmap MyDatePlugin::getIcon() const
{
    return kapp->iconLoader()->loadIcon( "kalarm", TDEIcon::Small );
}

void MyDatePlugin::drawInterface( TQWidget* w, TQVBoxLayout* l )
{
    m_widget = w;

#ifdef BENNY
    l->addWidget( new TQLabel("Setze Modifiaction Time um eine Stunde zurück", w) );
#else
    Layout0 = new TQHBoxLayout( 0, 0, 6, "Layout0");
    Layout1 = new TQVBoxLayout( 0, 0, 6, "Layout1");
    Layout2 = new TQHBoxLayout( 0, 0, 6, "Layout2");

    kDate = new KDatePicker( w );

    checkAccess = new TQCheckBox( w, "checkAccess" );
    checkAccess->setText( i18n( "Change &access date && time" ) );

    checkModification = new TQCheckBox( w, "checkModification" );
    checkModification->setText( i18n( "Change &modification date && time" ) );

    labelTime = new TQLabel( w, "labelTime" );
    labelTime->setText( i18n( "Time:" ) );

    spinHour = new KIntSpinBox( w, "spinHour" );
    spinHour->setSuffix( i18n( "h" ) );
    spinHour->setMaxValue( 23 );

    spinMinute = new KIntSpinBox( w, "spinMinute" );
    spinMinute->setSuffix( i18n( "min" ) );
    spinMinute->setMaxValue( 59 );

    spinSecond = new KIntSpinBox( w, "spinSecond" );
    spinSecond->setSuffix( i18n( "s" ) );
    spinSecond->setMaxValue( 59 );

    buttonCurrentDT = new TQPushButton( w, "buttonCurrentDT" );
    buttonCurrentDT->setText( i18n( "&Get Current Date && Time" ) );

    Layout2->addWidget( labelTime );
    Layout2->addWidget( spinHour );
    Layout2->addWidget( spinMinute );
    Layout2->addWidget( spinSecond );

    Layout1->addWidget( kDate );
    Layout1->addWidget( checkAccess );
    Layout1->addWidget( checkModification );
    Layout1->addLayout( Layout2 );
    Layout1->addWidget( buttonCurrentDT );


    Layout0->addLayout( Layout1 );
    TQSpacerItem* spacer = new TQSpacerItem( 20, 20, TQSizePolicy::Minimum, TQSizePolicy::Expanding );
    Layout0->addItem( spacer );

    l->addLayout( Layout0 );

    connect( buttonCurrentDT, TQ_SIGNAL(clicked()), this, TQ_SLOT(changeDT()));
#endif
}

void MyDatePlugin::fillStructure()
{
#ifndef BENNY
    dvals.date = kDate->date();
    dvals.changeModification = checkModification->isChecked();
    dvals.changeAccess = checkAccess->isChecked();
    dvals.hour = spinHour->value();
    dvals.minute = spinMinute->value();
    dvals.second = spinSecond->value();
#endif
}

TQString MyDatePlugin::processFile( BatchRenamer* b, int i, TQString, int )
{
#ifdef BENNY
    TQString filename = b->files()[i].dst.name;

    FILE * f;
    struct utimbuf * t = new utimbuf();
    struct tm tmp;
    struct stat st;

    time_t ti;

    f = fopen((const char *)filename, "r");
    if( f == NULL )
        return i18n("Can't change date of file %1.").arg(filename);

    fclose( f );

    TQFileInfo info( filename );
    tmp.tm_mday = info.lastModified().date().day();
    tmp.tm_mon = info.lastModified().date().month() - 1;
    tmp.tm_year = info.lastModified().date().year() - 1900;

    tmp.tm_hour = info.lastModified().time().hour() - 1;
    tmp.tm_min = info.lastModified().time().minute();
    tmp.tm_sec = info.lastModified().time().second();
    tmp.tm_isdst = -1;

    ti = mktime( &tmp );
    if( ti == -1 )
        return i18n("Can't change date of file %1.").arg(filename);

    if( stat( (const char *)filename, &st ) == -1 )
        return i18n("Can't change date of file %1.").arg(filename);

    t->actime = st.st_atime;
    t->modtime = ti;

    if(utime( (const char *)filename, t ) != 0)
        return i18n("Can't change date of file %1.").arg(filename);

    return TQString();
#else
    TQString filename = b->files()[i].dst.name;

    FILE * f;
    struct utimbuf * t = new utimbuf();
    struct tm tmp;
    struct stat st;

    time_t ti;

    f = fopen(filename.local8Bit(), "r");
    if( f == NULL )
        return i18n("Can't change date of file %1.").arg(filename);

    fclose( f );

    tmp.tm_mday = dvals.date.day();
    tmp.tm_mon = dvals.date.month() - 1;
    tmp.tm_year = dvals.date.year() - 1900;

    tmp.tm_hour = dvals.hour;
    tmp.tm_min = dvals.minute;
    tmp.tm_sec = dvals.second;
    tmp.tm_isdst = -1;

    ti = mktime( &tmp );
    if( ti == -1 )
        return i18n("Can't change date of file %1.").arg(filename);

    if (stat(filename.local8Bit(), &st) == -1)
        return i18n("Can't change date of file %1.").arg(filename);

    if(dvals.changeAccess)
        t->actime = ti;
    else
        t->actime = st.st_atime;

    if(dvals.changeModification)
        t->modtime = ti;
    else
        t->modtime = st.st_mtime;

    if (utime(filename.local8Bit(), t) != 0)
        return i18n("Can't change date of file %1.").arg(filename);

    return TQString();
#endif
}

void MyDatePlugin::changeDT()
{
    spinHour->setValue( TQTime::currentTime().hour());
    spinMinute->setValue( TQTime::currentTime().minute());
    spinSecond->setValue( TQTime::currentTime().second());
    kDate->setDate( TQDate::currentDate() );
}

#include "datetime.moc"

