/***************************************************************************
*   Copyright (C) 2003 by                                                 *
*   Unai Garro (ugarro@users.sourceforge.net)                             *
*   Cyril Bosselut (bosselut@b1project.com)                               *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#include "authorsdialog.h"
#include "createelementdialog.h"
#include "backends/recipedb.h"
#include "widgets/authorlistview.h"

#include <kdialog.h>
#include <tdelocale.h>
#include <tdemessagebox.h>

AuthorsDialog::AuthorsDialog( TQWidget* parent, RecipeDB *db ) : TQWidget( parent )
{

	// Store pointer to database
	database = db;

	TQHBoxLayout* layout = new TQHBoxLayout( this, KDialog::marginHint(), KDialog::spacingHint() );

	//Author List
	authorListView = new StdAuthorListView( this, database, true );
	layout->addWidget( authorListView );

	//Buttons
	TQVBoxLayout* vboxl = new TQVBoxLayout( KDialog::spacingHint() );

	newAuthorButton = new TQPushButton( this );
	newAuthorButton->setText( i18n( "Create ..." ) );
	newAuthorButton->setFlat( true );
	vboxl->addWidget( newAuthorButton );

	removeAuthorButton = new TQPushButton( this );
	removeAuthorButton->setText( i18n( "Delete" ) );
	removeAuthorButton->setFlat( true );
	vboxl->addWidget( removeAuthorButton );
	vboxl->addStretch();

	layout->addLayout( vboxl );

	//Connect Signals & Slots

	connect ( newAuthorButton, TQ_SIGNAL( clicked() ), authorListView, TQ_SLOT( createNew() ) );
	connect ( removeAuthorButton, TQ_SIGNAL( clicked() ), authorListView, TQ_SLOT( remove
		          () ) );
}

AuthorsDialog::~AuthorsDialog()
{}

// (Re)loads the data from the database
void AuthorsDialog::reload( ReloadFlags flag )
{
	authorListView->reload( flag );
}

#include "authorsdialog.moc"
