###########################################
#                                         #
#  Improvements and feedback are welcome  #
#                                         #
#  This file is released under GPL >= 3   #
#                                         #
###########################################

# required stuff
find_package( TQt )
find_package( TDE )

tde_setup_compiler_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )


##### check for gcc visibility support

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( WITH_GCC_VISIBILITY )


#### check for libotr

pkg_search_module( LIBOTR libotr )

if( LIBOTR_FOUND )
    if( NOT LIBOTR_VERSION VERSION_LESS 4.0.0 )
        set( HAVE_LIBOTR_0400 1 )
    endif()
 else()
    tde_message_fatal( "Libotr is required but was not found on your system" )
endif( LIBOTR_FOUND )


##### check for kopete

find_library( KOPETE_LIBRARY kopete )
find_path( KOPETE_INCLUDE_DIR kopetemetacontact.h
           PATH_SUFFIXES kopete
)

if( KOPETE_INCLUDE_DIR AND KOPETE_LIBRARY )
    set( KOPETE_INCLUDE_DIRS "${KOPETE_INCLUDE_DIR}" )
    set( KOPETE_LIBRARIES ${KOPETE_LIBRARY} )
 else()
    tde_message_fatal( "kopete (tdenetwork) is required but was not found on your system" )
endif( KOPETE_INCLUDE_DIR AND KOPETE_LIBRARY )
