/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/

/*
  Shows the content of a log file
  begin:     Fri Dec 5 2003
  copyright: (C) 2003 by Dario Abatianni
  email:     eisfuchs@tigress.com
*/

#ifndef LOGFILEREADER_H
#define LOGFILEREADER_H

#include "chatwindow.h"

#include <tdeio/job.h>


class TDEToolBar;
class TQSpinBox;

class LogfileReader : public ChatWindow
{
    TQ_OBJECT
  

        public:
        LogfileReader(TQWidget* parent, const TQString& log);
        ~LogfileReader();

        virtual bool closeYourself() { closeLog(); return true; }
        virtual bool searchView();

        virtual bool eventFilter(TQObject* watched, TQEvent* e);


    protected slots:
        void updateView();
        void clearLog();
        void saveLog();
        void closeLog();
        void copyResult(TDEIO::Job* job);


    protected:
        int margin();
        int spacing();

        /** Called from ChatWindow adjustFocus */
        virtual void childAdjustFocus();

        TDEToolBar* toolBar;
        TQSpinBox* sizeSpin;
        TQString fileName;
};
#endif
