/***************************************************************************
 *   Copyright (C) 2004 by Sergio Cambra                                   *
 *   runico@users.berlios.de                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SERVICEMENU_H
#define SERVICEMENU_H

#include <tdepopupmenu.h>
#include <tdesycocaentry.h>
#include <kservice.h>

class KServiceGroup;

/**
@author Sergio Cambra
 */
class ServiceMenu : public TDEPopupMenu
{
TQ_OBJECT
public:
    ServiceMenu(TQObject *receiver, const char *slotActivatedItem,
                const char *slotActivatedGroup, TQWidget *parent = 0, const char *name = 0);
    ServiceMenu(const TQString & relPath, TQObject *receiver, const char *slotActivatedItem,
                const char *slotActivatedGroup, TQWidget *parent = 0, const char *name = 0);

    ~ServiceMenu();

signals:
	void serviceSelected(KService*);
    void serviceGroupSelected(KServiceGroup*);
	
protected slots:
	void createMenu();
	void slotActivated(int id);

private:
    TQIconSet getIconSet(const TQString& icon) const;
	TQString m_relPath;
	TQPtrList<TQPopupMenu> m_subMenus;
	TQMap<int, KSycocaEntry::Ptr> m_entryMap;
	TQObject *m_receiver;
	const char *m_slotActivatedItem;
    const char *m_slotActivatedGroup;
	
	void initialize();
	void insertMenuItem(KService::Ptr &s, const TQStringList *suppressGenericNames = 0);
};

#endif
