/*
   This file is part of the KDE project
   Copyright (C) 2004 Dirk Schmidt <fs@dirk-schmidt.net>
 
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef _KWMAILMERGE_KABC_CONFIG_H_
#define _KWMAILMERGE_KABC_CONFIG_H_

#include <kdialogbase.h>
#include <tdelistview.h>
#include <tdeabc/stdaddressbook.h>

#include "KWMailMergeTDEABC.h"


class AddressPickerUI;
class KWMailMergeTDEABC;

class KWMailMergeTDEABCConfig: public KDialogBase
{
    TQ_OBJECT
  
public:
    KWMailMergeTDEABCConfig( TQWidget *parent, KWMailMergeTDEABC *db_ );
    virtual ~KWMailMergeTDEABCConfig();


private slots:

    /**
       Moves selected items from the left Listview to the right one.
     */
    void addSelectedContacts();

    /**
       Moves selected items from the right Listview to the left one.
     */
    void removeSelectedContacts();

    /**
       Executes KAddressbook as external application.
     */
    void launchAddressbook() const;

    /**
       Updates the parent's mail merge list from items in the right Listview.
     */
    void acceptSelection();

    /**
       Hides items in the left listview, which are not matching  @p txt.
     */
    void filterChanged( const TQString& txt );

    /**
       Saves the selected single entries to a new TDEABC::DistributionList in KAddressbook.
     */
    void saveDistributionList();
private:
    /**
       The addresspicker widget.
     */
    AddressPickerUI *_ui;

    /**
       Store all categories used in the addressbook, to avoid some iterator cycles.
     */
    TQStringList _usedCategories;

    /**
       The mail merge list.
    */
    KWMailMergeTDEABC *_db;

    /**
       Removes duplicates in the left TQListView, when moving an item to the right.
     */
    void destroyAvailableClones( const TQString& uid );

    /**
       Appends the previously selected entries to the right TQListView.
     */
    void initSelectedAddressees();

    /**
      Appends the previously selected distribution lists to the right TQListView.
    */
    void initSelectedLists();

    /**
       Just connects signals and slots.
     */
    void initSlotSignalConnections();

    /**
       Moves @p item from the right Listview to the left one.
       
       Called by KWMailMergeTDEABCConfig::removeSelectedContacts().
     */
    void removeContact( TQListViewItem* item );

    /**
       Appends all KAddressbook entries in TDEABC::StdAddressBook::self() and all
       TDEABC::DistributionLists to the left TQListView.
    */
    void updateAvailable();
};


class KWMailMergeTDEABCConfigListItem : public TQListViewItem
{

public:
    KWMailMergeTDEABCConfigListItem( TQListView *parent, const TDEABC::Addressee& addressEntry );
    KWMailMergeTDEABCConfigListItem( TQListViewItem *parent, const TDEABC::Addressee& addressEntry );
    virtual ~KWMailMergeTDEABCConfigListItem();

    /**
       Returns the TDEABC::Addressee of a KWMailMergeTDEABCConfigListItem.
     */
    TDEABC::Addressee addressee() const;

    /**
       This is an overloaded member function of TQListViewItem::text( int column ).
       It Returns the TDEABC::Addressee::uid(), if column is set to -1.
       Otherwise TQListViewItem::text( int column ) is returned.
     */
    TQString text( int column ) const;


private:
    TDEABC::Addressee _addressEntry;

};
#endif
