/*
 * Kivio - Visual Modelling and Flowcharting
 * Copyright (C) 2000-2001 theKompany.com & Dave Marotti
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef KIVIO_COMMON_H
#define KIVIO_COMMON_H

#include <tqdom.h>
#include <tqcolor.h>

class KivioConnectorPoint;
class KoPoint;
class KoRect;

extern "C" {

   KoRect XmlReadRect( const TQDomElement &, const TQString &, const KoRect & );
   void  XmlWriteRect( TQDomElement &, const TQString &, const KoRect & );
   
   TQColor XmlReadColor( const TQDomElement &, const TQString &, const TQColor & );
   void  XmlWriteColor( TQDomElement &, const TQString &, const TQColor & );
   
   int XmlReadInt( const TQDomElement &, const TQString &, const int & );
   void  XmlWriteInt( TQDomElement &, const TQString &, const int & );
   
   uint XmlReadUInt( const TQDomElement &, const TQString &, const uint & );
   void  XmlWriteUInt( TQDomElement &, const TQString &, const uint & );
   
   double XmlReadDouble( const TQDomElement &, const TQString &, const double & );
   void  XmlWriteDouble( TQDomElement &, const TQString &, const double & );
   
   float XmlReadFloat( const TQDomElement &, const TQString &, const float & );
   void  XmlWriteFloat( TQDomElement &, const TQString &, const float & );
   
   TQString XmlReadString( const TQDomElement &, const TQString &, const TQString & );
   void    XmlWriteString( TQDomElement &,  const TQString &, const TQString & );
   
   bool PointInPoly( KoPoint *points, int numPoints, KoPoint *hitPos );
   
   float shortestDistance( KivioConnectorPoint *pStart, KivioConnectorPoint *pEnd, KivioConnectorPoint *q );

}

#endif


