/* This file is part of the KDE project
   Copyright (C) 2003 Jaroslaw Staniek <js@iidea.pl>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef KEXIDB_RECORD_H
#define KEXIDB_RECORD_H

#include <tqvaluelist.h>
#include <tqstring.h>

#include <kexidb/field.h>

namespace KexiDB {

/*! KexiDB::Record provides single database record.
*/

class KEXI_DB_EXPORT Record {
public:
	Record(const TQString & name);

//TODO.............
	Table();
	~Table();
	const TQString& name() const;
	void setName(const TQString& name);
	unsigned int fieldCount() const;
	KexiDB::Field field(unsigned int id) const;
	TQStringList primaryKeys() const;
	bool hasPrimaryKeys() const;
//js	void addField(KexiDB::Field field);
//js	void addPrimaryKey(const TQString& key);
private:
//js	TQStringList m_primaryKeys;
	TQValueList<Field> m_fields;
	TQString m_name;
	Connection* m_conn;
};


/*
class KexiDBTableFields: public TQValueList<KexiDBField> {
public:
	KexiDBTable(const TQString & name);
	~KexiDBTable();
	void addField(KexiDBField);
//	const TQString& tableName() const;

private:
//	TQString m_tableName;
};
*/

} //namespace KexiDB

#endif
