/***************************************************************************
                          definitions.h  -  description
                             -------------------
    begin                : Sun Jul 1 2001
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef _DEFINITIONS_H
#define _DEFINITIONS_H

#ifndef _VERSION_
#	define _VERSION_ "0.6"
#endif

#define IMAGE_MAX 144
#define IMAGE_MIN 32

#define CONFIG_VERSION 1

#include <kdebug.h>
#include <tqvaluelist.h>

/*
		These are used to define the game's states.
*/
const int WHITE									= 0x00;
const int BLACK									= 0x01;
const int WHITE_HELPER					= 0x02;
const int BLACK_HELPER					= 0x03;
const int BOTH									= 0x04;

const int PLAYERPC							= 0x00; // Chess Engine
const int PLAYEREMAIL						= 0x01; // Email Opponent
const int PLAYERTCP							= 0x02; // Internet Chess Engine
const int PLAYERLOAD						= 0x03; // Load from PGN

					/* Add a mask of 0x10 to players that accept user input */
const int PLAYERLOCAL						= 0x10; // Human sitting at the PC
const int PLAYEREXAMINE					= 0x11; // ICS Examine Mode

const int ENGINE_WHITE					= 0x01;
const int ENGINE_WHITE_BK				= 0x02;
const int ENGINE_BLACK					= 0x04;
const int ENGINE_BLACK_BK				= 0x08;

	/* Menu Entries */

/*
		These represent the various choices found
		throughout the game's menubar.
*/

/* File Menu */
const int MENU_NEWGAME					= 0x01;
const int MENU_LOAD							= 0x02;
const int MENU_SAVE							= 0x03;
const int MENU_SAVEAS						= 0x04;
const int MENU_PRINT						= 0x05;
const int MENU_QUIT							= 0x06;
const int MENU_CLOSE						= 0x08;
const int MENU_CLOSEALL					= 0x09;
const int MENU_CONNECT					= 0x0A;
/* Options Menu */
const int MENU_BINDINGS_DIALOG	= 0x13;
const int MENU_SETTINGS_DIALOG	= 0x14;
const int MENU_INSTALL_THEMES		= 0x15;
/* New Games Menu */
const int MENU_SOLITARE					= 0x21;
const int MENU_VS_PC						= 0x22;
const int MENU_VS_TCPIP					= 0x23;
const int MENU_VS_EMAIL					= 0x24;
const int MENU_PC_VS_PC					= 0x25;
/* Match Menu */
const int MENU_RETRACT					= 0x31;
const int MENU_DRAW							= 0x32;
const int MENU_MOVE_NOW					= 0x33;
const int MENU_HINT							= 0x34;
const int MENU_PONDER						= 0x35;
const int MENU_PAUSE						= 0x36;
const int MENU_PAUSEALL					= 0x37;
const int MENU_ORIENTATION			= 0x38;
const int MENU_RESIGN						= 0x39;
const int MENU_CALL_FLAG				= 0x3A;
/* Draw Menu */
const int MENU_OFFER_DRAW				= 0x41;
const int MENU_ACCEPT_DRAW			= 0x42;
const int MENU_REJECT_DRAW			= 0x43;
const int MENU_IGNORE_DRAW			= 0x44;
/* Seek Menu */
const int MENU_SEEK							= 0x51;
const int MENU_FINGER						= 0x52;
const int MENU_TELL							= 0x53;
const int MENU_NOTIFY						= 0x54;
const int MENU_ACCEPT_MATCH			= 0x55;
const int MENU_CENSOR						= 0x56;
const int MENU_HISTORY					= 0x57;
const int MENU_ASSESS						= 0x58;
/* View Menu */
const int MENU_COPY							= 0x61;
const int MENU_SELECT_ALL				= 0x62;
const int MENU_CLEAR_ALL				= 0x63;
const int MENU_FIND							= 0x64;
const int MENU_FIND_NEXT				= 0x65;
const int MENU_ZOOM_IN					= 0x66;
const int MENU_ZOOM_OUT					= 0x67;
/* Tutorial Menu */
const int MENU_OPEN_TUTORIAL		= 0x71;

		/* Messages */

/*
			The following constants define messages
			viewed in the statusbar.
*/
const int READY									= 0x00000000;
const int WHITE_TURN						= 0x00000001;
const int BLACK_TURN						= 0x00000002;
const int WHITE_WIN							= 0x00000003;
const int BLACK_WIN							= 0x00000004;
const int GAME_DRAW							= 0x00000005;
const int GAME_50_MOVES					= 0x00000006;
const int WAITING								= 0x00000007;
const int ILLEGAL_MOVE					= 0x00000008;
const int NO_MOVE_WHILE_REVIEW	= 0x00000009;
const int LOAD_OK								= 0x00000010;
const int SAVE_OK								= 0x00000011;
const int PAUSED								= 0x00000012;
const int READING_FILE					= 0x00000013;
const int WHITE_DRAW_OFFER			= 0x00000014;
const int BLACK_DRAW_OFFER			= 0x00000015;
const int LOAD_ERROR						= 0x00000020;
const int SAVE_ERROR						= 0x00000021;
const int BOOK_ERROR_1					= 0x00000022;
const int BOOK_ERROR_2					= 0x00000023;
const int BOOK_ERROR_3					= 0x00000024;
const int BOOK_ERROR_4					= 0x00000025;
const int ENGINE_DIED_ERROR			= 0x00000026;
const int WHITE_RESIGN					= 0x00000027;
const int BLACK_RESIGN					= 0x00000028;
const int WHITE_FLAG						= 0x00000029;
const int BLACK_FLAG						= 0x00000030;
const int WHITE_CALL_FLAG				= 0x00000031;
const int BLACK_CALL_FLAG				= 0x00000032;
const int WHITE_CHECKMATE				= 0x00000033;
const int BLACK_CHECKMATE				= 0x00000034;
const int LOST_CONTACT					= 0x00000035;
const int COMMENT								= 0x00010000;
const int ERROR									= 0x00100000;

		/* Variations */
/*
			These define the variations on chess
			that can be supported.
*/

const int Type_Standard					= 0x00000001;
const int Type_WildCastle				= 0x00000002;
const int Type_NoCastle					= 0x00000004;
const int Type_FischerRandom		= 0x00000008;
const int Type_BugHouse					= 0x00000010;
const int Type_CrazyHouse				= 0x00000020;
const int Type_Losers						= 0x00000040;
const int Type_Suicide					= 0x00000080;
const int Type_Giveaway					= 0x00000100;
const int Type_TwoKings					= 0x00000200;
const int Type_Atomic						= 0x00000400;
const int Type_Kriegspiel				= 0x00000800;
const int Type_ThreeCheck				= 0x00001000;

		/* Protocols */

const int XBoard								= 0x02;
const int UCI										= 0x04;

		/* Events */

/*
		These constants represent TQEvent types.
*/

const int EVENT_Del_IO_Net			= 0x000003e9;


		/* Position Notes */
		
/*
		These represent the various NOTES that can appear on a
		given position
*/

const char NOTE_NONE						= 0x00;
const char NOTE_HIGHLIGHT				= 0x01;
const char NOTE_SELECT					= 0x02;
const char NOTE_MOVE						= 0x10;
const char NOTE_CASTLE					= 0x11;
const char NOTE_PAWN_DOUBLE			= 0x12;
const char NOTE_ATTACK					= 0x20;
const char NOTE_ENPASSANT				= 0x21;

		/* Chessmen */

/*
		These represent the various chessmen, or Types of chessmen
		found on the playing board.
*/
const char Null									= -1;
const char King									= 0;
const char Queen								= 1;
const char Bishop								= 2;
const char Knight								= 3;
const char Rook									= 4;
const char Pawn									= 5;

		/* ICS Game Modes */

const char ICS_Normal						= 0;
const char ICS_Examine					= 1;
const char ICS_Observe					= 2;
const char ICS_Movelist					= 3;

struct ThemeHeader
{
	TQString				name;
	TQString				version;
	TQString				author;
	TQString				authorEmail;
	TQString				authorWWW;
	TQString				notes;
};

struct ChessMove
{
					char	fromFile;
					char	fromRank;
					char	toFile;
					char	toRank;
					char	Promote;
					char	ManTaken;
					char	SAN[8];
					char	CAN[6];
unsigned	char	NAG;
					/* Following used for ICS Only */
					char	ICS_Mode;
					char	ICS_PawnPushFile;
					int		ICS_MoveCounter;
					bool	ICS_OnMove;
					bool	ICS_ClockTicking;
};

struct Chessman
{
	bool Army;
	char Type;
	char File;
	char Rank;
};

struct Position
{
	char File;
	char Rank;
	char ManPtr;
	char Note;
};

/* Time Control Period */
struct TCP
{
	int		Moves;
	int		Seconds;
	int		Increment;
};

typedef TQValueList<TCP> TCPList;

#endif
