//
// C++ Implementation:
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//


#include "kmfipv4addresswidget.h"

// TQt includes
#include <tqlistview.h>
#include <tqcheckbox.h>
#include <tqspinbox.h>
#include <tqcombobox.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqgroupbox.h>
#include <tqwidgetstack.h>
#include <tqtextedit.h>
#include <tqtimer.h>


// KDE includes
#include <kdebug.h>
#include <tdelocale.h>
#include <tdelistview.h>
#include <kcombobox.h>
#include <tdepopupmenu.h>
#include <kiconloader.h>
#include <kinputdialog.h>
#include <knuminput.h>

// Project includes
#include "../core/ipaddress.h"
namespace KMF {
KMFIPv4AddressWidget::KMFIPv4AddressWidget ( TQWidget* parent, const char* name, WFlags fl )
		: KMyFirewallIPv4AdddressWidget ( parent,name,fl ) {
		
//	m_address = new IPAddress( 0,0,0,0 );	
	connect( m_sb_from_1, TQ_SIGNAL( valueChanged( const TQString& ) ),
		this, TQ_SLOT( slotAddressChanged( const TQString& ) ) );
	connect( m_sb_from_2, TQ_SIGNAL( valueChanged( const TQString& ) ),
		this, TQ_SLOT( slotAddressChanged( const TQString& ) ) );
	connect( m_sb_from_3, TQ_SIGNAL( valueChanged( const TQString& ) ),
		this, TQ_SLOT( slotAddressChanged( const TQString& ) ) );
	connect( m_sb_from_4, TQ_SIGNAL( valueChanged( const TQString& ) ),
		this, TQ_SLOT( slotAddressChanged( const TQString& ) ) );		
}

KMFIPv4AddressWidget::~KMFIPv4AddressWidget() {}

/*$SPECIALIZATION$*/

void KMFIPv4AddressWidget::loadIPAddress( int d0, int d1, int d2, int d3 ) {
	kdDebug() << "KMFIPv4AddressWidget::loadIPAddress( " 
		<< d0 << "." 
		<< d1 << "." 
		<< d2 << "."
		<< d3 << " )" << endl;
	
	
	
	m_sb_from_1->blockSignals( true );
	m_sb_from_2->blockSignals( true );
	m_sb_from_3->blockSignals( true );
	m_sb_from_4->blockSignals( true );
	
	m_sb_from_1->setValue( d0 );
	m_sb_from_2->setValue( d1 );
	m_sb_from_3->setValue( d2 );
	m_sb_from_4->setValue( d3 );

	m_sb_from_1->blockSignals( false );
	m_sb_from_2->blockSignals( false );
	m_sb_from_3->blockSignals( false );
	m_sb_from_4->blockSignals( false );
	
	m_sb_from_1->setEnabled( true );
	m_sb_from_2->setEnabled( true );
	m_sb_from_3->setEnabled( true );
	m_sb_from_4->setEnabled( true );
	
	// m_address->setAddress( d0, d1, d2, d3 );
}

void KMFIPv4AddressWidget::slotAddressChanged( const TQString& ) {
	kdDebug() << "KMFIPv4AddressWidget::slotAddressChanged( const TQString& )" << endl;
	/*
	if ( ! m_address ) {
		return;
	}
	
	const TQString& newAddr =  m_sb_from_1->text() +"."+
														m_sb_from_2->text() +"."+
														m_sb_from_3->text() +"."+
														m_sb_from_4->text();
	if ( m_address->toString() == newAddr ) {
		return;
	}*/
	
	emit sigAddressChanged( 
		m_sb_from_1->value(),
		m_sb_from_2->value(), 
		m_sb_from_3->value(), 
		m_sb_from_4->value() );
}

}

#include "kmfipv4addresswidget.moc"

