/***************************************************************************
 *   Copyright (C) 2005 by Lorenzo Bettini                                 *
 *   http://www.lorenzobettini.it                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <tqlcdnumber.h>
#include <tdeglobal.h>
#include <tdelocale.h>
#include <tdeconfigdialog.h>
#include <tdeapplication.h>
#include <tdemessagebox.h>
#include <tdepopupmenu.h>
#include <kdatetbl.h> // for TDEPopupFrame
#include <kiconloader.h>
#include <tdeaboutapplication.h>
#include <tqlabel.h>
#include <tqframe.h>
#include <kdebug.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "klcddimmer.h"
#include "brightnesschooserimpl.h"
#include "progpreferences.h"
#include "preferences.h"
#include "klcddimmerapplet.h"


klcddimmer::klcddimmer(const TQString& configFile, Type type, int actions, TQWidget *parent, const char *name)
    : KPanelApplet(configFile, type, actions, parent, name),
        mBrightnessChooserFrame(0)
{
    // Get the current application configuration handle
    ksConfig = config();

    /*
    TQLCDNumber *w = new TQLCDNumber(this);
    w->display(42);
    */

    // this is the popup windows that is shown when the left button is pressed
    mBrightnessChooserFrame = new TDEPopupFrame(this);
    //mBrightnessChooserFrame = new TQWidget
    //        (this, "klcddimmer popup", WStyle_Customize | WType_Popup | TQt::WStyle_DialogBorder);
    chooser = new BrightnessChooserImpl(mBrightnessChooserFrame);
    mBrightnessChooserFrame->setMainWidget(chooser);
    mBrightnessChooserFrame->resize(chooser->size());

    connect(chooser, TQ_SIGNAL(valueUpdated()), this, TQ_SLOT(valueUpdate()));

    initContextMenu();

    /*
    TQFrame *w = new TQFrame(this);
    valueLabel = new TQLabel(w);
    valueLabel->setText(chooser->getValue());
    */

    klcddimmerView = new KlcdDimmerApplet(this);
    mainView = klcddimmerView;

    // klcddimmerView->brightnessIcon->setPixmap(SmallIcon("klcddimmer"));
    klcddimmerView->setBrightnessLevel(chooser->getValue());
    //klcddimmerView->resize( TQSize(122, 48).expandedTo(minimumSizeHint()) );

    mainView->show();

    /* get the current value */
    chooser->getBrightness();
}


klcddimmer::~klcddimmer()
{
}


void klcddimmer::about()
{
    //KMessageBox::information(0, i18n("This is an about box"));

    TDEAboutData aboutData("KLcdDimmer", "KLcdDimmer", VERSION,
        I18N_NOOP("Applet for LCD brightness adjustment"), TDEAboutData::License_GPL_V2);
    aboutData.addAuthor("Lorenzo Bettini", "main author", "",
                        "http://www.lorenzobettini.it");
    aboutData.setHomepage("http://klcddimmer.sourceforge.net");
    aboutData.setCustomAuthorText("please use http://sourceforge.net/projects/klcddimmer to report bugs",
                                 "please use <a href=http://sourceforge.net/projects/klcddimmer>http://sourceforge.net/projects/klcddimmer</a> to report bugs");
    TDEAboutApplication about(&aboutData, this, 0);
    about.setProgramLogo( TDEGlobal::instance()->iconLoader()->iconPath( "klcddimmer", -TDEIcon::SizeLarge ) );
    about.exec();
}


void klcddimmer::help()
{
    KMessageBox::information(0, i18n("This is a help box"));
}


void klcddimmer::preferences()
{
    TDEConfigDialog dialog( this, "settings", Preferences::self() );

    ProgPreferences *preferences = new ProgPreferences(0, "Program");
    dialog.addPage(preferences, i18n("Program"), "wizard");

    if (dialog.exec())
    {
        chooser->updateSlider();
    }
}

/*
int klcddimmer::widthForHeight(int height) const
{
    return klcddimmerView->width();
}

int klcddimmer::heightForWidth(int width) const
{
    return klcddimmerView->height();
}
*/

int klcddimmer::widthForHeight( int height ) const
{
  // kdDebug() << "icon sizeHint: " << klcddimmerView->brightnessIcon->sizeHint() << endl;
  // kdDebug() << "text sizeHint: " << klcddimmerView->brightnessLevel->sizeHint() << endl;

  return height;
}

int klcddimmer::heightForWidth( int width ) const
{
  // kdDebug() << "icon sizeHint: " << klcddimmerView->brightnessIcon->sizeHint() << endl;
  // kdDebug() << "text sizeHint: " << klcddimmerView->brightnessLevel->sizeHint() << endl;

  return width;
}


void klcddimmer::resizeEvent(TQResizeEvent *e)
{
   klcddimmerView->resize(this->width(),this->height());
}

void klcddimmer::initContextMenu()
{
  mContextMenu = new TDEPopupMenu(this);
  //mContextMenu->insertItem(SmallIcon("reload"), i18n("&Update Now"),
  //                         this, TQ_SLOT(slotUpdateNow()), 0, -1, 2);
  mContextMenu->insertSeparator();
  mContextMenu->insertItem(SmallIcon("klcddimmer"), i18n("&About KLcdDimmer"), this, TQ_SLOT(about()));
  mContextMenu->insertItem(SmallIcon("configure"),
                           i18n("&Configure KLcdDimmer..."), this, TQ_SLOT(preferences()));
  setCustomMenu(mContextMenu);
}

void klcddimmer::mousePressEvent(TQMouseEvent *e)
{
    if ( e->button() == LeftButton )
    {
        if (!mBrightnessChooserFrame->isShown()) {
            mBrightnessChooserFrame->popup(e->globalPos());
        }
    }
    else if ( e->button() != RightButton )
    {
        KPanelApplet::mousePressEvent( e );
        return;
    }
    else // must be right button
    {
        mContextMenu->exec(e->globalPos());
    }
}

void klcddimmer::valueUpdate()
{
    kdDebug() << "updated value: " << chooser->getValue() << endl;
    klcddimmerView->setBrightnessLevel(chooser->getValue());
}

extern "C"
{
    TDE_EXPORT KPanelApplet* init( TQWidget *parent, const TQString& configFile)
    {
        TDEGlobal::locale()->insertCatalogue("klcddimmer");
        return new klcddimmer(configFile, KPanelApplet::Normal,
                             KPanelApplet::About | KPanelApplet::Help | KPanelApplet::Preferences,
                             parent, "klcddimmer");
    }
}

#include "klcddimmer.moc"
