/***************************************************************************
*   Copyright (C) 2005 by Alexander Nemish  *
*   atlanter@gmail.com   *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#include <tqstring.h>
#include <tqpixmap.h>
#include <tqimage.h>
#include <tdeglobal.h>
#include <kstandarddirs.h>
#include "theme.h"

Theme* Theme::theme = 0;

Theme::Theme()
{}


Theme * Theme::self()
{
	if ( !theme )
		theme = new Theme();
	return theme;
}

void Theme::loadTheme(const TQString& name)
{
	const TQString themePath = "themes/" + name; //FIXME: Add 'name' check. Could be a hole.
	TQString bgPath = TDEGlobal::dirs()->findResource("appdata", themePath + "/bg.png");
	TQString bookmarkPath = TDEGlobal::dirs()->findResource("appdata", themePath + "/bookmark.png");
	m_bgPixmap = TQPixmap(bgPath);
	m_bgResizedPixmap = m_bgPixmap;
	m_bookmarkPixmap = TQPixmap(bookmarkPath);
}

const TQPixmap & Theme::bgPixmap(TQSize size) const
{
	if (size == TQSize(0, 0) || size == m_bgPixmap.size())
		return m_bgPixmap;
	if (size == m_bgResizedPixmap.size())
		return m_bgResizedPixmap;
	m_bgResizedPixmap = m_bgPixmap;
	m_bgResizedPixmap.convertFromImage(m_bgResizedPixmap.convertToImage().scale(size));
	return m_bgResizedPixmap;
}
