/***************************************************************************
 *   Copyright (C) 2004-2009 by Thomas Fischer                             *
 *   fischer@unix-ag.uni-kl.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <tqapplication.h>
#include <tqfile.h>
#include <tqstring.h>
#include <tqspinbox.h>

#include <klineedit.h>
#include <tdelocale.h>
#include <tdemessagebox.h>
#include <tdeio/netaccess.h>
#include <kurl.h>

#include "settings.h"
#include "fileimporterbibtex.h"
#include "webquerycitebase.h"

namespace KBibTeX
{
    WebQueryCitebaseWidget::WebQueryCitebaseWidget( TQWidget *parent, const char *name )
            : WebQueryWidget( parent, name )
    {
        init();

        Settings *settings = Settings::self();
        TQString value = settings->getWebQueryDefault( "Citebase" );
        value = value == TQString::null ? "" : value;
        lineEditQuery->setText( value );
        slotTextChanged( value, true );
    }


    WebQueryCitebase::WebQueryCitebase( TQWidget* parent ): WebQuery( parent )
    {
        m_widget = new WebQueryCitebaseWidget( parent );
    }

    WebQueryCitebase::~WebQueryCitebase()
    {
        delete m_widget;
    }

    TQString WebQueryCitebase::title()
    {
        return i18n( "Citebase" );
    }

    TQString WebQueryCitebase::disclaimer()
    {
        return i18n( "Citebase citation index" );
    }

    TQString WebQueryCitebase::disclaimerURL()
    {
        return "http://www.citebase.org/";
    }

    WebQueryWidget *WebQueryCitebase::widget()
    {
        return m_widget;
    }

    void WebQueryCitebase::query()
    {
        WebQuery::query();
        Settings *settings = Settings::self();
        settings->setWebQueryDefault( "Citebase", m_widget->lineEditQuery->text() );

        setNumStages( 1 );
        int numberOfResults = m_widget->spinBoxMaxHits->value();

        TQString searchTerm = m_widget->lineEditQuery->text().stripWhiteSpace().replace( '$', "" );
        if ( searchTerm.isEmpty() )
        {
            setEndSearch( WebQuery::statusInvalidQuery );
            return;
        }

        KURL url = KURL( TQString( "http://www.citebase.org/search?submitted=Search&author=&maxrows=%1&yearfrom=&format=BibTeX&order=DESC&type=metadata&title=%2&publication=&yearuntil=&rank=paperimpact" ).arg( numberOfResults ).arg( searchTerm.replace( "%", "%25" ).replace( "+", "%2B" ).replace( " ", "%20" ).replace( "#", "%23" ).replace( "&", "%26" ).replace( "?", "%3F" ) ) );
        BibTeX::File *tmpBibFile = downloadBibTeXFile( url );
        if ( tmpBibFile != NULL && !m_aborted )
        {
            int count = numberOfResults;
            for ( BibTeX::File::ElementList::iterator it = tmpBibFile->begin(); count > 0 && it != tmpBibFile->end(); ++it )
            {
                BibTeX::Entry *entry = dynamic_cast<BibTeX::Entry*>( *it );
                if ( entry != NULL )
                {
                    emit foundEntry( new BibTeX::Entry( entry ), false );
                    --count;
                }
            }

            setEndSearch( WebQuery::statusSuccess );
        }
        else if ( !m_aborted )
        {
            TQString message = TDEIO::NetAccess::lastErrorString();
            if ( message.isEmpty() )
                message.prepend( '\n' );
            message.prepend( TQString( i18n( "Querying database '%1' failed." ) ).arg( title() ) );
            KMessageBox::error( m_parent, message );
            setEndSearch( WebQuery::statusError );
        }
        else
            setEndSearch( WebQuery::statusAborted );

        if ( tmpBibFile != NULL )
            delete tmpBibFile;
    }
}
#include "webquerycitebase.moc"
