###########################################
#                                         #
#  Improvements and feedback are welcome  #
#                                         #
#  This file is released under GPL >= 3   #
#                                         #
###########################################

# required stuff
find_package( TQt )
find_package( TDE )

tde_setup_compiler_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )


##### check for gcc visibility support

if( WITH_GCC_VISIBILITY )
    tde_setup_gcc_visibility( )
endif( WITH_GCC_VISIBILITY )


##### check for libxml-2.0

find_package( LibXml2 )
if( NOT LIBXML2_FOUND )
    tde_message_fatal( "libxml-2.0 is required, but was not found on your system" )
endif( NOT LIBXML2_FOUND )


##### check for libxslt

find_package( LibXslt )
if( NOT LIBXSLT_FOUND )
    tde_message_fatal( "libxslt is required, but was not found on your system" )
endif( NOT LIBXSLT_FOUND )


##### check for libyaz

pkg_search_module( LIBYAZ libyaz yaz )
if( LIBYAZ_FOUND )
    set( HAVE_YAZ 1 )
 else()
    tde_message_fatal( "libyaz is required, but was not found on your system" )
endif( )


##### check for libiconv

message( STATUS "Check for standalone libiconv" )
find_library( HAVE_LIBICONV iconv )
if( HAVE_LIBICONV )
  set( ICONV_LIBRARIES iconv )
  message( STATUS "Check for standalone libiconv - found" )
else( )
  set( ICONV_LIBRARIES "" )
  message( STATUS "Check for standalone libiconv - not found" )
endif( )
