/***************************************************************************
*   Copyright (C) 2004-2006 by Thomas Fischer                             *
*   fischer@unix-ag.uni-kl.de                                             *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#ifndef SETTINGSEDITING_H
#define SETTINGSEDITING_H

#include <tqwidget.h>

class TQCheckBox;
class TQPushButton;
class TQComboBox;
class TQSlider;

class KPushButton;
class KURLRequester;
class TDEListView;

namespace KBibTeX
{
    class SettingsEditingPaths: public TQWidget
    {
        TQ_OBJECT
    protected:
        SettingsEditingPaths( TQStringList& pathList, TQWidget*parent = 0, const char *name = 0 );

    public:
        static bool execute( TQWidget *parent, TQStringList &pathList );

    public slots:
        void slotApply();
        void slotTextChanged( const TQString&text );
        void slotAddDir();
        void slotSelectionChanged();
        void slotDelDir();

    private:
        TQStringList &m_pathList;
        KURLRequester *m_urlRequesterNewPath;
        KPushButton *m_pushButtonAddDir;
        TDEListView *m_listViewPathList;
        KPushButton *m_pushButtonDelDir;
    };

    class SettingsEditing : public TQWidget
    {
        TQ_OBJECT
    public:
        SettingsEditing( TQWidget *parent = 0, const char *name = 0 );
        ~SettingsEditing();

        void applyData();
        void readData();

    signals:
        void configChanged();

    protected slots:
        void slotConfigChanged();
        void slotSelectSpecialFont();
        void slotSelectDocumentSearchPath();

    private:
        TQCheckBox *m_checkBoxEnableAllFields;
        TQCheckBox *m_checkBoxSearchBarClearField;
        TQComboBox *m_comboBoxSortingColumn;
        TQComboBox *m_comboBoxSortingOrder;
        TQComboBox *m_comboBoxDoubleClickAction;
        TQComboBox *m_comboBoxDragAction;
        TQCheckBox *m_checkBoxUseSpecialFont;
        TQPushButton *m_pushButtonSpecialFont;
        TQFont m_specialFont;
        TQComboBox *m_comboBoxNameOrder;
        TQStringList m_documentSearchPaths;
        static const TQChar pathListSeparator;
        TQSlider *m_sliderBarFindDuplicatesSensitivity;

        void updateFontData();
        bool editPathList( TQStringList &pathList );

        const int m_findDuplicatesSensitivityMin, m_findDuplicatesSensitivityMax;
    };
}

#endif // SETTINGSEDITING_H
