/***************************************************************************
                          labelutils.h  -  description
                             -------------------
    begin                : Sam Okt 26 2002
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LABELUTILS_H
#define LABELUTILS_H

class Definition;
class KPrinter;
class TQDomElement;
class TQFont;
class TQImage;
class TQPainter;
class TQPixmap;
class TQPaintDevice;
class TQPoint;
class TQRect;
class TQSize;
class TQString;
class TQStringList;
class TQSqlQuery;
class LabelUtils {
    public:
        LabelUtils();
        ~LabelUtils();

        enum _dpixy {
            DpiX,
            DpiY
        };

        double pixelToMm( double pixel, const TQPaintDevice* device, int mode = DpiX );
        double mmToPixel( double mm, const TQPaintDevice* device, int mode = DpiX );

        double pixelToPixelX( double unit, const TQPaintDevice* src, const TQPaintDevice* dest );
        double pixelToPixelY( double unit, const TQPaintDevice* src, const TQPaintDevice* dest );
        static TQSize stringSize( const TQString & t );
        static TQPixmap* drawString( const TQString & t, int w, int h, double rot = 0 );
        static TQPixmap* drawString( const TQString & t ) {
            return LabelUtils::drawString( t, 0, 0, 0 );
        }

        const TQString getTypeFromCaption( const TQString & cap );
        const TQString getModeFromCaption( const TQString & cap );
};

#endif
