// (C) 2005 Max Howell (max.howell@methylblue.com)
// See COPYING file for licensing information

#ifndef XINECONFIG_H
#define XINECONFIG_H

#include <kdialogbase.h>
#include <tqptrlist.h>

class KComboBox;
class KLineEdit;
class TQCheckBox;
class TQGridLayout;
class TQSpinBox;

typedef struct xine_s xine_t;
typedef struct xine_cfg_entry_s xine_cfg_entry_t;


///stores a single config entry of the config file

class XineConfigEntry : public TQObject
{
   enum ClassType { LineEdit, ComboBox, SpinBox, CheckBox };

   TQWidget *m_widget;
   TQCString m_key;
   TQCString m_string;
   int      m_number;

   static inline ClassType classType( const TQCString &name )
   {
      return name == "KLineEdit" ? LineEdit
           : name == "KComboBox" ? ComboBox
           : name == "TQSpinBox" ? SpinBox : CheckBox;
   }

public:
   XineConfigEntry( TQWidget *parent, TQGridLayout*, xine_cfg_entry_t* );

   bool isChanged() const;
   void save( xine_t* );
   void reset();

   inline const TQCString &key() const { return m_key; }
};


class XineConfigDialog : public KDialogBase
{
   static KDialogBase *s_instance;

   TQPtrList<XineConfigEntry> m_entrys;
   xine_t *m_xine;

public:
   XineConfigDialog( xine_t *xine, TQWidget *parent );

   bool isUnsavedSettings() const;
   void saveSettings();

   static KDialogBase *instance() { return s_instance; }

protected:
   virtual void slotUser1();
   virtual void slotHelp();
};

#endif
