###########################################
#                                         #
#  Improvements and feedback are welcome  #
#                                         #
#  This file is released under GPL >= 3   #
#                                         #
###########################################

# required stuff
find_package( TQt )
find_package( TDE )

tde_setup_architecture_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )


##### check for gcc visibility support

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( WITH_GCC_VISIBILITY )


##### check for sword library

pkg_search_module( SWORD sword>=1.7 )
if( NOT SWORD_FOUND )
  tde_message_fatal( "sword library is required but not found on your system" )
endif()

check_cxx_source_compiles("
  #include <signal.h>
  #include <${SWORD_INCLUDE_DIRS}/sysdata.h>
  int main() {}
  "
  SWORD_WITHOUT_SANE_USERSPACE_TYPES
)
if( NOT SWORD_WITHOUT_SANE_USERSPACE_TYPES )
  check_cxx_source_compiles("
    #define __SANE_USERSPACE_TYPES__
    #include <signal.h>
    #include <${SWORD_INCLUDE_DIRS}/sysdata.h>
    int main() {}
    "
    SWORD_WITH_SANE_USERSPACE_TYPES
  )
  if( NOT SWORD_WITH_SANE_USERSPACE_TYPES )
    tde_message_fatal( "sword library cannot be used in any way" )
  endif()
  add_definitions( "-D__SANE_USERSPACE_TYPES__" )
endif()


##### check for clucdene library

pkg_search_module( CLUCENE libclucene-core )
if( NOT CLUCENE_FOUND )
  tde_message_fatal( "clucene library is required but not found on your system" )
endif()
if( NOT CLUCENE_VERSION VERSION_LESS "2.0" )
  set( CLUCENE_V2 1 )
  tde_save_and_set( CMAKE_REQUIRED_INCLUDES "${CLUCENE_INCLUDE_DIRS}" )
  tde_save_and_set( CMAKE_REQUIRED_LIBRARIES "${CLUCENE_LIBRARIES}" )
  check_cxx_source_compiles("
    #include <CLucene.h>

    extern size_t lucene_wcstoutf8 (char *,  const wchar_t *, size_t maxslen);

    int main()
    {
      lucene_wcstoutf8(NULL, NULL, 0);
    }
    "
    BUILD_WITH_CLUCENE_CORE
  )
  if( NOT BUILD_WITH_CLUCENE_CORE )
    set( CMAKE_REQUIRED_LIBRARIES "${CLUCENE_LIBRARIES};clucene-shared" )
    check_cxx_source_compiles("
      #include <CLucene.h>

      extern size_t lucene_wcstoutf8 (char *,  const wchar_t *, size_t maxslen);

      int main()
      {
        lucene_wcstoutf8(NULL, NULL, 0);
      }
      "
      BUILD_WITH_CLUCENE_SHARED
    )
    if( NOT BUILD_WITH_CLUCENE_SHARED )
      tde_message_fatal( "clucene library was found, but building with clucene is not successful" )
    else()
      set( CLUCENE_LIBRARIES "${CLUCENE_LIBRARIES};clucene-shared" CACHE INTERNAL "clucene libraries" FORCE )
    endif()
  endif()
  tde_restore( CMAKE_REQUIRED_INCLUDES )
  tde_restore( CMAKE_REQUIRED_LIBRARIES )
endif()


##### check for boost library

find_package( Boost )

if( NOT Boost_FOUND )
    tde_message_fatal( "Boost is required, but was not found on your system" )
endif()
