############################################
#                                          #
#  Improvements and feedbacks are welcome  #
#                                          #
#  This file is released under GPL >= 3    #
#                                          #
############################################


# required stuff
find_package( TQt )
find_package( TDE )

tde_setup_architecture_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )


##### check for gcc visibility support

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( WITH_GCC_VISIBILITY )


##### check for the file program

find_program( FILE_EXECUTABLE file )

if( NOT FILE_EXECUTABLE )
    tde_message_fatal( "the program 'file' is required to build basket, but was not found on your system" )
endif()


##### check for X11

find_package( X11 )


##### check for gpgme

if( WITH_GPGME )
pkg_search_module( GPGME gpgme )

if( NOT GPGME_FOUND )
    find_program( GPGME_CONFIG_EXECUTABLE gpgme-config )
    if( NOT GPGME_CONFIG_EXECUTABLE )
        tde_message_fatal( "Gpgme library is required but not found on your system" )
    endif()

    execute_process(
        COMMAND ${GPGME_CONFIG_EXECUTABLE} --libs
        OUTPUT_VARIABLE GPGME_LIBRARIES
        ERROR_VARIABLE  GPGME_LIBRARIES
        OUTPUT_STRIP_TRAILING_WHITESPACE
        ERROR_STRIP_TRAILING_WHITESPACE
    )
    execute_process(
        COMMAND ${GPGME_CONFIG_EXECUTABLE} --cflags
        OUTPUT_VARIABLE GPGME_CFLAGS
        ERROR_VARIABLE  GPGME_CFLAGS
        OUTPUT_STRIP_TRAILING_WHITESPACE
        ERROR_STRIP_TRAILING_WHITESPACE
    )
    string( REGEX MATCHALL "-I([^ ]*)" GPGME_INCLUDE_FLAGS "${GPGME_CFLAGS}" )
    string( REGEX REPLACE "-I" "" GPGME_INCLUDE_DIRS "${GPGME_INCLUDE_FLAGS}" )
    set( GPGME_INCLUDE_DIRS "${GPGME_INCLUDE_DIRS}" CACHE INTERNAL "" )
    set( GPGME_LIBRARIES "${GPGME_LIBRARIES}" CACHE INTERNAL "" )
    set( HAVE_LIBGPGME 1 )
 else()
    set( HAVE_LIBGPGME 1 )
endif( NOT GPGME_FOUND )
endif( WITH_GPGME )


##### check for aRts

if( WITH_ARTS )
    pkg_search_module( ARTS  arts  )
    pkg_search_module( ARTSC artsc )
    find_library( ARTSKDE artskde )

    if( ARTSKDE )
        set( ARTSKDE_LIBRARIES artskde-shared )
    endif()

   if( (NOT ARTS_FOUND) OR (NOT ARTSKDE) )
       tde_message_fatal( "aRts support has been requested but was not found on your system." )
    else()
       set( WITH_ARTS 1 )
   endif()
endif( WITH_ARTS )


##### check for libart-lgpl

if ( WITH_LIBART )
pkg_search_module( LIBART libart libart_lgpl libart-2.0 )

if( NOT LIBART_FOUND )
    tde_message_fatal( "Libart support has been requested but was not found on your system." )
 else()
    set( HAVE_LIBART 1 )
endif()
endif( WITH_LIBART )


##### check for kontact

if( BUILD_KONTACT_PLUGIN )
find_file( HAVE_KONTACT_HEADER "kontact/core.h" )

if( NOT HAVE_KONTACT_HEADER )
    tde_message_fatal( "kontact plugin support has been requested but kontact headers were not found on your system." )
endif()
endif( BUILD_KONTACT_PLUGIN )
