/*
  (c) 2005 Alexandre Oliveira <aleprj@gmail.com>
  (c) 2003 Frerich Raabe <raabe@kde.org>

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** TQt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/

#include "tagguesser.h"

#include <tqevent.h>

#include <tdeapplication.h>
#include <klineedit.h>
#include <kiconloader.h>


void TagGuesserConfigDialog::init()
{
    setCaption( i18n( "Guess By Filename Configuration" ) );
    lvSchemes->setItemsRenameable( true );
    lvSchemes->setSorting( -1 );
    lvSchemes->setDefaultRenameAction( TQListView::Accept );
    bMoveUp->setIconSet( SmallIconSet( "1uparrow" ) );
    bMoveDown->setIconSet( SmallIconSet( "1downarrow" ) );

    const TQStringList schemes = TagGuesser::schemeStrings();
    TQStringList::ConstIterator it = schemes.begin();
    TQStringList::ConstIterator end = schemes.end();
    for ( ; it != end; ++it ) {
        TDEListViewItem *item = new TDEListViewItem( lvSchemes, *it );
        item->moveItem( lvSchemes->lastItem() );
    }

    connect( lvSchemes, TQ_SIGNAL( currentChanged( TQListViewItem * ) ),
            this, TQ_SLOT( slotCurrentChanged( TQListViewItem * ) ) );
    connect( lvSchemes, TQ_SIGNAL( doubleClicked( TQListViewItem *, const TQPoint &, int ) ),
            this, TQ_SLOT( slotRenameItem( TQListViewItem *, const TQPoint &, int ) ) );
    connect( bMoveUp, TQ_SIGNAL( clicked() ), this, TQ_SLOT( slotMoveUpClicked() ) );
    connect( bMoveDown, TQ_SIGNAL( clicked() ), this, TQ_SLOT( slotMoveDownClicked() ) );
    connect( bAdd, TQ_SIGNAL( clicked() ), this, TQ_SLOT( slotAddClicked() ) );
    connect( bModify, TQ_SIGNAL( clicked() ), this, TQ_SLOT( slotModifyClicked() ) );
    connect( bRemove, TQ_SIGNAL( clicked() ), this, TQ_SLOT( slotRemoveClicked() ) );
    connect( bOk, TQ_SIGNAL( clicked() ), this, TQ_SLOT( accept() ) );
    connect( bCancel, TQ_SIGNAL( clicked() ), this, TQ_SLOT( reject() ) );

    lvSchemes->setSelected( lvSchemes->firstChild(), true );
    slotCurrentChanged( lvSchemes->currentItem() );
    resize( 400, 300 );
}

void TagGuesserConfigDialog::slotCurrentChanged(TQListViewItem *item)
{
    bMoveUp->setEnabled( item != 0 && item->itemAbove() != 0 );
    bMoveDown->setEnabled( item != 0 && item->itemBelow() != 0 );
    bModify->setEnabled( item != 0 );
    bRemove->setEnabled( item != 0 );
}

void TagGuesserConfigDialog::accept()
{
    if(lvSchemes->renameLineEdit()) {
        TQKeyEvent returnKeyPress(TQEvent::KeyPress, Key_Return, 0, 0);
        TDEApplication::sendEvent( lvSchemes->renameLineEdit(), &returnKeyPress );
    }

    TQStringList schemes;
    for ( TQListViewItem *it = lvSchemes->firstChild(); it; it = it->nextSibling() )
        schemes += it->text(0);
    TagGuesser::setSchemeStrings( schemes );
    KDialog::accept();
}


void TagGuesserConfigDialog::reject()
{
    KDialog::reject();
}


void TagGuesserConfigDialog::slotRenameItem(TQListViewItem *item, const TQPoint &, int c)
{
    lvSchemes->rename(item, c);
}

void TagGuesserConfigDialog::slotMoveUpClicked()
{
    TQListViewItem *item = lvSchemes->currentItem();
    if( item->itemAbove() == lvSchemes->firstChild() )
        item->itemAbove()->moveItem(item);
    else
      item->moveItem(item->itemAbove()->itemAbove());
    lvSchemes->ensureItemVisible(item);
    slotCurrentChanged(item);
}

void TagGuesserConfigDialog::slotMoveDownClicked()
{
    TQListViewItem *item = lvSchemes->currentItem();
    item->moveItem( item->itemBelow() );
    lvSchemes->ensureItemVisible(item);
    slotCurrentChanged(item);
}

void TagGuesserConfigDialog::slotAddClicked()
{
    TDEListViewItem *item = new TDEListViewItem( lvSchemes );
    lvSchemes->rename(item, 0);
}

void TagGuesserConfigDialog::slotModifyClicked()
{
    lvSchemes->rename(lvSchemes->currentItem(), 0);
}

void TagGuesserConfigDialog::slotRemoveClicked()
{
    delete lvSchemes->currentItem();
}
