/* this file was generated by the MCOP idl compiler - DO NOT EDIT */

#include "artsmidi.h"

// Implementation
Arts::TimeStamp::TimeStamp()
{
}

Arts::TimeStamp::TimeStamp(long _a_sec, long _a_usec)
{
	this->sec = _a_sec;
	this->usec = _a_usec;
}

Arts::TimeStamp::TimeStamp(Arts::Buffer& stream)
{
	readType(stream);
}

Arts::TimeStamp::TimeStamp(const Arts::TimeStamp& copyType) : Arts::Type(copyType)
{
	Arts::Buffer buffer;
	copyType.writeType(buffer);
	readType(buffer);
}

Arts::TimeStamp& Arts::TimeStamp::operator=(const Arts::TimeStamp& assignType)
{
	Arts::Buffer buffer;
	assignType.writeType(buffer);
	readType(buffer);
	return *this;
}

void Arts::TimeStamp::readType(Arts::Buffer& stream)
{
	sec = stream.readLong();
	usec = stream.readLong();
}

void Arts::TimeStamp::writeType(Arts::Buffer& stream) const
{
	stream.writeLong(sec);
	stream.writeLong(usec);
}

std::string Arts::TimeStamp::_typeName() const
{
	return "Arts::TimeStamp";
}

Arts::MidiCommand::MidiCommand()
{
}

Arts::MidiCommand::MidiCommand(Arts::mcopbyte _a_status, Arts::mcopbyte _a_data1, Arts::mcopbyte _a_data2)
{
	this->status = _a_status;
	this->data1 = _a_data1;
	this->data2 = _a_data2;
}

Arts::MidiCommand::MidiCommand(Arts::Buffer& stream)
{
	readType(stream);
}

Arts::MidiCommand::MidiCommand(const Arts::MidiCommand& copyType) : Arts::Type(copyType)
{
	Arts::Buffer buffer;
	copyType.writeType(buffer);
	readType(buffer);
}

Arts::MidiCommand& Arts::MidiCommand::operator=(const Arts::MidiCommand& assignType)
{
	Arts::Buffer buffer;
	assignType.writeType(buffer);
	readType(buffer);
	return *this;
}

void Arts::MidiCommand::readType(Arts::Buffer& stream)
{
	status = stream.readByte();
	data1 = stream.readByte();
	data2 = stream.readByte();
}

void Arts::MidiCommand::writeType(Arts::Buffer& stream) const
{
	stream.writeByte(status);
	stream.writeByte(data1);
	stream.writeByte(data2);
}

std::string Arts::MidiCommand::_typeName() const
{
	return "Arts::MidiCommand";
}

Arts::MidiEvent::MidiEvent()
{
}

Arts::MidiEvent::MidiEvent(const Arts::TimeStamp& _a_time, const Arts::MidiCommand& _a_command)
{
	this->time = _a_time;
	this->command = _a_command;
}

Arts::MidiEvent::MidiEvent(Arts::Buffer& stream)
{
	readType(stream);
}

Arts::MidiEvent::MidiEvent(const Arts::MidiEvent& copyType) : Arts::Type(copyType)
{
	Arts::Buffer buffer;
	copyType.writeType(buffer);
	readType(buffer);
}

Arts::MidiEvent& Arts::MidiEvent::operator=(const Arts::MidiEvent& assignType)
{
	Arts::Buffer buffer;
	assignType.writeType(buffer);
	readType(buffer);
	return *this;
}

void Arts::MidiEvent::readType(Arts::Buffer& stream)
{
	time.readType(stream);
	command.readType(stream);
}

void Arts::MidiEvent::writeType(Arts::Buffer& stream) const
{
	time.writeType(stream);
	command.writeType(stream);
}

std::string Arts::MidiEvent::_typeName() const
{
	return "Arts::MidiEvent";
}

Arts::MidiClientInfo::MidiClientInfo()
{
}

Arts::MidiClientInfo::MidiClientInfo(long _a_ID, const std::vector<long>& _a_connections, Arts::MidiClientDirection _a_direction, Arts::MidiClientType _a_type, const std::string& _a_title, const std::string& _a_autoRestoreID)
{
	this->ID = _a_ID;
	this->connections = _a_connections;
	this->direction = _a_direction;
	this->type = _a_type;
	this->title = _a_title;
	this->autoRestoreID = _a_autoRestoreID;
}

Arts::MidiClientInfo::MidiClientInfo(Arts::Buffer& stream)
{
	readType(stream);
}

Arts::MidiClientInfo::MidiClientInfo(const Arts::MidiClientInfo& copyType) : Arts::Type(copyType)
{
	Arts::Buffer buffer;
	copyType.writeType(buffer);
	readType(buffer);
}

Arts::MidiClientInfo& Arts::MidiClientInfo::operator=(const Arts::MidiClientInfo& assignType)
{
	Arts::Buffer buffer;
	assignType.writeType(buffer);
	readType(buffer);
	return *this;
}

void Arts::MidiClientInfo::readType(Arts::Buffer& stream)
{
	ID = stream.readLong();
	stream.readLongSeq(connections);
	direction = (Arts::MidiClientDirection)stream.readLong();
	type = (Arts::MidiClientType)stream.readLong();
	stream.readString(title);
	stream.readString(autoRestoreID);
}

void Arts::MidiClientInfo::writeType(Arts::Buffer& stream) const
{
	stream.writeLong(ID);
	stream.writeLongSeq(connections);
	stream.writeLong(direction);
	stream.writeLong(type);
	stream.writeString(title);
	stream.writeString(autoRestoreID);
}

std::string Arts::MidiClientInfo::_typeName() const
{
	return "Arts::MidiClientInfo";
}

Arts::MidiPort_base *Arts::MidiPort_base::_create(const std::string& subClass)
{
	Arts::Object_skel *skel = Arts::ObjectManager::the()->create(subClass);
	assert(skel);
	Arts::MidiPort_base *castedObject = (Arts::MidiPort_base *)skel->_cast(Arts::MidiPort_base::_IID);
	assert(castedObject);
	return castedObject;
}

Arts::MidiPort_base *Arts::MidiPort_base::_fromString(const std::string& objectref)
{
	Arts::ObjectReference r;

	if(Arts::Dispatcher::the()->stringToObjectReference(r,objectref))
		return Arts::MidiPort_base::_fromReference(r,true);
	return 0;
}

Arts::MidiPort_base *Arts::MidiPort_base::_fromDynamicCast(const Arts::Object& object)
{
	if(object.isNull()) return 0;

	Arts::MidiPort_base *castedObject = (Arts::MidiPort_base *)object._base()->_cast(Arts::MidiPort_base::_IID);
	if(castedObject) return castedObject->_copy();

	return _fromString(object._toString());
}

Arts::MidiPort_base *Arts::MidiPort_base::_fromReference(Arts::ObjectReference r, bool needcopy)
{
	Arts::MidiPort_base *result;
	result = (Arts::MidiPort_base *)Arts::Dispatcher::the()->connectObjectLocal(r,"Arts::MidiPort");
	if(result)
	{
		if(!needcopy)
			result->_cancelCopyRemote();
	}
	else
	{
		Arts::Connection *conn = Arts::Dispatcher::the()->connectObjectRemote(r);
		if(conn)
		{
			result = new Arts::MidiPort_stub(conn,r.objectID);
			if(needcopy) result->_copyRemote();
			result->_useRemote();
			if (!result->_isCompatibleWith("Arts::MidiPort")) {
				result->_release();
				return 0;
			}
		}
	}
	return result;
}

std::vector<std::string> Arts::MidiPort_base::_defaultPortsIn() const {
	std::vector<std::string> ret;
	return ret;
}
std::vector<std::string> Arts::MidiPort_base::_defaultPortsOut() const {
	std::vector<std::string> ret;
	return ret;
}

void *Arts::MidiPort_base::_cast(unsigned long iid)
{
	if(iid == Arts::MidiPort_base::_IID) return (Arts::MidiPort_base *)this;
	if(iid == Arts::Object_base::_IID) return (Arts::Object_base *)this;
	return 0;
}

Arts::MidiPort_stub::MidiPort_stub()
{
	// constructor for subclasses (don't use directly)
}

Arts::MidiPort_stub::MidiPort_stub(Arts::Connection *connection, long objectID)
	: Arts::Object_stub(connection, objectID)
{
	// constructor to create a stub for an object
}

void Arts::MidiPort_stub::processCommand(const Arts::MidiCommand& command)
{
	long methodID = _lookupMethodFast("method:0000000f70726f63657373436f6d6d616e640000000005766f696400000000010000000100000012417274733a3a4d696469436f6d6d616e640000000008636f6d6d616e64000000000000000000");
	Arts::Buffer *request = Arts::Dispatcher::the()->createOnewayRequest(_objectID,methodID);
	command.writeType(*request);
	request->patchLength();
	_connection->qSendBuffer(request);

}

void Arts::MidiPort_stub::processEvent(const Arts::MidiEvent& event)
{
	long methodID = _lookupMethodFast("method:0000000d70726f636573734576656e740000000005766f696400000000010000000100000010417274733a3a4d6964694576656e7400000000066576656e74000000000000000000");
	Arts::Buffer *request = Arts::Dispatcher::the()->createOnewayRequest(_objectID,methodID);
	event.writeType(*request);
	request->patchLength();
	_connection->qSendBuffer(request);

}

Arts::TimeStamp Arts::MidiPort_stub::time()
{
	long methodID = _lookupMethodFast("method:0000000a5f6765745f74696d650000000010417274733a3a54696d655374616d7000000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return Arts::TimeStamp(); // error occurred
	Arts::TimeStamp _returnCode(*result);
	delete result;
	return _returnCode;
}

Arts::TimeStamp Arts::MidiPort_stub::playTime()
{
	long methodID = _lookupMethodFast("method:0000000e5f6765745f706c617954696d650000000010417274733a3a54696d655374616d7000000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return Arts::TimeStamp(); // error occurred
	Arts::TimeStamp _returnCode(*result);
	delete result;
	return _returnCode;
}

std::string Arts::MidiPort_skel::_interfaceName()
{
	return "Arts::MidiPort";
}

bool Arts::MidiPort_skel::_isCompatibleWith(const std::string& interfacename)
{
	if (interfacename == "Arts::MidiPort") return true;
	if (interfacename == "Arts::Object") return true;
	return false;
}

std::string Arts::MidiPort_skel::_interfaceNameSkel()
{
	return "Arts::MidiPort";
}

// processCommand
static void _dispatch_Arts_MidiPort_00(void *object, Arts::Buffer *request)
{
	Arts::MidiCommand command(*request);
	((Arts::MidiPort_skel *)object)->processCommand(command);
}

// processEvent
static void _dispatch_Arts_MidiPort_01(void *object, Arts::Buffer *request)
{
	Arts::MidiEvent event(*request);
	((Arts::MidiPort_skel *)object)->processEvent(event);
}

// _get_time
static void _dispatch_Arts_MidiPort_02(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	Arts::TimeStamp _returnCode = ((Arts::MidiPort_skel *)object)->time();
	_returnCode.writeType(*result);
}

// _get_playTime
static void _dispatch_Arts_MidiPort_03(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	Arts::TimeStamp _returnCode = ((Arts::MidiPort_skel *)object)->playTime();
	_returnCode.writeType(*result);
}

void Arts::MidiPort_skel::_buildMethodTable()
{
	Arts::Buffer m;
	m.fromString(
        "MethodTable:0000000f70726f63657373436f6d6d616e640000000005766f6964"
        "00000000010000000100000012417274733a3a4d696469436f6d6d616e64000000"
        "0008636f6d6d616e640000000000000000000000000d70726f636573734576656e"
        "740000000005766f696400000000010000000100000010417274733a3a4d696469"
        "4576656e7400000000066576656e740000000000000000000000000a5f6765745f"
        "74696d650000000010417274733a3a54696d655374616d70000000000200000000"
        "000000000000000e5f6765745f706c617954696d650000000010417274733a3a54"
        "696d655374616d7000000000020000000000000000",
		"MethodTable"
	);
	_addMethod(_dispatch_Arts_MidiPort_00,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_MidiPort_01,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_MidiPort_02,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_MidiPort_03,this,Arts::MethodDef(m));
}

Arts::MidiPort_skel::MidiPort_skel()
{
}

Arts::Object_base* Arts::MidiPort::_Creator() {
	return Arts::MidiPort_base::_create();
}

unsigned long Arts::MidiPort_base::_IID = Arts::MCOPUtils::makeIID("Arts::MidiPort");

Arts::MidiClient_base *Arts::MidiClient_base::_create(const std::string& subClass)
{
	Arts::Object_skel *skel = Arts::ObjectManager::the()->create(subClass);
	assert(skel);
	Arts::MidiClient_base *castedObject = (Arts::MidiClient_base *)skel->_cast(Arts::MidiClient_base::_IID);
	assert(castedObject);
	return castedObject;
}

Arts::MidiClient_base *Arts::MidiClient_base::_fromString(const std::string& objectref)
{
	Arts::ObjectReference r;

	if(Arts::Dispatcher::the()->stringToObjectReference(r,objectref))
		return Arts::MidiClient_base::_fromReference(r,true);
	return 0;
}

Arts::MidiClient_base *Arts::MidiClient_base::_fromDynamicCast(const Arts::Object& object)
{
	if(object.isNull()) return 0;

	Arts::MidiClient_base *castedObject = (Arts::MidiClient_base *)object._base()->_cast(Arts::MidiClient_base::_IID);
	if(castedObject) return castedObject->_copy();

	return _fromString(object._toString());
}

Arts::MidiClient_base *Arts::MidiClient_base::_fromReference(Arts::ObjectReference r, bool needcopy)
{
	Arts::MidiClient_base *result;
	result = (Arts::MidiClient_base *)Arts::Dispatcher::the()->connectObjectLocal(r,"Arts::MidiClient");
	if(result)
	{
		if(!needcopy)
			result->_cancelCopyRemote();
	}
	else
	{
		Arts::Connection *conn = Arts::Dispatcher::the()->connectObjectRemote(r);
		if(conn)
		{
			result = new Arts::MidiClient_stub(conn,r.objectID);
			if(needcopy) result->_copyRemote();
			result->_useRemote();
			if (!result->_isCompatibleWith("Arts::MidiClient")) {
				result->_release();
				return 0;
			}
		}
	}
	return result;
}

std::vector<std::string> Arts::MidiClient_base::_defaultPortsIn() const {
	std::vector<std::string> ret;
	return ret;
}
std::vector<std::string> Arts::MidiClient_base::_defaultPortsOut() const {
	std::vector<std::string> ret;
	return ret;
}

void *Arts::MidiClient_base::_cast(unsigned long iid)
{
	if(iid == Arts::MidiClient_base::_IID) return (Arts::MidiClient_base *)this;
	if(iid == Arts::Object_base::_IID) return (Arts::Object_base *)this;
	return 0;
}

Arts::MidiClient_stub::MidiClient_stub()
{
	// constructor for subclasses (don't use directly)
}

Arts::MidiClient_stub::MidiClient_stub(Arts::Connection *connection, long objectID)
	: Arts::Object_stub(connection, objectID)
{
	// constructor to create a stub for an object
}

void Arts::MidiClient_stub::addInputPort(Arts::MidiPort port)
{
	long methodID = _lookupMethodFast("method:0000000d616464496e707574506f72740000000005766f69640000000002000000010000000f417274733a3a4d696469506f72740000000005706f7274000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	Arts::writeObject(*request,port._base());
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

Arts::MidiPort Arts::MidiClient_stub::addOutputPort()
{
	long methodID = _lookupMethodFast("method:0000000e6164644f7574707574506f7274000000000f417274733a3a4d696469506f727400000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if (!result) return Arts::MidiPort::null();
	Arts::MidiPort_base* returnCode;
	Arts::readObject(*result,returnCode);
	delete result;
	return Arts::MidiPort::_from_base(returnCode);
}

void Arts::MidiClient_stub::removePort(Arts::MidiPort port)
{
	long methodID = _lookupMethodFast("method:0000000b72656d6f7665506f72740000000005766f69640000000002000000010000000f417274733a3a4d696469506f72740000000005706f7274000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	Arts::writeObject(*request,port._base());
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

Arts::MidiClientInfo Arts::MidiClient_stub::info()
{
	long methodID = _lookupMethodFast("method:0000000a5f6765745f696e666f0000000015417274733a3a4d696469436c69656e74496e666f00000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return Arts::MidiClientInfo(); // error occurred
	Arts::MidiClientInfo _returnCode(*result);
	delete result;
	return _returnCode;
}

std::string Arts::MidiClient_stub::title()
{
	long methodID = _lookupMethodFast("method:0000000b5f6765745f7469746c650000000007737472696e6700000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return""; // error occurred
	std::string returnCode;
	result->readString(returnCode);
	delete result;
	return returnCode;
}

void Arts::MidiClient_stub::title(const std::string& newValue)
{
	long methodID = _lookupMethodFast("method:0000000b5f7365745f7469746c650000000005766f696400000000020000000100000007737472696e6700000000096e657756616c7565000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeString(newValue);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

std::string Arts::MidiClient_skel::_interfaceName()
{
	return "Arts::MidiClient";
}

bool Arts::MidiClient_skel::_isCompatibleWith(const std::string& interfacename)
{
	if (interfacename == "Arts::MidiClient") return true;
	if (interfacename == "Arts::Object") return true;
	return false;
}

std::string Arts::MidiClient_skel::_interfaceNameSkel()
{
	return "Arts::MidiClient";
}

// addInputPort
static void _dispatch_Arts_MidiClient_00(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	Arts::MidiPort_base* _temp_port;
	Arts::readObject(*request,_temp_port);
	Arts::MidiPort port = Arts::MidiPort::_from_base(_temp_port);
	((Arts::MidiClient_skel *)object)->addInputPort(port);
}

// addOutputPort
static void _dispatch_Arts_MidiClient_01(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	Arts::MidiPort returnCode = ((Arts::MidiClient_skel *)object)->addOutputPort();
	Arts::writeObject(*result,returnCode._base());
}

// removePort
static void _dispatch_Arts_MidiClient_02(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	Arts::MidiPort_base* _temp_port;
	Arts::readObject(*request,_temp_port);
	Arts::MidiPort port = Arts::MidiPort::_from_base(_temp_port);
	((Arts::MidiClient_skel *)object)->removePort(port);
}

// _get_info
static void _dispatch_Arts_MidiClient_03(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	Arts::MidiClientInfo _returnCode = ((Arts::MidiClient_skel *)object)->info();
	_returnCode.writeType(*result);
}

// _get_title
static void _dispatch_Arts_MidiClient_04(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeString(((Arts::MidiClient_skel *)object)->title());
}

// _set_title
static void _dispatch_Arts_MidiClient_05(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	std::string newValue;
	request->readString(newValue);
	((Arts::MidiClient_skel *)object)->title(newValue);
}

void Arts::MidiClient_skel::_buildMethodTable()
{
	Arts::Buffer m;
	m.fromString(
        "MethodTable:0000000d616464496e707574506f72740000000005766f69640000"
        "000002000000010000000f417274733a3a4d696469506f72740000000005706f72"
        "740000000000000000000000000e6164644f7574707574506f7274000000000f41"
        "7274733a3a4d696469506f7274000000000200000000000000000000000b72656d"
        "6f7665506f72740000000005766f69640000000002000000010000000f41727473"
        "3a3a4d696469506f72740000000005706f72740000000000000000000000000a5f"
        "6765745f696e666f0000000015417274733a3a4d696469436c69656e74496e666f"
        "000000000200000000000000000000000b5f6765745f7469746c65000000000773"
        "7472696e67000000000200000000000000000000000b5f7365745f7469746c6500"
        "00000005766f696400000000020000000100000007737472696e6700000000096e"
        "657756616c7565000000000000000000",
		"MethodTable"
	);
	_addMethod(_dispatch_Arts_MidiClient_00,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_MidiClient_01,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_MidiClient_02,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_MidiClient_03,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_MidiClient_04,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_MidiClient_05,this,Arts::MethodDef(m));
}

Arts::MidiClient_skel::MidiClient_skel()
{
}

Arts::Object_base* Arts::MidiClient::_Creator() {
	return Arts::MidiClient_base::_create();
}

unsigned long Arts::MidiClient_base::_IID = Arts::MCOPUtils::makeIID("Arts::MidiClient");

Arts::MidiSyncGroup_base *Arts::MidiSyncGroup_base::_create(const std::string& subClass)
{
	Arts::Object_skel *skel = Arts::ObjectManager::the()->create(subClass);
	assert(skel);
	Arts::MidiSyncGroup_base *castedObject = (Arts::MidiSyncGroup_base *)skel->_cast(Arts::MidiSyncGroup_base::_IID);
	assert(castedObject);
	return castedObject;
}

Arts::MidiSyncGroup_base *Arts::MidiSyncGroup_base::_fromString(const std::string& objectref)
{
	Arts::ObjectReference r;

	if(Arts::Dispatcher::the()->stringToObjectReference(r,objectref))
		return Arts::MidiSyncGroup_base::_fromReference(r,true);
	return 0;
}

Arts::MidiSyncGroup_base *Arts::MidiSyncGroup_base::_fromDynamicCast(const Arts::Object& object)
{
	if(object.isNull()) return 0;

	Arts::MidiSyncGroup_base *castedObject = (Arts::MidiSyncGroup_base *)object._base()->_cast(Arts::MidiSyncGroup_base::_IID);
	if(castedObject) return castedObject->_copy();

	return _fromString(object._toString());
}

Arts::MidiSyncGroup_base *Arts::MidiSyncGroup_base::_fromReference(Arts::ObjectReference r, bool needcopy)
{
	Arts::MidiSyncGroup_base *result;
	result = (Arts::MidiSyncGroup_base *)Arts::Dispatcher::the()->connectObjectLocal(r,"Arts::MidiSyncGroup");
	if(result)
	{
		if(!needcopy)
			result->_cancelCopyRemote();
	}
	else
	{
		Arts::Connection *conn = Arts::Dispatcher::the()->connectObjectRemote(r);
		if(conn)
		{
			result = new Arts::MidiSyncGroup_stub(conn,r.objectID);
			if(needcopy) result->_copyRemote();
			result->_useRemote();
			if (!result->_isCompatibleWith("Arts::MidiSyncGroup")) {
				result->_release();
				return 0;
			}
		}
	}
	return result;
}

std::vector<std::string> Arts::MidiSyncGroup_base::_defaultPortsIn() const {
	std::vector<std::string> ret;
	return ret;
}
std::vector<std::string> Arts::MidiSyncGroup_base::_defaultPortsOut() const {
	std::vector<std::string> ret;
	return ret;
}

void *Arts::MidiSyncGroup_base::_cast(unsigned long iid)
{
	if(iid == Arts::MidiSyncGroup_base::_IID) return (Arts::MidiSyncGroup_base *)this;
	if(iid == Arts::Object_base::_IID) return (Arts::Object_base *)this;
	return 0;
}

Arts::MidiSyncGroup_stub::MidiSyncGroup_stub()
{
	// constructor for subclasses (don't use directly)
}

Arts::MidiSyncGroup_stub::MidiSyncGroup_stub(Arts::Connection *connection, long objectID)
	: Arts::Object_stub(connection, objectID)
{
	// constructor to create a stub for an object
}

void Arts::MidiSyncGroup_stub::addClient(Arts::MidiClient client)
{
	long methodID = _lookupMethodFast("method:0000000a616464436c69656e740000000005766f696400000000020000000100000011417274733a3a4d696469436c69656e740000000007636c69656e74000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	Arts::writeObject(*request,client._base());
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

void Arts::MidiSyncGroup_stub::removeClient(Arts::MidiClient client)
{
	long methodID = _lookupMethodFast("method:0000000d72656d6f7665436c69656e740000000005766f696400000000020000000100000011417274733a3a4d696469436c69656e740000000007636c69656e74000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	Arts::writeObject(*request,client._base());
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

void Arts::MidiSyncGroup_stub::addAudioSync(Arts::AudioSync audioSync)
{
	long methodID = _lookupMethodFast("method:0000000d616464417564696f53796e630000000005766f696400000000020000000100000010417274733a3a417564696f53796e63000000000a617564696f53796e63000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	Arts::writeObject(*request,audioSync._base());
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

void Arts::MidiSyncGroup_stub::removeAudioSync(Arts::AudioSync audioSync)
{
	long methodID = _lookupMethodFast("method:0000001072656d6f7665417564696f53796e630000000005766f696400000000020000000100000010417274733a3a417564696f53796e63000000000a617564696f53796e63000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	Arts::writeObject(*request,audioSync._base());
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

std::string Arts::MidiSyncGroup_skel::_interfaceName()
{
	return "Arts::MidiSyncGroup";
}

bool Arts::MidiSyncGroup_skel::_isCompatibleWith(const std::string& interfacename)
{
	if (interfacename == "Arts::MidiSyncGroup") return true;
	if (interfacename == "Arts::Object") return true;
	return false;
}

std::string Arts::MidiSyncGroup_skel::_interfaceNameSkel()
{
	return "Arts::MidiSyncGroup";
}

// addClient
static void _dispatch_Arts_MidiSyncGroup_00(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	Arts::MidiClient_base* _temp_client;
	Arts::readObject(*request,_temp_client);
	Arts::MidiClient client = Arts::MidiClient::_from_base(_temp_client);
	((Arts::MidiSyncGroup_skel *)object)->addClient(client);
}

// removeClient
static void _dispatch_Arts_MidiSyncGroup_01(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	Arts::MidiClient_base* _temp_client;
	Arts::readObject(*request,_temp_client);
	Arts::MidiClient client = Arts::MidiClient::_from_base(_temp_client);
	((Arts::MidiSyncGroup_skel *)object)->removeClient(client);
}

// addAudioSync
static void _dispatch_Arts_MidiSyncGroup_02(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	Arts::AudioSync_base* _temp_audioSync;
	Arts::readObject(*request,_temp_audioSync);
	Arts::AudioSync audioSync = Arts::AudioSync::_from_base(_temp_audioSync);
	((Arts::MidiSyncGroup_skel *)object)->addAudioSync(audioSync);
}

// removeAudioSync
static void _dispatch_Arts_MidiSyncGroup_03(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	Arts::AudioSync_base* _temp_audioSync;
	Arts::readObject(*request,_temp_audioSync);
	Arts::AudioSync audioSync = Arts::AudioSync::_from_base(_temp_audioSync);
	((Arts::MidiSyncGroup_skel *)object)->removeAudioSync(audioSync);
}

void Arts::MidiSyncGroup_skel::_buildMethodTable()
{
	Arts::Buffer m;
	m.fromString(
        "MethodTable:0000000a616464436c69656e740000000005766f69640000000002"
        "0000000100000011417274733a3a4d696469436c69656e740000000007636c6965"
        "6e740000000000000000000000000d72656d6f7665436c69656e74000000000576"
        "6f696400000000020000000100000011417274733a3a4d696469436c69656e7400"
        "00000007636c69656e740000000000000000000000000d616464417564696f5379"
        "6e630000000005766f696400000000020000000100000010417274733a3a417564"
        "696f53796e63000000000a617564696f53796e6300000000000000000000000010"
        "72656d6f7665417564696f53796e630000000005766f6964000000000200000001"
        "00000010417274733a3a417564696f53796e63000000000a617564696f53796e63"
        "000000000000000000",
		"MethodTable"
	);
	_addMethod(_dispatch_Arts_MidiSyncGroup_00,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_MidiSyncGroup_01,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_MidiSyncGroup_02,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_MidiSyncGroup_03,this,Arts::MethodDef(m));
}

Arts::MidiSyncGroup_skel::MidiSyncGroup_skel()
{
}

Arts::Object_base* Arts::MidiSyncGroup::_Creator() {
	return Arts::MidiSyncGroup_base::_create();
}

unsigned long Arts::MidiSyncGroup_base::_IID = Arts::MCOPUtils::makeIID("Arts::MidiSyncGroup");

Arts::MidiManager_base *Arts::MidiManager_base::_create(const std::string& subClass)
{
	Arts::Object_skel *skel = Arts::ObjectManager::the()->create(subClass);
	assert(skel);
	Arts::MidiManager_base *castedObject = (Arts::MidiManager_base *)skel->_cast(Arts::MidiManager_base::_IID);
	assert(castedObject);
	return castedObject;
}

Arts::MidiManager_base *Arts::MidiManager_base::_fromString(const std::string& objectref)
{
	Arts::ObjectReference r;

	if(Arts::Dispatcher::the()->stringToObjectReference(r,objectref))
		return Arts::MidiManager_base::_fromReference(r,true);
	return 0;
}

Arts::MidiManager_base *Arts::MidiManager_base::_fromDynamicCast(const Arts::Object& object)
{
	if(object.isNull()) return 0;

	Arts::MidiManager_base *castedObject = (Arts::MidiManager_base *)object._base()->_cast(Arts::MidiManager_base::_IID);
	if(castedObject) return castedObject->_copy();

	return _fromString(object._toString());
}

Arts::MidiManager_base *Arts::MidiManager_base::_fromReference(Arts::ObjectReference r, bool needcopy)
{
	Arts::MidiManager_base *result;
	result = (Arts::MidiManager_base *)Arts::Dispatcher::the()->connectObjectLocal(r,"Arts::MidiManager");
	if(result)
	{
		if(!needcopy)
			result->_cancelCopyRemote();
	}
	else
	{
		Arts::Connection *conn = Arts::Dispatcher::the()->connectObjectRemote(r);
		if(conn)
		{
			result = new Arts::MidiManager_stub(conn,r.objectID);
			if(needcopy) result->_copyRemote();
			result->_useRemote();
			if (!result->_isCompatibleWith("Arts::MidiManager")) {
				result->_release();
				return 0;
			}
		}
	}
	return result;
}

std::vector<std::string> Arts::MidiManager_base::_defaultPortsIn() const {
	std::vector<std::string> ret;
	return ret;
}
std::vector<std::string> Arts::MidiManager_base::_defaultPortsOut() const {
	std::vector<std::string> ret;
	return ret;
}

void *Arts::MidiManager_base::_cast(unsigned long iid)
{
	if(iid == Arts::MidiManager_base::_IID) return (Arts::MidiManager_base *)this;
	if(iid == Arts::Object_base::_IID) return (Arts::Object_base *)this;
	return 0;
}

Arts::MidiManager_stub::MidiManager_stub()
{
	// constructor for subclasses (don't use directly)
}

Arts::MidiManager_stub::MidiManager_stub(Arts::Connection *connection, long objectID)
	: Arts::Object_stub(connection, objectID)
{
	// constructor to create a stub for an object
}

Arts::MidiClient Arts::MidiManager_stub::addClient(Arts::MidiClientDirection direction, Arts::MidiClientType type, const std::string& title, const std::string& autoRestoreID)
{
	long methodID = _lookupMethodFast("method:0000000a616464436c69656e740000000011417274733a3a4d696469436c69656e740000000002000000040000001a417274733a3a4d696469436c69656e74446972656374696f6e000000000a646972656374696f6e000000000000000015417274733a3a4d696469436c69656e7454797065000000000574797065000000000000000007737472696e6700000000067469746c65000000000000000007737472696e67000000000e6175746f526573746f72654944000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeLong(direction);
	request->writeLong(type);
	request->writeString(title);
	request->writeString(autoRestoreID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if (!result) return Arts::MidiClient::null();
	Arts::MidiClient_base* returnCode;
	Arts::readObject(*result,returnCode);
	delete result;
	return Arts::MidiClient::_from_base(returnCode);
}

void Arts::MidiManager_stub::connect(long clientID, long destinationID)
{
	long methodID = _lookupMethodFast("method:00000008636f6e6e6563740000000005766f6964000000000200000002000000056c6f6e670000000009636c69656e7449440000000000000000056c6f6e67000000000e64657374696e6174696f6e4944000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeLong(clientID);
	request->writeLong(destinationID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

void Arts::MidiManager_stub::disconnect(long clientID, long destinationID)
{
	long methodID = _lookupMethodFast("method:0000000b646973636f6e6e6563740000000005766f6964000000000200000002000000056c6f6e670000000009636c69656e7449440000000000000000056c6f6e67000000000e64657374696e6174696f6e4944000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeLong(clientID);
	request->writeLong(destinationID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

Arts::MidiSyncGroup Arts::MidiManager_stub::addSyncGroup()
{
	long methodID = _lookupMethodFast("method:0000000d61646453796e6347726f75700000000014417274733a3a4d69646953796e6347726f757000000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if (!result) return Arts::MidiSyncGroup::null();
	Arts::MidiSyncGroup_base* returnCode;
	Arts::readObject(*result,returnCode);
	delete result;
	return Arts::MidiSyncGroup::_from_base(returnCode);
}

std::vector<Arts::MidiClientInfo> * Arts::MidiManager_stub::clients()
{
	long methodID = _lookupMethodFast("method:0000000d5f6765745f636c69656e747300000000162a417274733a3a4d696469436c69656e74496e666f00000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	std::vector<Arts::MidiClientInfo> *_returnCode = new std::vector<Arts::MidiClientInfo>;
	if(!result) return _returnCode; // error occurred
	Arts::readTypeSeq(*result,*_returnCode);
	delete result;
	return _returnCode;
}

std::string Arts::MidiManager_skel::_interfaceName()
{
	return "Arts::MidiManager";
}

bool Arts::MidiManager_skel::_isCompatibleWith(const std::string& interfacename)
{
	if (interfacename == "Arts::MidiManager") return true;
	if (interfacename == "Arts::Object") return true;
	return false;
}

std::string Arts::MidiManager_skel::_interfaceNameSkel()
{
	return "Arts::MidiManager";
}

// addClient
static void _dispatch_Arts_MidiManager_00(void *object, Arts::Buffer *request, Arts::Buffer *result)
{
	Arts::MidiClientDirection direction = (Arts::MidiClientDirection)request->readLong();
	Arts::MidiClientType type = (Arts::MidiClientType)request->readLong();
	std::string title;
	request->readString(title);
	std::string autoRestoreID;
	request->readString(autoRestoreID);
	Arts::MidiClient returnCode = ((Arts::MidiManager_skel *)object)->addClient(direction,type,title,autoRestoreID);
	Arts::writeObject(*result,returnCode._base());
}

// connect
static void _dispatch_Arts_MidiManager_01(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	long clientID = request->readLong();
	long destinationID = request->readLong();
	((Arts::MidiManager_skel *)object)->connect(clientID,destinationID);
}

// disconnect
static void _dispatch_Arts_MidiManager_02(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	long clientID = request->readLong();
	long destinationID = request->readLong();
	((Arts::MidiManager_skel *)object)->disconnect(clientID,destinationID);
}

// addSyncGroup
static void _dispatch_Arts_MidiManager_03(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	Arts::MidiSyncGroup returnCode = ((Arts::MidiManager_skel *)object)->addSyncGroup();
	Arts::writeObject(*result,returnCode._base());
}

// _get_clients
static void _dispatch_Arts_MidiManager_04(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	std::vector<Arts::MidiClientInfo> *_returnCode = ((Arts::MidiManager_skel *)object)->clients();
	Arts::writeTypeSeq(*result,*_returnCode);
	delete _returnCode;
}

void Arts::MidiManager_skel::_buildMethodTable()
{
	Arts::Buffer m;
	m.fromString(
        "MethodTable:0000000a616464436c69656e740000000011417274733a3a4d6964"
        "69436c69656e740000000002000000040000001a417274733a3a4d696469436c69"
        "656e74446972656374696f6e000000000a646972656374696f6e00000000000000"
        "0015417274733a3a4d696469436c69656e74547970650000000005747970650000"
        "00000000000007737472696e6700000000067469746c6500000000000000000773"
        "7472696e67000000000e6175746f526573746f7265494400000000000000000000"
        "000008636f6e6e6563740000000005766f6964000000000200000002000000056c"
        "6f6e670000000009636c69656e7449440000000000000000056c6f6e6700000000"
        "0e64657374696e6174696f6e49440000000000000000000000000b646973636f6e"
        "6e6563740000000005766f6964000000000200000002000000056c6f6e67000000"
        "0009636c69656e7449440000000000000000056c6f6e67000000000e6465737469"
        "6e6174696f6e49440000000000000000000000000d61646453796e6347726f7570"
        "0000000014417274733a3a4d69646953796e6347726f7570000000000200000000"
        "000000000000000d5f6765745f636c69656e747300000000162a417274733a3a4d"
        "696469436c69656e74496e666f00000000020000000000000000",
		"MethodTable"
	);
	_addMethod(_dispatch_Arts_MidiManager_00,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_MidiManager_01,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_MidiManager_02,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_MidiManager_03,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_MidiManager_04,this,Arts::MethodDef(m));
}

Arts::MidiManager_skel::MidiManager_skel()
{
}

Arts::Object_base* Arts::MidiManager::_Creator() {
	return Arts::MidiManager_base::_create();
}

unsigned long Arts::MidiManager_base::_IID = Arts::MCOPUtils::makeIID("Arts::MidiManager");

Arts::MidiTest_base *Arts::MidiTest_base::_create(const std::string& subClass)
{
	Arts::Object_skel *skel = Arts::ObjectManager::the()->create(subClass);
	assert(skel);
	Arts::MidiTest_base *castedObject = (Arts::MidiTest_base *)skel->_cast(Arts::MidiTest_base::_IID);
	assert(castedObject);
	return castedObject;
}

Arts::MidiTest_base *Arts::MidiTest_base::_fromString(const std::string& objectref)
{
	Arts::ObjectReference r;

	if(Arts::Dispatcher::the()->stringToObjectReference(r,objectref))
		return Arts::MidiTest_base::_fromReference(r,true);
	return 0;
}

Arts::MidiTest_base *Arts::MidiTest_base::_fromDynamicCast(const Arts::Object& object)
{
	if(object.isNull()) return 0;

	Arts::MidiTest_base *castedObject = (Arts::MidiTest_base *)object._base()->_cast(Arts::MidiTest_base::_IID);
	if(castedObject) return castedObject->_copy();

	return _fromString(object._toString());
}

Arts::MidiTest_base *Arts::MidiTest_base::_fromReference(Arts::ObjectReference r, bool needcopy)
{
	Arts::MidiTest_base *result;
	result = (Arts::MidiTest_base *)Arts::Dispatcher::the()->connectObjectLocal(r,"Arts::MidiTest");
	if(result)
	{
		if(!needcopy)
			result->_cancelCopyRemote();
	}
	else
	{
		Arts::Connection *conn = Arts::Dispatcher::the()->connectObjectRemote(r);
		if(conn)
		{
			result = new Arts::MidiTest_stub(conn,r.objectID);
			if(needcopy) result->_copyRemote();
			result->_useRemote();
			if (!result->_isCompatibleWith("Arts::MidiTest")) {
				result->_release();
				return 0;
			}
		}
	}
	return result;
}

std::vector<std::string> Arts::MidiTest_base::_defaultPortsIn() const {
	std::vector<std::string> ret;
	return ret;
}
std::vector<std::string> Arts::MidiTest_base::_defaultPortsOut() const {
	std::vector<std::string> ret;
	return ret;
}

void *Arts::MidiTest_base::_cast(unsigned long iid)
{
	if(iid == Arts::MidiTest_base::_IID) return (Arts::MidiTest_base *)this;
	if(iid == Arts::MidiPort_base::_IID) return (Arts::MidiPort_base *)this;
	if(iid == Arts::Object_base::_IID) return (Arts::Object_base *)this;
	return 0;
}

Arts::MidiTest_stub::MidiTest_stub()
{
	// constructor for subclasses (don't use directly)
}

Arts::MidiTest_stub::MidiTest_stub(Arts::Connection *connection, long objectID)
	: Arts::Object_stub(connection, objectID)
{
	// constructor to create a stub for an object
}

std::string Arts::MidiTest_skel::_interfaceName()
{
	return "Arts::MidiTest";
}

bool Arts::MidiTest_skel::_isCompatibleWith(const std::string& interfacename)
{
	if (interfacename == "Arts::MidiTest") return true;
	if (interfacename == "Arts::MidiPort") return true;
	if (interfacename == "Arts::Object") return true;
	return false;
}

std::string Arts::MidiTest_skel::_interfaceNameSkel()
{
	return "Arts::MidiTest";
}

void Arts::MidiTest_skel::_buildMethodTable()
{
	Arts::Buffer m;
	m.fromString(
        "MethodTable:",
		"MethodTable"
	);
	Arts::MidiPort_skel::_buildMethodTable();
}

Arts::MidiTest_skel::MidiTest_skel()
{
}

Arts::Object_base* Arts::MidiTest::_Creator() {
	return Arts::MidiTest_base::_create();
}

unsigned long Arts::MidiTest_base::_IID = Arts::MCOPUtils::makeIID("Arts::MidiTest");

Arts::RawMidiPort_base *Arts::RawMidiPort_base::_create(const std::string& subClass)
{
	Arts::Object_skel *skel = Arts::ObjectManager::the()->create(subClass);
	assert(skel);
	Arts::RawMidiPort_base *castedObject = (Arts::RawMidiPort_base *)skel->_cast(Arts::RawMidiPort_base::_IID);
	assert(castedObject);
	return castedObject;
}

Arts::RawMidiPort_base *Arts::RawMidiPort_base::_fromString(const std::string& objectref)
{
	Arts::ObjectReference r;

	if(Arts::Dispatcher::the()->stringToObjectReference(r,objectref))
		return Arts::RawMidiPort_base::_fromReference(r,true);
	return 0;
}

Arts::RawMidiPort_base *Arts::RawMidiPort_base::_fromDynamicCast(const Arts::Object& object)
{
	if(object.isNull()) return 0;

	Arts::RawMidiPort_base *castedObject = (Arts::RawMidiPort_base *)object._base()->_cast(Arts::RawMidiPort_base::_IID);
	if(castedObject) return castedObject->_copy();

	return _fromString(object._toString());
}

Arts::RawMidiPort_base *Arts::RawMidiPort_base::_fromReference(Arts::ObjectReference r, bool needcopy)
{
	Arts::RawMidiPort_base *result;
	result = (Arts::RawMidiPort_base *)Arts::Dispatcher::the()->connectObjectLocal(r,"Arts::RawMidiPort");
	if(result)
	{
		if(!needcopy)
			result->_cancelCopyRemote();
	}
	else
	{
		Arts::Connection *conn = Arts::Dispatcher::the()->connectObjectRemote(r);
		if(conn)
		{
			result = new Arts::RawMidiPort_stub(conn,r.objectID);
			if(needcopy) result->_copyRemote();
			result->_useRemote();
			if (!result->_isCompatibleWith("Arts::RawMidiPort")) {
				result->_release();
				return 0;
			}
		}
	}
	return result;
}

std::vector<std::string> Arts::RawMidiPort_base::_defaultPortsIn() const {
	std::vector<std::string> ret;
	return ret;
}
std::vector<std::string> Arts::RawMidiPort_base::_defaultPortsOut() const {
	std::vector<std::string> ret;
	return ret;
}

void *Arts::RawMidiPort_base::_cast(unsigned long iid)
{
	if(iid == Arts::RawMidiPort_base::_IID) return (Arts::RawMidiPort_base *)this;
	if(iid == Arts::MidiPort_base::_IID) return (Arts::MidiPort_base *)this;
	if(iid == Arts::Object_base::_IID) return (Arts::Object_base *)this;
	return 0;
}

Arts::RawMidiPort_stub::RawMidiPort_stub()
{
	// constructor for subclasses (don't use directly)
}

Arts::RawMidiPort_stub::RawMidiPort_stub(Arts::Connection *connection, long objectID)
	: Arts::Object_stub(connection, objectID)
{
	// constructor to create a stub for an object
}

bool Arts::RawMidiPort_stub::open()
{
	long methodID = _lookupMethodFast("method:000000056f70656e0000000008626f6f6c65616e00000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return false; // error occurred
	bool returnCode = result->readBool();
	delete result;
	return returnCode;
}

std::string Arts::RawMidiPort_stub::device()
{
	long methodID = _lookupMethodFast("method:0000000c5f6765745f6465766963650000000007737472696e6700000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return""; // error occurred
	std::string returnCode;
	result->readString(returnCode);
	delete result;
	return returnCode;
}

void Arts::RawMidiPort_stub::device(const std::string& newValue)
{
	long methodID = _lookupMethodFast("method:0000000c5f7365745f6465766963650000000005766f696400000000020000000100000007737472696e6700000000096e657756616c7565000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeString(newValue);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

bool Arts::RawMidiPort_stub::input()
{
	long methodID = _lookupMethodFast("method:0000000b5f6765745f696e7075740000000008626f6f6c65616e00000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return false; // error occurred
	bool returnCode = result->readBool();
	delete result;
	return returnCode;
}

void Arts::RawMidiPort_stub::input(bool newValue)
{
	long methodID = _lookupMethodFast("method:0000000b5f7365745f696e7075740000000005766f696400000000020000000100000008626f6f6c65616e00000000096e657756616c7565000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeBool(newValue);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

bool Arts::RawMidiPort_stub::output()
{
	long methodID = _lookupMethodFast("method:0000000c5f6765745f6f75747075740000000008626f6f6c65616e00000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return false; // error occurred
	bool returnCode = result->readBool();
	delete result;
	return returnCode;
}

void Arts::RawMidiPort_stub::output(bool newValue)
{
	long methodID = _lookupMethodFast("method:0000000c5f7365745f6f75747075740000000005766f696400000000020000000100000008626f6f6c65616e00000000096e657756616c7565000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeBool(newValue);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

bool Arts::RawMidiPort_stub::running()
{
	long methodID = _lookupMethodFast("method:0000000d5f6765745f72756e6e696e670000000008626f6f6c65616e00000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return false; // error occurred
	bool returnCode = result->readBool();
	delete result;
	return returnCode;
}

void Arts::RawMidiPort_stub::running(bool newValue)
{
	long methodID = _lookupMethodFast("method:0000000d5f7365745f72756e6e696e670000000005766f696400000000020000000100000008626f6f6c65616e00000000096e657756616c7565000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeBool(newValue);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

std::string Arts::RawMidiPort_skel::_interfaceName()
{
	return "Arts::RawMidiPort";
}

bool Arts::RawMidiPort_skel::_isCompatibleWith(const std::string& interfacename)
{
	if (interfacename == "Arts::RawMidiPort") return true;
	if (interfacename == "Arts::MidiPort") return true;
	if (interfacename == "Arts::Object") return true;
	return false;
}

std::string Arts::RawMidiPort_skel::_interfaceNameSkel()
{
	return "Arts::RawMidiPort";
}

// open
static void _dispatch_Arts_RawMidiPort_00(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeBool(((Arts::RawMidiPort_skel *)object)->open());
}

// _get_device
static void _dispatch_Arts_RawMidiPort_01(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeString(((Arts::RawMidiPort_skel *)object)->device());
}

// _set_device
static void _dispatch_Arts_RawMidiPort_02(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	std::string newValue;
	request->readString(newValue);
	((Arts::RawMidiPort_skel *)object)->device(newValue);
}

// _get_input
static void _dispatch_Arts_RawMidiPort_03(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeBool(((Arts::RawMidiPort_skel *)object)->input());
}

// _set_input
static void _dispatch_Arts_RawMidiPort_04(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	bool newValue = request->readBool();
	((Arts::RawMidiPort_skel *)object)->input(newValue);
}

// _get_output
static void _dispatch_Arts_RawMidiPort_05(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeBool(((Arts::RawMidiPort_skel *)object)->output());
}

// _set_output
static void _dispatch_Arts_RawMidiPort_06(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	bool newValue = request->readBool();
	((Arts::RawMidiPort_skel *)object)->output(newValue);
}

// _get_running
static void _dispatch_Arts_RawMidiPort_07(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeBool(((Arts::RawMidiPort_skel *)object)->running());
}

// _set_running
static void _dispatch_Arts_RawMidiPort_08(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	bool newValue = request->readBool();
	((Arts::RawMidiPort_skel *)object)->running(newValue);
}

void Arts::RawMidiPort_skel::_buildMethodTable()
{
	Arts::Buffer m;
	m.fromString(
        "MethodTable:000000056f70656e0000000008626f6f6c65616e00000000020000"
        "0000000000000000000c5f6765745f6465766963650000000007737472696e6700"
        "0000000200000000000000000000000c5f7365745f646576696365000000000576"
        "6f696400000000020000000100000007737472696e6700000000096e657756616c"
        "75650000000000000000000000000b5f6765745f696e7075740000000008626f6f"
        "6c65616e000000000200000000000000000000000b5f7365745f696e7075740000"
        "000005766f696400000000020000000100000008626f6f6c65616e00000000096e"
        "657756616c75650000000000000000000000000c5f6765745f6f75747075740000"
        "000008626f6f6c65616e000000000200000000000000000000000c5f7365745f6f"
        "75747075740000000005766f696400000000020000000100000008626f6f6c6561"
        "6e00000000096e657756616c75650000000000000000000000000d5f6765745f72"
        "756e6e696e670000000008626f6f6c65616e000000000200000000000000000000"
        "000d5f7365745f72756e6e696e670000000005766f696400000000020000000100"
        "000008626f6f6c65616e00000000096e657756616c7565000000000000000000",
		"MethodTable"
	);
	_addMethod(_dispatch_Arts_RawMidiPort_00,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_RawMidiPort_01,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_RawMidiPort_02,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_RawMidiPort_03,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_RawMidiPort_04,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_RawMidiPort_05,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_RawMidiPort_06,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_RawMidiPort_07,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_RawMidiPort_08,this,Arts::MethodDef(m));
	Arts::MidiPort_skel::_buildMethodTable();
}

Arts::RawMidiPort_skel::RawMidiPort_skel()
{
}

Arts::Object_base* Arts::RawMidiPort::_Creator() {
	return Arts::RawMidiPort_base::_create();
}

unsigned long Arts::RawMidiPort_base::_IID = Arts::MCOPUtils::makeIID("Arts::RawMidiPort");

Arts::AlsaMidiGateway_base *Arts::AlsaMidiGateway_base::_create(const std::string& subClass)
{
	Arts::Object_skel *skel = Arts::ObjectManager::the()->create(subClass);
	assert(skel);
	Arts::AlsaMidiGateway_base *castedObject = (Arts::AlsaMidiGateway_base *)skel->_cast(Arts::AlsaMidiGateway_base::_IID);
	assert(castedObject);
	return castedObject;
}

Arts::AlsaMidiGateway_base *Arts::AlsaMidiGateway_base::_fromString(const std::string& objectref)
{
	Arts::ObjectReference r;

	if(Arts::Dispatcher::the()->stringToObjectReference(r,objectref))
		return Arts::AlsaMidiGateway_base::_fromReference(r,true);
	return 0;
}

Arts::AlsaMidiGateway_base *Arts::AlsaMidiGateway_base::_fromDynamicCast(const Arts::Object& object)
{
	if(object.isNull()) return 0;

	Arts::AlsaMidiGateway_base *castedObject = (Arts::AlsaMidiGateway_base *)object._base()->_cast(Arts::AlsaMidiGateway_base::_IID);
	if(castedObject) return castedObject->_copy();

	return _fromString(object._toString());
}

Arts::AlsaMidiGateway_base *Arts::AlsaMidiGateway_base::_fromReference(Arts::ObjectReference r, bool needcopy)
{
	Arts::AlsaMidiGateway_base *result;
	result = (Arts::AlsaMidiGateway_base *)Arts::Dispatcher::the()->connectObjectLocal(r,"Arts::AlsaMidiGateway");
	if(result)
	{
		if(!needcopy)
			result->_cancelCopyRemote();
	}
	else
	{
		Arts::Connection *conn = Arts::Dispatcher::the()->connectObjectRemote(r);
		if(conn)
		{
			result = new Arts::AlsaMidiGateway_stub(conn,r.objectID);
			if(needcopy) result->_copyRemote();
			result->_useRemote();
			if (!result->_isCompatibleWith("Arts::AlsaMidiGateway")) {
				result->_release();
				return 0;
			}
		}
	}
	return result;
}

std::vector<std::string> Arts::AlsaMidiGateway_base::_defaultPortsIn() const {
	std::vector<std::string> ret;
	return ret;
}
std::vector<std::string> Arts::AlsaMidiGateway_base::_defaultPortsOut() const {
	std::vector<std::string> ret;
	return ret;
}

void *Arts::AlsaMidiGateway_base::_cast(unsigned long iid)
{
	if(iid == Arts::AlsaMidiGateway_base::_IID) return (Arts::AlsaMidiGateway_base *)this;
	if(iid == Arts::Object_base::_IID) return (Arts::Object_base *)this;
	return 0;
}

Arts::AlsaMidiGateway_stub::AlsaMidiGateway_stub()
{
	// constructor for subclasses (don't use directly)
}

Arts::AlsaMidiGateway_stub::AlsaMidiGateway_stub(Arts::Connection *connection, long objectID)
	: Arts::Object_stub(connection, objectID)
{
	// constructor to create a stub for an object
}

bool Arts::AlsaMidiGateway_stub::rescan()
{
	long methodID = _lookupMethodFast("method:0000000772657363616e0000000008626f6f6c65616e00000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return false; // error occurred
	bool returnCode = result->readBool();
	delete result;
	return returnCode;
}

std::string Arts::AlsaMidiGateway_skel::_interfaceName()
{
	return "Arts::AlsaMidiGateway";
}

bool Arts::AlsaMidiGateway_skel::_isCompatibleWith(const std::string& interfacename)
{
	if (interfacename == "Arts::AlsaMidiGateway") return true;
	if (interfacename == "Arts::Object") return true;
	return false;
}

std::string Arts::AlsaMidiGateway_skel::_interfaceNameSkel()
{
	return "Arts::AlsaMidiGateway";
}

// rescan
static void _dispatch_Arts_AlsaMidiGateway_00(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeBool(((Arts::AlsaMidiGateway_skel *)object)->rescan());
}

void Arts::AlsaMidiGateway_skel::_buildMethodTable()
{
	Arts::Buffer m;
	m.fromString(
        "MethodTable:0000000772657363616e0000000008626f6f6c65616e0000000002"
        "0000000000000000",
		"MethodTable"
	);
	_addMethod(_dispatch_Arts_AlsaMidiGateway_00,this,Arts::MethodDef(m));
}

Arts::AlsaMidiGateway_skel::AlsaMidiGateway_skel()
{
}

Arts::Object_base* Arts::AlsaMidiGateway::_Creator() {
	return Arts::AlsaMidiGateway_base::_create();
}

unsigned long Arts::AlsaMidiGateway_base::_IID = Arts::MCOPUtils::makeIID("Arts::AlsaMidiGateway");

Arts::AlsaMidiPort_base *Arts::AlsaMidiPort_base::_create(const std::string& subClass)
{
	Arts::Object_skel *skel = Arts::ObjectManager::the()->create(subClass);
	assert(skel);
	Arts::AlsaMidiPort_base *castedObject = (Arts::AlsaMidiPort_base *)skel->_cast(Arts::AlsaMidiPort_base::_IID);
	assert(castedObject);
	return castedObject;
}

Arts::AlsaMidiPort_base *Arts::AlsaMidiPort_base::_fromString(const std::string& objectref)
{
	Arts::ObjectReference r;

	if(Arts::Dispatcher::the()->stringToObjectReference(r,objectref))
		return Arts::AlsaMidiPort_base::_fromReference(r,true);
	return 0;
}

Arts::AlsaMidiPort_base *Arts::AlsaMidiPort_base::_fromDynamicCast(const Arts::Object& object)
{
	if(object.isNull()) return 0;

	Arts::AlsaMidiPort_base *castedObject = (Arts::AlsaMidiPort_base *)object._base()->_cast(Arts::AlsaMidiPort_base::_IID);
	if(castedObject) return castedObject->_copy();

	return _fromString(object._toString());
}

Arts::AlsaMidiPort_base *Arts::AlsaMidiPort_base::_fromReference(Arts::ObjectReference r, bool needcopy)
{
	Arts::AlsaMidiPort_base *result;
	result = (Arts::AlsaMidiPort_base *)Arts::Dispatcher::the()->connectObjectLocal(r,"Arts::AlsaMidiPort");
	if(result)
	{
		if(!needcopy)
			result->_cancelCopyRemote();
	}
	else
	{
		Arts::Connection *conn = Arts::Dispatcher::the()->connectObjectRemote(r);
		if(conn)
		{
			result = new Arts::AlsaMidiPort_stub(conn,r.objectID);
			if(needcopy) result->_copyRemote();
			result->_useRemote();
			if (!result->_isCompatibleWith("Arts::AlsaMidiPort")) {
				result->_release();
				return 0;
			}
		}
	}
	return result;
}

std::vector<std::string> Arts::AlsaMidiPort_base::_defaultPortsIn() const {
	std::vector<std::string> ret;
	return ret;
}
std::vector<std::string> Arts::AlsaMidiPort_base::_defaultPortsOut() const {
	std::vector<std::string> ret;
	return ret;
}

void *Arts::AlsaMidiPort_base::_cast(unsigned long iid)
{
	if(iid == Arts::AlsaMidiPort_base::_IID) return (Arts::AlsaMidiPort_base *)this;
	if(iid == Arts::MidiPort_base::_IID) return (Arts::MidiPort_base *)this;
	if(iid == Arts::Object_base::_IID) return (Arts::Object_base *)this;
	return 0;
}

Arts::AlsaMidiPort_stub::AlsaMidiPort_stub()
{
	// constructor for subclasses (don't use directly)
}

Arts::AlsaMidiPort_stub::AlsaMidiPort_stub(Arts::Connection *connection, long objectID)
	: Arts::Object_stub(connection, objectID)
{
	// constructor to create a stub for an object
}

bool Arts::AlsaMidiPort_stub::open()
{
	long methodID = _lookupMethodFast("method:000000056f70656e0000000008626f6f6c65616e00000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return false; // error occurred
	bool returnCode = result->readBool();
	delete result;
	return returnCode;
}

long Arts::AlsaMidiPort_stub::client()
{
	long methodID = _lookupMethodFast("method:0000000c5f6765745f636c69656e7400000000056c6f6e6700000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return 0; // error occurred
	long returnCode = result->readLong();
	delete result;
	return returnCode;
}

void Arts::AlsaMidiPort_stub::client(long newValue)
{
	long methodID = _lookupMethodFast("method:0000000c5f7365745f636c69656e740000000005766f6964000000000200000001000000056c6f6e6700000000096e657756616c7565000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeLong(newValue);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

long Arts::AlsaMidiPort_stub::port()
{
	long methodID = _lookupMethodFast("method:0000000a5f6765745f706f727400000000056c6f6e6700000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return 0; // error occurred
	long returnCode = result->readLong();
	delete result;
	return returnCode;
}

void Arts::AlsaMidiPort_stub::port(long newValue)
{
	long methodID = _lookupMethodFast("method:0000000a5f7365745f706f72740000000005766f6964000000000200000001000000056c6f6e6700000000096e657756616c7565000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeLong(newValue);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

std::string Arts::AlsaMidiPort_skel::_interfaceName()
{
	return "Arts::AlsaMidiPort";
}

bool Arts::AlsaMidiPort_skel::_isCompatibleWith(const std::string& interfacename)
{
	if (interfacename == "Arts::AlsaMidiPort") return true;
	if (interfacename == "Arts::MidiPort") return true;
	if (interfacename == "Arts::Object") return true;
	return false;
}

std::string Arts::AlsaMidiPort_skel::_interfaceNameSkel()
{
	return "Arts::AlsaMidiPort";
}

// open
static void _dispatch_Arts_AlsaMidiPort_00(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeBool(((Arts::AlsaMidiPort_skel *)object)->open());
}

// _get_client
static void _dispatch_Arts_AlsaMidiPort_01(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeLong(((Arts::AlsaMidiPort_skel *)object)->client());
}

// _set_client
static void _dispatch_Arts_AlsaMidiPort_02(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	long newValue = request->readLong();
	((Arts::AlsaMidiPort_skel *)object)->client(newValue);
}

// _get_port
static void _dispatch_Arts_AlsaMidiPort_03(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeLong(((Arts::AlsaMidiPort_skel *)object)->port());
}

// _set_port
static void _dispatch_Arts_AlsaMidiPort_04(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	long newValue = request->readLong();
	((Arts::AlsaMidiPort_skel *)object)->port(newValue);
}

void Arts::AlsaMidiPort_skel::_buildMethodTable()
{
	Arts::Buffer m;
	m.fromString(
        "MethodTable:000000056f70656e0000000008626f6f6c65616e00000000020000"
        "0000000000000000000c5f6765745f636c69656e7400000000056c6f6e67000000"
        "000200000000000000000000000c5f7365745f636c69656e740000000005766f69"
        "64000000000200000001000000056c6f6e6700000000096e657756616c75650000"
        "000000000000000000000a5f6765745f706f727400000000056c6f6e6700000000"
        "0200000000000000000000000a5f7365745f706f72740000000005766f69640000"
        "00000200000001000000056c6f6e6700000000096e657756616c75650000000000"
        "00000000",
		"MethodTable"
	);
	_addMethod(_dispatch_Arts_AlsaMidiPort_00,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_AlsaMidiPort_01,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_AlsaMidiPort_02,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_AlsaMidiPort_03,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_AlsaMidiPort_04,this,Arts::MethodDef(m));
	Arts::MidiPort_skel::_buildMethodTable();
}

Arts::AlsaMidiPort_skel::AlsaMidiPort_skel()
{
}

Arts::Object_base* Arts::AlsaMidiPort::_Creator() {
	return Arts::AlsaMidiPort_base::_create();
}

unsigned long Arts::AlsaMidiPort_base::_IID = Arts::MCOPUtils::makeIID("Arts::AlsaMidiPort");

Arts::AudioSync_base *Arts::AudioSync_base::_create(const std::string& subClass)
{
	Arts::Object_skel *skel = Arts::ObjectManager::the()->create(subClass);
	assert(skel);
	Arts::AudioSync_base *castedObject = (Arts::AudioSync_base *)skel->_cast(Arts::AudioSync_base::_IID);
	assert(castedObject);
	return castedObject;
}

Arts::AudioSync_base *Arts::AudioSync_base::_fromString(const std::string& objectref)
{
	Arts::ObjectReference r;

	if(Arts::Dispatcher::the()->stringToObjectReference(r,objectref))
		return Arts::AudioSync_base::_fromReference(r,true);
	return 0;
}

Arts::AudioSync_base *Arts::AudioSync_base::_fromDynamicCast(const Arts::Object& object)
{
	if(object.isNull()) return 0;

	Arts::AudioSync_base *castedObject = (Arts::AudioSync_base *)object._base()->_cast(Arts::AudioSync_base::_IID);
	if(castedObject) return castedObject->_copy();

	return _fromString(object._toString());
}

Arts::AudioSync_base *Arts::AudioSync_base::_fromReference(Arts::ObjectReference r, bool needcopy)
{
	Arts::AudioSync_base *result;
	result = (Arts::AudioSync_base *)Arts::Dispatcher::the()->connectObjectLocal(r,"Arts::AudioSync");
	if(result)
	{
		if(!needcopy)
			result->_cancelCopyRemote();
	}
	else
	{
		Arts::Connection *conn = Arts::Dispatcher::the()->connectObjectRemote(r);
		if(conn)
		{
			result = new Arts::AudioSync_stub(conn,r.objectID);
			if(needcopy) result->_copyRemote();
			result->_useRemote();
			if (!result->_isCompatibleWith("Arts::AudioSync")) {
				result->_release();
				return 0;
			}
		}
	}
	return result;
}

std::vector<std::string> Arts::AudioSync_base::_defaultPortsIn() const {
	std::vector<std::string> ret;
	return ret;
}
std::vector<std::string> Arts::AudioSync_base::_defaultPortsOut() const {
	std::vector<std::string> ret;
	return ret;
}

void *Arts::AudioSync_base::_cast(unsigned long iid)
{
	if(iid == Arts::AudioSync_base::_IID) return (Arts::AudioSync_base *)this;
	if(iid == Arts::Object_base::_IID) return (Arts::Object_base *)this;
	return 0;
}

Arts::AudioSync_stub::AudioSync_stub()
{
	// constructor for subclasses (don't use directly)
}

Arts::AudioSync_stub::AudioSync_stub(Arts::Connection *connection, long objectID)
	: Arts::Object_stub(connection, objectID)
{
	// constructor to create a stub for an object
}

void Arts::AudioSync_stub::queueStart(Arts::SynthModule synthModule)
{
	long methodID = _lookupMethodFast("method:0000000b717565756553746172740000000005766f696400000000020000000100000012417274733a3a53796e74684d6f64756c65000000000c73796e74684d6f64756c65000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	Arts::writeObject(*request,synthModule._base());
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

void Arts::AudioSync_stub::queueStop(Arts::SynthModule synthModule)
{
	long methodID = _lookupMethodFast("method:0000000a717565756553746f700000000005766f696400000000020000000100000012417274733a3a53796e74684d6f64756c65000000000c73796e74684d6f64756c65000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	Arts::writeObject(*request,synthModule._base());
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

void Arts::AudioSync_stub::execute()
{
	long methodID = _lookupMethodFast("method:00000008657865637574650000000005766f696400000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

void Arts::AudioSync_stub::executeAt(const Arts::TimeStamp& timeStamp)
{
	long methodID = _lookupMethodFast("method:0000000a6578656375746541740000000005766f696400000000020000000100000010417274733a3a54696d655374616d70000000000a74696d655374616d70000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	timeStamp.writeType(*request);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

Arts::TimeStamp Arts::AudioSync_stub::time()
{
	long methodID = _lookupMethodFast("method:0000000a5f6765745f74696d650000000010417274733a3a54696d655374616d7000000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return Arts::TimeStamp(); // error occurred
	Arts::TimeStamp _returnCode(*result);
	delete result;
	return _returnCode;
}

Arts::TimeStamp Arts::AudioSync_stub::playTime()
{
	long methodID = _lookupMethodFast("method:0000000e5f6765745f706c617954696d650000000010417274733a3a54696d655374616d7000000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return Arts::TimeStamp(); // error occurred
	Arts::TimeStamp _returnCode(*result);
	delete result;
	return _returnCode;
}

std::string Arts::AudioSync_skel::_interfaceName()
{
	return "Arts::AudioSync";
}

bool Arts::AudioSync_skel::_isCompatibleWith(const std::string& interfacename)
{
	if (interfacename == "Arts::AudioSync") return true;
	if (interfacename == "Arts::Object") return true;
	return false;
}

std::string Arts::AudioSync_skel::_interfaceNameSkel()
{
	return "Arts::AudioSync";
}

// queueStart
static void _dispatch_Arts_AudioSync_00(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	Arts::SynthModule_base* _temp_synthModule;
	Arts::readObject(*request,_temp_synthModule);
	Arts::SynthModule synthModule = Arts::SynthModule::_from_base(_temp_synthModule);
	((Arts::AudioSync_skel *)object)->queueStart(synthModule);
}

// queueStop
static void _dispatch_Arts_AudioSync_01(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	Arts::SynthModule_base* _temp_synthModule;
	Arts::readObject(*request,_temp_synthModule);
	Arts::SynthModule synthModule = Arts::SynthModule::_from_base(_temp_synthModule);
	((Arts::AudioSync_skel *)object)->queueStop(synthModule);
}

// execute
static void _dispatch_Arts_AudioSync_02(void *object, Arts::Buffer *, Arts::Buffer *)
{
	((Arts::AudioSync_skel *)object)->execute();
}

// executeAt
static void _dispatch_Arts_AudioSync_03(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	Arts::TimeStamp timeStamp(*request);
	((Arts::AudioSync_skel *)object)->executeAt(timeStamp);
}

// _get_time
static void _dispatch_Arts_AudioSync_04(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	Arts::TimeStamp _returnCode = ((Arts::AudioSync_skel *)object)->time();
	_returnCode.writeType(*result);
}

// _get_playTime
static void _dispatch_Arts_AudioSync_05(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	Arts::TimeStamp _returnCode = ((Arts::AudioSync_skel *)object)->playTime();
	_returnCode.writeType(*result);
}

void Arts::AudioSync_skel::_buildMethodTable()
{
	Arts::Buffer m;
	m.fromString(
        "MethodTable:0000000b717565756553746172740000000005766f696400000000"
        "020000000100000012417274733a3a53796e74684d6f64756c65000000000c7379"
        "6e74684d6f64756c650000000000000000000000000a717565756553746f700000"
        "000005766f696400000000020000000100000012417274733a3a53796e74684d6f"
        "64756c65000000000c73796e74684d6f64756c6500000000000000000000000008"
        "657865637574650000000005766f6964000000000200000000000000000000000a"
        "6578656375746541740000000005766f6964000000000200000001000000104172"
        "74733a3a54696d655374616d70000000000a74696d655374616d70000000000000"
        "0000000000000a5f6765745f74696d650000000010417274733a3a54696d655374"
        "616d70000000000200000000000000000000000e5f6765745f706c617954696d65"
        "0000000010417274733a3a54696d655374616d7000000000020000000000000000",
		"MethodTable"
	);
	_addMethod(_dispatch_Arts_AudioSync_00,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_AudioSync_01,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_AudioSync_02,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_AudioSync_03,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_AudioSync_04,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_AudioSync_05,this,Arts::MethodDef(m));
}

Arts::AudioSync_skel::AudioSync_skel()
{
}

Arts::Object_base* Arts::AudioSync::_Creator() {
	return Arts::AudioSync_base::_create();
}

unsigned long Arts::AudioSync_base::_IID = Arts::MCOPUtils::makeIID("Arts::AudioSync");

Arts::MidiTimer_base *Arts::MidiTimer_base::_create(const std::string& subClass)
{
	Arts::Object_skel *skel = Arts::ObjectManager::the()->create(subClass);
	assert(skel);
	Arts::MidiTimer_base *castedObject = (Arts::MidiTimer_base *)skel->_cast(Arts::MidiTimer_base::_IID);
	assert(castedObject);
	return castedObject;
}

Arts::MidiTimer_base *Arts::MidiTimer_base::_fromString(const std::string& objectref)
{
	Arts::ObjectReference r;

	if(Arts::Dispatcher::the()->stringToObjectReference(r,objectref))
		return Arts::MidiTimer_base::_fromReference(r,true);
	return 0;
}

Arts::MidiTimer_base *Arts::MidiTimer_base::_fromDynamicCast(const Arts::Object& object)
{
	if(object.isNull()) return 0;

	Arts::MidiTimer_base *castedObject = (Arts::MidiTimer_base *)object._base()->_cast(Arts::MidiTimer_base::_IID);
	if(castedObject) return castedObject->_copy();

	return _fromString(object._toString());
}

Arts::MidiTimer_base *Arts::MidiTimer_base::_fromReference(Arts::ObjectReference r, bool needcopy)
{
	Arts::MidiTimer_base *result;
	result = (Arts::MidiTimer_base *)Arts::Dispatcher::the()->connectObjectLocal(r,"Arts::MidiTimer");
	if(result)
	{
		if(!needcopy)
			result->_cancelCopyRemote();
	}
	else
	{
		Arts::Connection *conn = Arts::Dispatcher::the()->connectObjectRemote(r);
		if(conn)
		{
			result = new Arts::MidiTimer_stub(conn,r.objectID);
			if(needcopy) result->_copyRemote();
			result->_useRemote();
			if (!result->_isCompatibleWith("Arts::MidiTimer")) {
				result->_release();
				return 0;
			}
		}
	}
	return result;
}

std::vector<std::string> Arts::MidiTimer_base::_defaultPortsIn() const {
	std::vector<std::string> ret;
	return ret;
}
std::vector<std::string> Arts::MidiTimer_base::_defaultPortsOut() const {
	std::vector<std::string> ret;
	return ret;
}

void *Arts::MidiTimer_base::_cast(unsigned long iid)
{
	if(iid == Arts::MidiTimer_base::_IID) return (Arts::MidiTimer_base *)this;
	if(iid == Arts::Object_base::_IID) return (Arts::Object_base *)this;
	return 0;
}

Arts::MidiTimer_stub::MidiTimer_stub()
{
	// constructor for subclasses (don't use directly)
}

Arts::MidiTimer_stub::MidiTimer_stub(Arts::Connection *connection, long objectID)
	: Arts::Object_stub(connection, objectID)
{
	// constructor to create a stub for an object
}

void Arts::MidiTimer_stub::queueEvent(Arts::MidiPort port, const Arts::MidiEvent& event)
{
	long methodID = _lookupMethodFast("method:0000000b71756575654576656e740000000005766f69640000000001000000020000000f417274733a3a4d696469506f72740000000005706f7274000000000000000010417274733a3a4d6964694576656e7400000000066576656e74000000000000000000");
	Arts::Buffer *request = Arts::Dispatcher::the()->createOnewayRequest(_objectID,methodID);
	Arts::writeObject(*request,port._base());
	event.writeType(*request);
	request->patchLength();
	_connection->qSendBuffer(request);

}

Arts::TimeStamp Arts::MidiTimer_stub::time()
{
	long methodID = _lookupMethodFast("method:0000000a5f6765745f74696d650000000010417274733a3a54696d655374616d7000000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return Arts::TimeStamp(); // error occurred
	Arts::TimeStamp _returnCode(*result);
	delete result;
	return _returnCode;
}

std::string Arts::MidiTimer_skel::_interfaceName()
{
	return "Arts::MidiTimer";
}

bool Arts::MidiTimer_skel::_isCompatibleWith(const std::string& interfacename)
{
	if (interfacename == "Arts::MidiTimer") return true;
	if (interfacename == "Arts::Object") return true;
	return false;
}

std::string Arts::MidiTimer_skel::_interfaceNameSkel()
{
	return "Arts::MidiTimer";
}

// queueEvent
static void _dispatch_Arts_MidiTimer_00(void *object, Arts::Buffer *request)
{
	Arts::MidiPort_base* _temp_port;
	Arts::readObject(*request,_temp_port);
	Arts::MidiPort port = Arts::MidiPort::_from_base(_temp_port);
	Arts::MidiEvent event(*request);
	((Arts::MidiTimer_skel *)object)->queueEvent(port,event);
}

// _get_time
static void _dispatch_Arts_MidiTimer_01(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	Arts::TimeStamp _returnCode = ((Arts::MidiTimer_skel *)object)->time();
	_returnCode.writeType(*result);
}

void Arts::MidiTimer_skel::_buildMethodTable()
{
	Arts::Buffer m;
	m.fromString(
        "MethodTable:0000000b71756575654576656e740000000005766f696400000000"
        "01000000020000000f417274733a3a4d696469506f72740000000005706f727400"
        "0000000000000010417274733a3a4d6964694576656e7400000000066576656e74"
        "0000000000000000000000000a5f6765745f74696d650000000010417274733a3a"
        "54696d655374616d7000000000020000000000000000",
		"MethodTable"
	);
	_addMethod(_dispatch_Arts_MidiTimer_00,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_MidiTimer_01,this,Arts::MethodDef(m));
}

Arts::MidiTimer_skel::MidiTimer_skel()
{
}

Arts::Object_base* Arts::MidiTimer::_Creator() {
	return Arts::MidiTimer_base::_create();
}

unsigned long Arts::MidiTimer_base::_IID = Arts::MCOPUtils::makeIID("Arts::MidiTimer");

Arts::SystemMidiTimer_base *Arts::SystemMidiTimer_base::_create(const std::string& subClass)
{
	Arts::Object_skel *skel = Arts::ObjectManager::the()->create(subClass);
	assert(skel);
	Arts::SystemMidiTimer_base *castedObject = (Arts::SystemMidiTimer_base *)skel->_cast(Arts::SystemMidiTimer_base::_IID);
	assert(castedObject);
	return castedObject;
}

Arts::SystemMidiTimer_base *Arts::SystemMidiTimer_base::_fromString(const std::string& objectref)
{
	Arts::ObjectReference r;

	if(Arts::Dispatcher::the()->stringToObjectReference(r,objectref))
		return Arts::SystemMidiTimer_base::_fromReference(r,true);
	return 0;
}

Arts::SystemMidiTimer_base *Arts::SystemMidiTimer_base::_fromDynamicCast(const Arts::Object& object)
{
	if(object.isNull()) return 0;

	Arts::SystemMidiTimer_base *castedObject = (Arts::SystemMidiTimer_base *)object._base()->_cast(Arts::SystemMidiTimer_base::_IID);
	if(castedObject) return castedObject->_copy();

	return _fromString(object._toString());
}

Arts::SystemMidiTimer_base *Arts::SystemMidiTimer_base::_fromReference(Arts::ObjectReference r, bool needcopy)
{
	Arts::SystemMidiTimer_base *result;
	result = (Arts::SystemMidiTimer_base *)Arts::Dispatcher::the()->connectObjectLocal(r,"Arts::SystemMidiTimer");
	if(result)
	{
		if(!needcopy)
			result->_cancelCopyRemote();
	}
	else
	{
		Arts::Connection *conn = Arts::Dispatcher::the()->connectObjectRemote(r);
		if(conn)
		{
			result = new Arts::SystemMidiTimer_stub(conn,r.objectID);
			if(needcopy) result->_copyRemote();
			result->_useRemote();
			if (!result->_isCompatibleWith("Arts::SystemMidiTimer")) {
				result->_release();
				return 0;
			}
		}
	}
	return result;
}

std::vector<std::string> Arts::SystemMidiTimer_base::_defaultPortsIn() const {
	std::vector<std::string> ret;
	return ret;
}
std::vector<std::string> Arts::SystemMidiTimer_base::_defaultPortsOut() const {
	std::vector<std::string> ret;
	return ret;
}

void *Arts::SystemMidiTimer_base::_cast(unsigned long iid)
{
	if(iid == Arts::SystemMidiTimer_base::_IID) return (Arts::SystemMidiTimer_base *)this;
	if(iid == Arts::MidiTimer_base::_IID) return (Arts::MidiTimer_base *)this;
	if(iid == Arts::Object_base::_IID) return (Arts::Object_base *)this;
	return 0;
}

Arts::SystemMidiTimer_stub::SystemMidiTimer_stub()
{
	// constructor for subclasses (don't use directly)
}

Arts::SystemMidiTimer_stub::SystemMidiTimer_stub(Arts::Connection *connection, long objectID)
	: Arts::Object_stub(connection, objectID)
{
	// constructor to create a stub for an object
}

std::string Arts::SystemMidiTimer_skel::_interfaceName()
{
	return "Arts::SystemMidiTimer";
}

bool Arts::SystemMidiTimer_skel::_isCompatibleWith(const std::string& interfacename)
{
	if (interfacename == "Arts::SystemMidiTimer") return true;
	if (interfacename == "Arts::MidiTimer") return true;
	if (interfacename == "Arts::Object") return true;
	return false;
}

std::string Arts::SystemMidiTimer_skel::_interfaceNameSkel()
{
	return "Arts::SystemMidiTimer";
}

void Arts::SystemMidiTimer_skel::_buildMethodTable()
{
	Arts::Buffer m;
	m.fromString(
        "MethodTable:",
		"MethodTable"
	);
	Arts::MidiTimer_skel::_buildMethodTable();
}

Arts::SystemMidiTimer_skel::SystemMidiTimer_skel()
{
}

Arts::Object_base* Arts::SystemMidiTimer::_Creator() {
	return Arts::SystemMidiTimer_base::_create();
}

unsigned long Arts::SystemMidiTimer_base::_IID = Arts::MCOPUtils::makeIID("Arts::SystemMidiTimer");

Arts::AudioMidiTimer_base *Arts::AudioMidiTimer_base::_create(const std::string& subClass)
{
	Arts::Object_skel *skel = Arts::ObjectManager::the()->create(subClass);
	assert(skel);
	Arts::AudioMidiTimer_base *castedObject = (Arts::AudioMidiTimer_base *)skel->_cast(Arts::AudioMidiTimer_base::_IID);
	assert(castedObject);
	return castedObject;
}

Arts::AudioMidiTimer_base *Arts::AudioMidiTimer_base::_fromString(const std::string& objectref)
{
	Arts::ObjectReference r;

	if(Arts::Dispatcher::the()->stringToObjectReference(r,objectref))
		return Arts::AudioMidiTimer_base::_fromReference(r,true);
	return 0;
}

Arts::AudioMidiTimer_base *Arts::AudioMidiTimer_base::_fromDynamicCast(const Arts::Object& object)
{
	if(object.isNull()) return 0;

	Arts::AudioMidiTimer_base *castedObject = (Arts::AudioMidiTimer_base *)object._base()->_cast(Arts::AudioMidiTimer_base::_IID);
	if(castedObject) return castedObject->_copy();

	return _fromString(object._toString());
}

Arts::AudioMidiTimer_base *Arts::AudioMidiTimer_base::_fromReference(Arts::ObjectReference r, bool needcopy)
{
	Arts::AudioMidiTimer_base *result;
	result = (Arts::AudioMidiTimer_base *)Arts::Dispatcher::the()->connectObjectLocal(r,"Arts::AudioMidiTimer");
	if(result)
	{
		if(!needcopy)
			result->_cancelCopyRemote();
	}
	else
	{
		Arts::Connection *conn = Arts::Dispatcher::the()->connectObjectRemote(r);
		if(conn)
		{
			result = new Arts::AudioMidiTimer_stub(conn,r.objectID);
			if(needcopy) result->_copyRemote();
			result->_useRemote();
			if (!result->_isCompatibleWith("Arts::AudioMidiTimer")) {
				result->_release();
				return 0;
			}
		}
	}
	return result;
}

std::vector<std::string> Arts::AudioMidiTimer_base::_defaultPortsIn() const {
	std::vector<std::string> ret;
	return ret;
}
std::vector<std::string> Arts::AudioMidiTimer_base::_defaultPortsOut() const {
	std::vector<std::string> ret;
	return ret;
}

void *Arts::AudioMidiTimer_base::_cast(unsigned long iid)
{
	if(iid == Arts::AudioMidiTimer_base::_IID) return (Arts::AudioMidiTimer_base *)this;
	if(iid == Arts::MidiTimer_base::_IID) return (Arts::MidiTimer_base *)this;
	if(iid == Arts::Object_base::_IID) return (Arts::Object_base *)this;
	return 0;
}

Arts::AudioMidiTimer_stub::AudioMidiTimer_stub()
{
	// constructor for subclasses (don't use directly)
}

Arts::AudioMidiTimer_stub::AudioMidiTimer_stub(Arts::Connection *connection, long objectID)
	: Arts::Object_stub(connection, objectID)
{
	// constructor to create a stub for an object
}

std::string Arts::AudioMidiTimer_skel::_interfaceName()
{
	return "Arts::AudioMidiTimer";
}

bool Arts::AudioMidiTimer_skel::_isCompatibleWith(const std::string& interfacename)
{
	if (interfacename == "Arts::AudioMidiTimer") return true;
	if (interfacename == "Arts::MidiTimer") return true;
	if (interfacename == "Arts::Object") return true;
	return false;
}

std::string Arts::AudioMidiTimer_skel::_interfaceNameSkel()
{
	return "Arts::AudioMidiTimer";
}

void Arts::AudioMidiTimer_skel::_buildMethodTable()
{
	Arts::Buffer m;
	m.fromString(
        "MethodTable:",
		"MethodTable"
	);
	Arts::MidiTimer_skel::_buildMethodTable();
}

Arts::AudioMidiTimer_skel::AudioMidiTimer_skel()
{
}

Arts::Object_base* Arts::AudioMidiTimer::_Creator() {
	return Arts::AudioMidiTimer_base::_create();
}

unsigned long Arts::AudioMidiTimer_base::_IID = Arts::MCOPUtils::makeIID("Arts::AudioMidiTimer");

static Arts::IDLFileReg IDLFileReg_artsmidi("artsmidi",
    "IDLFile:00000001000000000400000018417274733a3a4d696469436f6d6d616e6453"
    "746174757300000000090000000f6d6373436f6d6d616e644d61736b00000000f00000"
    "00000000000f6d63734368616e6e656c4d61736b000000000f000000000000000b6d63"
    "734e6f74654f66660000000080000000000000000a6d63734e6f74654f6e0000000090"
    "000000000000000f6d63734b6579507265737375726500000000a0000000000000000d"
    "6d6373506172616d6574657200000000b0000000000000000b6d637350726f6772616d"
    "00000000c000000000000000136d63734368616e6e656c507265737375726500000000"
    "d0000000000000000e6d63735069746368576865656c00000000e00000000000000000"
    "0000001b417274733a3a4d696469436f6d6d616e64506172616d657465720000000002"
    "0000000b6d63705375737461696e0000000040000000000000000f6d6370416c6c4e6f"
    "7465734f6666000000007b00000000000000000000001a417274733a3a4d696469436c"
    "69656e74446972656374696f6e0000000002000000086d6364506c6179000000000000"
    "0000000000000a6d63645265636f726400000000010000000000000000000000154172"
    "74733a3a4d696469436c69656e745479706500000000020000000f6d63744465737469"
    "6e6174696f6e0000000000000000000000000f6d63744170706c69636174696f6e0000"
    "00000100000000000000000000000400000010417274733a3a54696d655374616d7000"
    "00000002000000056c6f6e6700000000047365630000000000000000056c6f6e670000"
    "0000057573656300000000000000000000000012417274733a3a4d696469436f6d6d61"
    "6e64000000000300000005627974650000000007737461747573000000000000000005"
    "6279746500000000066461746131000000000000000005627974650000000006646174"
    "613200000000000000000000000010417274733a3a4d6964694576656e740000000002"
    "00000010417274733a3a54696d655374616d70000000000574696d6500000000000000"
    "0012417274733a3a4d696469436f6d6d616e640000000008636f6d6d616e6400000000"
    "000000000000000015417274733a3a4d696469436c69656e74496e666f000000000600"
    "0000056c6f6e67000000000349440000000000000000062a6c6f6e67000000000c636f"
    "6e6e656374696f6e7300000000000000001a417274733a3a4d696469436c69656e7444"
    "6972656374696f6e000000000a646972656374696f6e00000000000000001541727473"
    "3a3a4d696469436c69656e745479706500000000057479706500000000000000000773"
    "7472696e6700000000067469746c65000000000000000007737472696e67000000000e"
    "6175746f526573746f726549440000000000000000000000000c0000000f417274733a"
    "3a4d696469506f72740000000000000000020000000f70726f63657373436f6d6d616e"
    "640000000005766f696400000000010000000100000012417274733a3a4d696469436f"
    "6d6d616e640000000008636f6d6d616e640000000000000000000000000d70726f6365"
    "73734576656e740000000005766f696400000000010000000100000010417274733a3a"
    "4d6964694576656e7400000000066576656e7400000000000000000000000002000000"
    "0574696d650000000010417274733a3a54696d655374616d7000000000120000000000"
    "000009706c617954696d650000000010417274733a3a54696d655374616d7000000000"
    "1200000000000000000000000000000011417274733a3a4d696469436c69656e740000"
    "000000000000030000000d616464496e707574506f72740000000005766f6964000000"
    "0002000000010000000f417274733a3a4d696469506f72740000000005706f72740000"
    "000000000000000000000e6164644f7574707574506f7274000000000f417274733a3a"
    "4d696469506f7274000000000200000000000000000000000b72656d6f7665506f7274"
    "0000000005766f69640000000002000000010000000f417274733a3a4d696469506f72"
    "740000000005706f72740000000000000000000000000200000005696e666f00000000"
    "15417274733a3a4d696469436c69656e74496e666f0000000012000000000000000674"
    "69746c650000000007737472696e670000000013000000000000000000000000000000"
    "14417274733a3a4d69646953796e6347726f75700000000000000000040000000a6164"
    "64436c69656e740000000005766f696400000000020000000100000011417274733a3a"
    "4d696469436c69656e740000000007636c69656e740000000000000000000000000d72"
    "656d6f7665436c69656e740000000005766f6964000000000200000001000000114172"
    "74733a3a4d696469436c69656e740000000007636c69656e7400000000000000000000"
    "00000d616464417564696f53796e630000000005766f69640000000002000000010000"
    "0010417274733a3a417564696f53796e63000000000a617564696f53796e6300000000"
    "00000000000000001072656d6f7665417564696f53796e630000000005766f69640000"
    "0000020000000100000010417274733a3a417564696f53796e63000000000a61756469"
    "6f53796e6300000000000000000000000000000000000000000000000012417274733a"
    "3a4d6964694d616e616765720000000000000000040000000a616464436c69656e7400"
    "00000011417274733a3a4d696469436c69656e740000000002000000040000001a4172"
    "74733a3a4d696469436c69656e74446972656374696f6e000000000a64697265637469"
    "6f6e000000000000000015417274733a3a4d696469436c69656e745479706500000000"
    "0574797065000000000000000007737472696e6700000000067469746c650000000000"
    "00000007737472696e67000000000e6175746f526573746f7265494400000000000000"
    "000000000008636f6e6e6563740000000005766f696400000000020000000200000005"
    "6c6f6e670000000009636c69656e7449440000000000000000056c6f6e67000000000e"
    "64657374696e6174696f6e49440000000000000000000000000b646973636f6e6e6563"
    "740000000005766f6964000000000200000002000000056c6f6e670000000009636c69"
    "656e7449440000000000000000056c6f6e67000000000e64657374696e6174696f6e49"
    "440000000000000000000000000d61646453796e6347726f7570000000001441727473"
    "3a3a4d69646953796e6347726f75700000000002000000000000000000000001000000"
    "08636c69656e747300000000162a417274733a3a4d696469436c69656e74496e666f00"
    "000000120000000000000000000000000000000f417274733a3a4d6964695465737400"
    "000000010000000f417274733a3a4d696469506f727400000000000000000000000000"
    "0000000000000012417274733a3a5261774d696469506f727400000000010000000f41"
    "7274733a3a4d696469506f72740000000001000000056f70656e0000000008626f6f6c"
    "65616e0000000002000000000000000000000004000000076465766963650000000007"
    "737472696e6700000000130000000000000006696e7075740000000008626f6f6c6561"
    "6e000000001300000000000000076f75747075740000000008626f6f6c65616e000000"
    "0013000000000000000872756e6e696e670000000008626f6f6c65616e000000001300"
    "000000000000000000000000000016417274733a3a416c73614d696469476174657761"
    "790000000000000000010000000772657363616e0000000008626f6f6c65616e000000"
    "0002000000000000000000000000000000000000000000000013417274733a3a416c73"
    "614d696469506f727400000000010000000f417274733a3a4d696469506f7274000000"
    "0001000000056f70656e0000000008626f6f6c65616e00000000020000000000000000"
    "0000000200000007636c69656e7400000000056c6f6e67000000001300000000000000"
    "05706f727400000000056c6f6e67000000001300000000000000000000000000000010"
    "417274733a3a417564696f53796e630000000000000000040000000b71756575655374"
    "6172740000000005766f696400000000020000000100000012417274733a3a53796e74"
    "684d6f64756c65000000000c73796e74684d6f64756c65000000000000000000000000"
    "0a717565756553746f700000000005766f696400000000020000000100000012417274"
    "733a3a53796e74684d6f64756c65000000000c73796e74684d6f64756c650000000000"
    "0000000000000008657865637574650000000005766f69640000000002000000000000"
    "00000000000a6578656375746541740000000005766f69640000000002000000010000"
    "0010417274733a3a54696d655374616d70000000000a74696d655374616d7000000000"
    "0000000000000000020000000574696d650000000010417274733a3a54696d65537461"
    "6d7000000000120000000000000009706c617954696d650000000010417274733a3a54"
    "696d655374616d70000000001200000000000000000000000000000010417274733a3a"
    "4d69646954696d65720000000000000000010000000b71756575654576656e74000000"
    "0005766f69640000000001000000020000000f417274733a3a4d696469506f72740000"
    "000005706f7274000000000000000010417274733a3a4d6964694576656e7400000000"
    "066576656e74000000000000000000000000010000000574696d650000000010417274"
    "733a3a54696d655374616d700000000012000000000000000000000000000000164172"
    "74733a3a53797374656d4d69646954696d6572000000000100000010417274733a3a4d"
    "69646954696d6572000000000000000000000000000000000000000015417274733a3a"
    "417564696f4d69646954696d6572000000000100000010417274733a3a4d6964695469"
    "6d6572000000000000000000000000000000000000000000"
);
